/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.builder.ConnectedStatusAnnouncedOperation;
import com.pubnub.api.builder.NoOpOperation;
import com.pubnub.api.builder.PresenceOperation;
import com.pubnub.api.builder.PubSubOperation;
import com.pubnub.api.builder.StateOperation;
import com.pubnub.api.builder.SubscribeOperation;
import com.pubnub.api.builder.TimetokenRegionOperation;
import com.pubnub.api.builder.UnsubscribeOperation;
import com.pubnub.api.managers.SubscriptionStateData;
import com.pubnub.api.models.SubscriptionItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\"H\u0002J#\u0010#\u001a\u00020\u00152\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%\"\u00020&H\u0000\u00a2\u0006\u0004\b'\u0010(J\b\u0010)\u001a\u00020\u000fH\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0006\u0010,\u001a\u00020\u000fH\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0006\u0010,\u001a\u00020\u000fH\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0006\u0010,\u001a\u00020\u000fH\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0006\u0010,\u001a\u00020\u000fH\u0002J>\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\"2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\"2\u0006\u0010,\u001a\u00020\u000fH\u0002J\u0015\u00103\u001a\u0002042\u0006\u0010,\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b5R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/pubnub/api/managers/StateManager;", "", "()V", "channels", "Ljava/util/HashMap;", "", "Lcom/pubnub/api/models/SubscriptionItem;", "Lkotlin/collections/HashMap;", "groups", "heartbeatChannels", "heartbeatGroups", "presenceChannels", "presenceGroups", "region", "shouldAnnounce", "", "storedTimetoken", "", "Ljava/lang/Long;", "timetoken", "adaptPresenceBuilder", "", "presenceOperation", "Lcom/pubnub/api/builder/PresenceOperation;", "adaptStateBuilder", "stateOperation", "Lcom/pubnub/api/builder/StateOperation;", "adaptSubscribeBuilder", "subscribeOperation", "Lcom/pubnub/api/builder/SubscribeOperation;", "adaptUnsubscribeBuilder", "unsubscribeOperation", "Lcom/pubnub/api/builder/UnsubscribeOperation;", "createStatePayload", "", "handleOperation", "pubSubOperations", "", "Lcom/pubnub/api/builder/PubSubOperation;", "handleOperation$pubnub_kotlin", "([Lcom/pubnub/api/builder/PubSubOperation;)V", "isEmpty", "prepareChannelGroupList", "", "includePresence", "prepareChannelList", "prepareHeartbeatChannelGroupList", "prepareHeartbeatChannelList", "prepareMembershipList", "dataStorage", "presenceStorage", "subscriptionStateData", "Lcom/pubnub/api/managers/SubscriptionStateData;", "subscriptionStateData$pubnub_kotlin", "pubnub-kotlin"})
public final class StateManager {
    @NotNull
    private final HashMap<String, SubscriptionItem> channels = new HashMap();
    @NotNull
    private final HashMap<String, SubscriptionItem> presenceChannels = new HashMap();
    @NotNull
    private final HashMap<String, SubscriptionItem> groups = new HashMap();
    @NotNull
    private final HashMap<String, SubscriptionItem> presenceGroups = new HashMap();
    @NotNull
    private final HashMap<String, SubscriptionItem> heartbeatChannels = new HashMap();
    @NotNull
    private final HashMap<String, SubscriptionItem> heartbeatGroups = new HashMap();
    @Nullable
    private String region;
    private long timetoken;
    @Nullable
    private Long storedTimetoken;
    private boolean shouldAnnounce;

    public final synchronized void handleOperation$pubnub_kotlin(PubSubOperation ... pubSubOperations) {
        Intrinsics.checkNotNullParameter((Object)pubSubOperations, (String)"pubSubOperations");
        PubSubOperation[] $this$forEach$iv = pubSubOperations;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            PubSubOperation element$iv;
            PubSubOperation pubSubOperation = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            PubSubOperation pubSubOperation2 = pubSubOperation;
            if (pubSubOperation2 instanceof SubscribeOperation) {
                this.adaptSubscribeBuilder((SubscribeOperation)pubSubOperation);
                this.shouldAnnounce = true;
                continue;
            }
            if (pubSubOperation2 instanceof UnsubscribeOperation) {
                this.adaptUnsubscribeBuilder((UnsubscribeOperation)pubSubOperation);
                this.shouldAnnounce = true;
                continue;
            }
            if (pubSubOperation2 instanceof PresenceOperation) {
                this.adaptPresenceBuilder((PresenceOperation)pubSubOperation);
                continue;
            }
            if (pubSubOperation2 instanceof StateOperation) {
                this.adaptStateBuilder((StateOperation)pubSubOperation);
                continue;
            }
            if (pubSubOperation2 instanceof TimetokenRegionOperation) {
                if (this.storedTimetoken != null) {
                    Long l = this.storedTimetoken;
                    Intrinsics.checkNotNull((Object)l);
                    this.timetoken = l;
                    this.storedTimetoken = null;
                } else {
                    this.timetoken = ((TimetokenRegionOperation)pubSubOperation).getTimetoken();
                }
                this.region = ((TimetokenRegionOperation)pubSubOperation).getRegion();
                continue;
            }
            if (Intrinsics.areEqual((Object)pubSubOperation2, (Object)ConnectedStatusAnnouncedOperation.INSTANCE)) {
                this.shouldAnnounce = false;
                continue;
            }
            if (!Intrinsics.areEqual((Object)pubSubOperation2, (Object)NoOpOperation.INSTANCE)) continue;
        }
    }

    @NotNull
    public final synchronized SubscriptionStateData subscriptionStateData$pubnub_kotlin(boolean includePresence) {
        List<String> list = this.prepareChannelGroupList(includePresence);
        List<String> list2 = this.prepareChannelList(includePresence);
        List<String> list3 = this.prepareHeartbeatChannelGroupList(includePresence);
        List<String> list4 = this.prepareHeartbeatChannelList(includePresence);
        long l = this.timetoken;
        String string = this.region;
        Map<String, Object> map = this.createStatePayload();
        boolean bl = this.shouldAnnounce;
        return new SubscriptionStateData(map, list3, list4, list, list2, l, string, bl);
    }

    private final void adaptSubscribeBuilder(SubscribeOperation subscribeOperation) {
        SubscriptionItem presenceSubscriptionItem;
        SubscriptionItem subscriptionItem;
        for (String channel : subscribeOperation.getChannels()) {
            if (((CharSequence)channel).length() == 0) continue;
            subscriptionItem = new SubscriptionItem(channel, null, 2, null);
            ((Map)this.channels).put(channel, subscriptionItem);
            if (!subscribeOperation.getPresenceEnabled()) continue;
            presenceSubscriptionItem = new SubscriptionItem(channel, null, 2, null);
            ((Map)this.presenceChannels).put(channel, presenceSubscriptionItem);
        }
        for (String channelGroup : subscribeOperation.getChannelGroups()) {
            if (((CharSequence)channelGroup).length() == 0) continue;
            subscriptionItem = new SubscriptionItem(channelGroup, null, 2, null);
            this.groups.put(channelGroup, subscriptionItem);
            if (!subscribeOperation.getPresenceEnabled()) continue;
            presenceSubscriptionItem = new SubscriptionItem(channelGroup, null, 2, null);
            ((Map)this.presenceGroups).put(channelGroup, presenceSubscriptionItem);
        }
        this.timetoken = subscribeOperation.getTimetoken();
        if (this.timetoken != 0L) {
            this.storedTimetoken = this.timetoken;
        }
        this.timetoken = 0L;
    }

    private final void adaptStateBuilder(StateOperation stateOperation) {
        for (String channel : stateOperation.getChannels()) {
            SubscriptionItem subscribedChannel;
            SubscriptionItem subscriptionItem = subscribedChannel = this.channels.get(channel);
            if (subscriptionItem == null) continue;
            subscriptionItem.setState$pubnub_kotlin(stateOperation.getState());
        }
        for (String channelGroup : stateOperation.getChannelGroups()) {
            SubscriptionItem subscribedChannelGroup;
            SubscriptionItem subscriptionItem = subscribedChannelGroup = this.groups.get(channelGroup);
            if (subscriptionItem == null) continue;
            subscriptionItem.setState$pubnub_kotlin(stateOperation.getState());
        }
    }

    private final void adaptUnsubscribeBuilder(UnsubscribeOperation unsubscribeOperation) {
        for (String channel : unsubscribeOperation.getChannels()) {
            this.channels.remove(channel);
            this.presenceChannels.remove(channel);
        }
        for (String channelGroup : unsubscribeOperation.getChannelGroups()) {
            this.groups.remove(channelGroup);
            this.presenceGroups.remove(channelGroup);
        }
        if (this.isEmpty()) {
            this.region = null;
            this.storedTimetoken = null;
            this.timetoken = 0L;
        } else {
            this.storedTimetoken = this.timetoken;
            this.timetoken = 0L;
        }
    }

    private final void adaptPresenceBuilder(PresenceOperation presenceOperation) {
        SubscriptionItem subscriptionItem;
        for (String channel : presenceOperation.getChannels()) {
            if (((CharSequence)channel).length() == 0) continue;
            if (presenceOperation.getConnected()) {
                subscriptionItem = new SubscriptionItem(channel, null, 2, null);
                ((Map)this.heartbeatChannels).put(channel, subscriptionItem);
                continue;
            }
            this.heartbeatChannels.remove(channel);
        }
        for (String channelGroup : presenceOperation.getChannelGroups()) {
            if (((CharSequence)channelGroup).length() == 0) continue;
            if (presenceOperation.getConnected()) {
                subscriptionItem = new SubscriptionItem(channelGroup, null, 2, null);
                ((Map)this.heartbeatGroups).put(channelGroup, subscriptionItem);
                continue;
            }
            this.heartbeatGroups.remove(channelGroup);
        }
    }

    private final Map<String, Object> createStatePayload() {
        HashMap stateResponse = new HashMap();
        for (SubscriptionItem channel : this.channels.values()) {
            if (channel.getState$pubnub_kotlin() == null) continue;
            ((Map)stateResponse).put(channel.getName$pubnub_kotlin(), channel.getState$pubnub_kotlin());
        }
        for (SubscriptionItem channelGroup : this.groups.values()) {
            if (channelGroup.getState$pubnub_kotlin() == null) continue;
            ((Map)stateResponse).put(channelGroup.getName$pubnub_kotlin(), channelGroup.getState$pubnub_kotlin());
        }
        return stateResponse;
    }

    private final List<String> prepareChannelList(boolean includePresence) {
        return this.prepareMembershipList((Map<String, SubscriptionItem>)this.channels, (Map<String, SubscriptionItem>)this.presenceChannels, includePresence);
    }

    private final List<String> prepareChannelGroupList(boolean includePresence) {
        return this.prepareMembershipList((Map<String, SubscriptionItem>)this.groups, (Map<String, SubscriptionItem>)this.presenceGroups, includePresence);
    }

    private final List<String> prepareHeartbeatChannelList(boolean includePresence) {
        return this.prepareMembershipList((Map<String, SubscriptionItem>)this.heartbeatChannels, (Map<String, SubscriptionItem>)this.presenceChannels, includePresence);
    }

    private final List<String> prepareHeartbeatChannelGroupList(boolean includePresence) {
        return this.prepareMembershipList((Map<String, SubscriptionItem>)this.heartbeatGroups, (Map<String, SubscriptionItem>)this.presenceGroups, includePresence);
    }

    private final boolean isEmpty() {
        return this.channels.isEmpty() && this.presenceChannels.isEmpty() && this.groups.isEmpty() && this.presenceGroups.isEmpty();
    }

    private final List<String> prepareMembershipList(Map<String, SubscriptionItem> dataStorage, Map<String, SubscriptionItem> presenceStorage, boolean includePresence) {
        List response = new ArrayList();
        for (SubscriptionItem channelGroupItem : dataStorage.values()) {
            response.add(channelGroupItem.getName$pubnub_kotlin());
        }
        if (includePresence) {
            for (SubscriptionItem presenceChannelGroupItem : presenceStorage.values()) {
                response.add(presenceChannelGroupItem.getName$pubnub_kotlin() + "-pnpres");
            }
        }
        return response;
    }
}

