/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.presence.eventengine.effect;

import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.eventengine.ManagedEffect;
import com.pubnub.api.eventengine.Sink;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.presence.eventengine.effect.PresenceEffectInvocation;
import com.pubnub.api.presence.eventengine.event.PresenceEvent;
import com.pubnub.api.subscribe.eventengine.effect.RetryPolicy;
import com.pubnub.extension.ScheduledExecutorServiceKt;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pubnub/api/presence/eventengine/effect/DelayedHeartbeatEffect;", "Lcom/pubnub/api/eventengine/ManagedEffect;", "heartbeatRemoteAction", "Lcom/pubnub/api/endpoints/remoteaction/RemoteAction;", "", "presenceEventSink", "Lcom/pubnub/api/eventengine/Sink;", "Lcom/pubnub/api/presence/eventengine/event/PresenceEvent;", "policy", "Lcom/pubnub/api/subscribe/eventengine/effect/RetryPolicy;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "delayedHeartbeatInvocation", "Lcom/pubnub/api/presence/eventengine/effect/PresenceEffectInvocation$DelayedHeartbeat;", "(Lcom/pubnub/api/endpoints/remoteaction/RemoteAction;Lcom/pubnub/api/eventengine/Sink;Lcom/pubnub/api/subscribe/eventengine/effect/RetryPolicy;Ljava/util/concurrent/ScheduledExecutorService;Lcom/pubnub/api/presence/eventengine/effect/PresenceEffectInvocation$DelayedHeartbeat;)V", "cancelled", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scheduled", "Ljava/util/concurrent/ScheduledFuture;", "cancel", "", "runEffect", "pubnub-kotlin"})
public final class DelayedHeartbeatEffect
implements ManagedEffect {
    @NotNull
    private final RemoteAction<Boolean> heartbeatRemoteAction;
    @NotNull
    private final Sink<PresenceEvent> presenceEventSink;
    @NotNull
    private final RetryPolicy policy;
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final PresenceEffectInvocation.DelayedHeartbeat delayedHeartbeatInvocation;
    private final Logger log;
    @Nullable
    private transient ScheduledFuture<?> scheduled;
    private transient boolean cancelled;

    public DelayedHeartbeatEffect(@NotNull RemoteAction<Boolean> heartbeatRemoteAction, @NotNull Sink<PresenceEvent> presenceEventSink, @NotNull RetryPolicy policy, @NotNull ScheduledExecutorService executorService, @NotNull PresenceEffectInvocation.DelayedHeartbeat delayedHeartbeatInvocation) {
        Intrinsics.checkNotNullParameter(heartbeatRemoteAction, (String)"heartbeatRemoteAction");
        Intrinsics.checkNotNullParameter(presenceEventSink, (String)"presenceEventSink");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)delayedHeartbeatInvocation, (String)"delayedHeartbeatInvocation");
        this.heartbeatRemoteAction = heartbeatRemoteAction;
        this.presenceEventSink = presenceEventSink;
        this.policy = policy;
        this.executorService = executorService;
        this.delayedHeartbeatInvocation = delayedHeartbeatInvocation;
        this.log = LoggerFactory.getLogger(DelayedHeartbeatEffect.class);
    }

    @Override
    public synchronized void runEffect() {
        this.log.trace("Running DelayedHeartbeatEffect");
        if (this.cancelled) {
            return;
        }
        Duration delay = this.policy.nextDelay(this.delayedHeartbeatInvocation.getAttempts());
        if (delay == null) {
            PubNubException pubNubException = this.delayedHeartbeatInvocation.getReason();
            if (pubNubException == null) {
                pubNubException = new PubNubException("Unknown error", null, null, 0, null, 30, null);
            }
            this.presenceEventSink.add(new PresenceEvent.HeartbeatGiveup(pubNubException));
            return;
        }
        this.scheduled = ScheduledExecutorServiceKt.scheduleWithDelay(this.executorService, delay, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DelayedHeartbeatEffect this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DelayedHeartbeatEffect.access$getHeartbeatRemoteAction$p(this.this$0).async((Function2)new Function2<Boolean, PNStatus, Unit>(this.this$0){
                    final /* synthetic */ DelayedHeartbeatEffect this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@Nullable Boolean bl, @NotNull PNStatus status) {
                        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                        if (status.getError()) {
                            Sink sink = DelayedHeartbeatEffect.access$getPresenceEventSink$p(this.this$0);
                            PubNubException pubNubException = status.getException();
                            if (pubNubException == null) {
                                pubNubException = new PubNubException("Unknown error", null, null, 0, null, 30, null);
                            }
                            sink.add(new PresenceEvent.HeartbeatFailure(pubNubException));
                        } else {
                            DelayedHeartbeatEffect.access$getPresenceEventSink$p(this.this$0).add(PresenceEvent.HeartbeatSuccess.INSTANCE);
                        }
                    }
                });
            }
        }));
    }

    @Override
    public synchronized void cancel() {
        block1: {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.heartbeatRemoteAction.silentCancel();
            ScheduledFuture<?> scheduledFuture = this.scheduled;
            if (scheduledFuture == null) break block1;
            scheduledFuture.cancel(true);
        }
    }

    public static final /* synthetic */ RemoteAction access$getHeartbeatRemoteAction$p(DelayedHeartbeatEffect $this) {
        return $this.heartbeatRemoteAction;
    }

    public static final /* synthetic */ Sink access$getPresenceEventSink$p(DelayedHeartbeatEffect $this) {
        return $this.presenceEventSink;
    }
}

