/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.subscribe.eventengine.effect;

import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.eventengine.ManagedEffect;
import com.pubnub.api.eventengine.Sink;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.subscribe.eventengine.effect.RetryPolicy;
import com.pubnub.api.subscribe.eventengine.effect.SubscribeEffectInvocation;
import com.pubnub.api.subscribe.eventengine.event.SubscribeEvent;
import com.pubnub.api.subscribe.eventengine.event.SubscriptionCursor;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pubnub/api/subscribe/eventengine/effect/HandshakeReconnectEffect;", "Lcom/pubnub/api/eventengine/ManagedEffect;", "handshakeRemoteAction", "Lcom/pubnub/api/endpoints/remoteaction/RemoteAction;", "Lcom/pubnub/api/subscribe/eventengine/event/SubscriptionCursor;", "subscribeEventSink", "Lcom/pubnub/api/eventengine/Sink;", "Lcom/pubnub/api/subscribe/eventengine/event/SubscribeEvent;", "policy", "Lcom/pubnub/api/subscribe/eventengine/effect/RetryPolicy;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "handshakeReconnectInvocation", "Lcom/pubnub/api/subscribe/eventengine/effect/SubscribeEffectInvocation$HandshakeReconnect;", "(Lcom/pubnub/api/endpoints/remoteaction/RemoteAction;Lcom/pubnub/api/eventengine/Sink;Lcom/pubnub/api/subscribe/eventengine/effect/RetryPolicy;Ljava/util/concurrent/ScheduledExecutorService;Lcom/pubnub/api/subscribe/eventengine/effect/SubscribeEffectInvocation$HandshakeReconnect;)V", "cancelled", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scheduled", "Ljava/util/concurrent/ScheduledFuture;", "cancel", "", "runEffect", "pubnub-kotlin"})
public final class HandshakeReconnectEffect
implements ManagedEffect {
    @NotNull
    private final RemoteAction<SubscriptionCursor> handshakeRemoteAction;
    @NotNull
    private final Sink<SubscribeEvent> subscribeEventSink;
    @NotNull
    private final RetryPolicy policy;
    @NotNull
    private final ScheduledExecutorService executorService;
    @NotNull
    private final SubscribeEffectInvocation.HandshakeReconnect handshakeReconnectInvocation;
    private final Logger log;
    @Nullable
    private transient ScheduledFuture<?> scheduled;
    private transient boolean cancelled;

    public HandshakeReconnectEffect(@NotNull RemoteAction<SubscriptionCursor> handshakeRemoteAction, @NotNull Sink<SubscribeEvent> subscribeEventSink, @NotNull RetryPolicy policy, @NotNull ScheduledExecutorService executorService, @NotNull SubscribeEffectInvocation.HandshakeReconnect handshakeReconnectInvocation) {
        Intrinsics.checkNotNullParameter(handshakeRemoteAction, (String)"handshakeRemoteAction");
        Intrinsics.checkNotNullParameter(subscribeEventSink, (String)"subscribeEventSink");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)handshakeReconnectInvocation, (String)"handshakeReconnectInvocation");
        this.handshakeRemoteAction = handshakeRemoteAction;
        this.subscribeEventSink = subscribeEventSink;
        this.policy = policy;
        this.executorService = executorService;
        this.handshakeReconnectInvocation = handshakeReconnectInvocation;
        this.log = LoggerFactory.getLogger(HandshakeReconnectEffect.class);
    }

    @Override
    public synchronized void runEffect() {
        this.log.trace("Running HandshakeReconnectEffect");
        if (this.cancelled) {
            return;
        }
        Duration delay = this.policy.nextDelay(this.handshakeReconnectInvocation.getAttempts());
        if (delay == null) {
            PubNubException pubNubException = this.handshakeReconnectInvocation.getReason();
            if (pubNubException == null) {
                pubNubException = new PubNubException("Unknown error", null, null, 0, null, 30, null);
            }
            this.subscribeEventSink.add(new SubscribeEvent.HandshakeReconnectGiveup(pubNubException));
            return;
        }
        this.scheduled = this.executorService.schedule(() -> HandshakeReconnectEffect.runEffect$lambda$0(this), delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void cancel() {
        block1: {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.handshakeRemoteAction.silentCancel();
            ScheduledFuture<?> scheduledFuture = this.scheduled;
            if (scheduledFuture == null) break block1;
            scheduledFuture.cancel(true);
        }
    }

    private static final void runEffect$lambda$0(HandshakeReconnectEffect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handshakeRemoteAction.async((Function2<SubscriptionCursor, PNStatus, Unit>)((Function2)new Function2<SubscriptionCursor, PNStatus, Unit>(this$0){
            final /* synthetic */ HandshakeReconnectEffect this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@Nullable SubscriptionCursor result, @NotNull PNStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                if (status.getError()) {
                    Sink sink = HandshakeReconnectEffect.access$getSubscribeEventSink$p(this.this$0);
                    PubNubException pubNubException = status.getException();
                    if (pubNubException == null) {
                        pubNubException = new PubNubException("Unknown error", null, null, 0, null, 30, null);
                    }
                    sink.add(new SubscribeEvent.HandshakeReconnectFailure(pubNubException));
                } else {
                    Sink sink = HandshakeReconnectEffect.access$getSubscribeEventSink$p(this.this$0);
                    SubscriptionCursor subscriptionCursor = result;
                    Intrinsics.checkNotNull((Object)subscriptionCursor);
                    sink.add(new SubscribeEvent.HandshakeReconnectSuccess(subscriptionCursor));
                }
            }
        }));
    }

    public static final /* synthetic */ Sink access$getSubscribeEventSink$p(HandshakeReconnectEffect $this) {
        return $this.subscribeEventSink;
    }
}

