/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api;

import com.google.gson.JsonElement;
import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.retry.RetryConfiguration;
import com.pubnub.api.retry.RetryableCallback;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.retry.RetryableRestCaller;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNullPointerException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u0000 E*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001EB\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JB\u0010\u001f\u001a\u00020\u000e28\u0010 \u001a4\u0012\u0015\u0012\u0013\u0018\u00018\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\bH\u0016J\u001d\u0010!\u001a\u0004\u0018\u00018\u00012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0002\u00a2\u0006\u0002\u0010$J$\u0010%\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180&j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018`'H\u0004J\u001d\u0010(\u001a\u0004\u0018\u00018\u00012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H$\u00a2\u0006\u0002\u0010$J:\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+2\u0010\b\u0002\u0010,\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010#2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100H\u0002J2\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\"\u00102\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180&j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018`'H$J&\u00103\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u000100042\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0002J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u001806H\u0014J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u001806H\u0014J\b\u00108\u001a\u000209H$J\u001d\u0010:\u001a\u0004\u0018\u00018\u00012\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0002\u00a2\u0006\u0002\u0010$J\b\u0010;\u001a\u00020\u001eH\u0014J\b\u0010<\u001a\u00020\u001eH\u0014J\b\u0010=\u001a\u00020\u001eH\u0014J\b\u0010>\u001a\u00020\u001eH\u0014J\b\u0010?\u001a\u00020\u000eH\u0016J\b\u0010@\u001a\u00020\u000eH\u0016J\u0016\u0010A\u001a\u00020\u000e2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0002J\u000f\u0010B\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020\u000eH\u0014R@\u0010\u0007\u001a4\u0012\u0015\u0012\u0013\u0018\u00018\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/pubnub/api/Endpoint;", "Input", "Output", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "pubnub", "Lcom/pubnub/api/PubNub;", "(Lcom/pubnub/api/PubNub;)V", "cachedCallback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "result", "Lcom/pubnub/api/models/consumer/PNStatus;", "status", "", "call", "Lretrofit2/Call;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getPubnub", "()Lcom/pubnub/api/PubNub;", "queryParam", "", "", "getQueryParam", "()Ljava/util/Map;", "retryableRestCaller", "Lcom/pubnub/api/retry/RetryableRestCaller;", "silenceFailures", "", "async", "callback", "checkAndCreateResponse", "input", "Lretrofit2/Response;", "(Lretrofit2/Response;)Ljava/lang/Object;", "createBaseParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createResponse", "createStatusResponse", "category", "Lcom/pubnub/api/enums/PNStatusCategory;", "response", "exception", "Lcom/pubnub/api/PubNubException;", "errorBody", "Lcom/google/gson/JsonElement;", "doWork", "queryParams", "extractErrorBody", "Lkotlin/Pair;", "getAffectedChannelGroups", "", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "handleResponse", "isAuthRequired", "isEndpointRetryable", "isPubKeyRequired", "isSubKeyRequired", "retry", "silentCancel", "storeRequestLatency", "sync", "()Ljava/lang/Object;", "validateParams", "Companion", "pubnub-kotlin"})
public abstract class Endpoint<Input, Output>
implements ExtendedRemoteAction<Output> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PubNub pubnub;
    private final Logger log;
    private Function2<? super Output, ? super PNStatus, Unit> cachedCallback;
    private Call<Input> call;
    private boolean silenceFailures;
    @NotNull
    private final RetryableRestCaller<Input> retryableRestCaller;
    @NotNull
    private final Map<String, String> queryParam;
    private static final int SERVER_RESPONSE_BAD_REQUEST = 400;
    private static final int SERVER_RESPONSE_FORBIDDEN = 403;
    private static final int SERVER_RESPONSE_NOT_FOUND = 404;

    protected Endpoint(@NotNull PubNub pubnub) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        this.pubnub = pubnub;
        this.log = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
        this.retryableRestCaller = new RetryableRestCaller(this.pubnub.getConfiguration().getRetryConfiguration(), this.getEndpointGroupName(), this.isEndpointRetryable());
        this.queryParam = new LinkedHashMap();
    }

    @NotNull
    protected final PubNub getPubnub() {
        return this.pubnub;
    }

    @NotNull
    public final Map<String, String> getQueryParam() {
        return this.queryParam;
    }

    @Override
    @Nullable
    public Output sync() {
        this.validateParams();
        this.call = this.doWork(this.createBaseParams());
        Call<Input> call = this.call;
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            call = null;
        }
        retrofit2.Response<Input> response = this.retryableRestCaller.execute$pubnub_kotlin(call);
        return this.handleResponse(response);
    }

    private final Output handleResponse(retrofit2.Response<Input> response) {
        if (response.isSuccessful()) {
            this.storeRequestLatency(response);
            return this.checkAndCreateResponse(response);
        }
        Pair<String, JsonElement> pair = this.extractErrorBody(response);
        String errorString = (String)pair.component1();
        JsonElement errorJson = (JsonElement)pair.component2();
        PubNubError pubNubError = PubNubError.HTTP_ERROR;
        String string = String.valueOf(errorJson);
        int n = response.code();
        Call<Input> call = this.call;
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            call = null;
        }
        Call<Input> call2 = call;
        throw new PubNubException(errorString, pubNubError, string, n, call2, null, 32, null);
    }

    @Override
    public void async(@NotNull Function2<? super Output, ? super PNStatus, Unit> callback) {
        Call<Input> call;
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.cachedCallback = callback;
        try {
            this.validateParams();
            this.call = this.doWork(this.createBaseParams());
        }
        catch (PubNubException pubnubException) {
            callback.invoke(null, (Object)Endpoint.createStatusResponse$default(this, PNStatusCategory.PNBadRequestCategory, null, pubnubException, null, 10, null));
            return;
        }
        Call<Input> call2 = this.call;
        if (call2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            call2 = null;
        }
        if ((call = this.call) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
            call = null;
        }
        Call<Input> call3 = call;
        RetryConfiguration retryConfiguration = this.pubnub.getConfiguration().getRetryConfiguration();
        RetryableEndpointGroup retryableEndpointGroup = this.getEndpointGroupName();
        boolean bl = this.isEndpointRetryable();
        call2.enqueue((Callback)new RetryableCallback<Input>(this, callback, call3, retryConfiguration, retryableEndpointGroup, bl){
            final /* synthetic */ Endpoint<Input, Output> this$0;
            final /* synthetic */ Function2<Output, PNStatus, Unit> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                super($super_call_param$2, $super_call_param$3, $super_call_param$1, $super_call_param$4);
            }

            public void onFinalResponse(@NotNull Call<Input> call, @NotNull retrofit2.Response<Input> response) {
                Triple triple;
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    Endpoint.access$storeRequestLatency(this.this$0, response);
                    try {
                        triple = new Triple((Object)((Object)PNStatusCategory.PNAcknowledgmentCategory), Endpoint.access$checkAndCreateResponse(this.this$0, response), null);
                    }
                    catch (PubNubException e) {
                        triple = new Triple((Object)((Object)PNStatusCategory.PNMalformedResponseCategory), null, (Object)e);
                    }
                } else {
                    PNStatusCategory pNStatusCategory;
                    Pair pair = Endpoint.access$extractErrorBody(this.this$0, response);
                    String errorString = (String)pair.component1();
                    JsonElement errorJson = (JsonElement)pair.component2();
                    PubNubError pubNubError = PubNubError.HTTP_ERROR;
                    String string = String.valueOf(errorJson);
                    int n = response.code();
                    String string2 = response.headers().get("Retry-After");
                    Integer n2 = string2 != null ? StringsKt.toIntOrNull((String)string2) : null;
                    PubNubException exception = new PubNubException(errorString, pubNubError, string, n, call, n2);
                    switch (response.code()) {
                        case 403: {
                            pNStatusCategory = PNStatusCategory.PNAccessDeniedCategory;
                            break;
                        }
                        case 400: {
                            pNStatusCategory = PNStatusCategory.PNBadRequestCategory;
                            break;
                        }
                        case 404: {
                            pNStatusCategory = PNStatusCategory.PNNotFoundCategory;
                            break;
                        }
                        default: {
                            pNStatusCategory = PNStatusCategory.PNUnknownCategory;
                        }
                    }
                    PNStatusCategory pnStatusCategory = pNStatusCategory;
                    this.$callback.invoke(null, (Object)Endpoint.access$createStatusResponse(this.this$0, pnStatusCategory, response, exception, errorJson));
                    return;
                }
                Function2<Output, PNStatus, Unit> e = this.$callback;
                Endpoint<Input, Output> endpoint = this.this$0;
                Triple it = triple;
                boolean pubNubError = false;
                e.invoke(it.getSecond(), (Object)Endpoint.createStatusResponse$default(endpoint, (PNStatusCategory)((Object)it.getFirst()), response, (PubNubException)it.getThird(), null, 8, null));
            }

            public void onFinalFailure(@NotNull Call<Input> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (Endpoint.access$getSilenceFailures$p(this.this$0)) {
                    return;
                }
                Throwable throwable = t;
                Pair pair = throwable instanceof UnknownHostException ? TuplesKt.to((Object)((Object)PubNubError.CONNECTION_NOT_SET), (Object)((Object)PNStatusCategory.PNUnexpectedDisconnectCategory)) : (throwable instanceof ConnectException ? TuplesKt.to((Object)((Object)PubNubError.CONNECT_EXCEPTION), (Object)((Object)PNStatusCategory.PNUnexpectedDisconnectCategory)) : (throwable instanceof SocketTimeoutException ? TuplesKt.to((Object)((Object)PubNubError.SUBSCRIBE_TIMEOUT), (Object)((Object)PNStatusCategory.PNTimeoutCategory)) : (throwable instanceof IOException ? TuplesKt.to((Object)((Object)PubNubError.PARSING_ERROR), (Object)((Object)PNStatusCategory.PNMalformedResponseCategory)) : (throwable instanceof IllegalStateException ? TuplesKt.to((Object)((Object)PubNubError.PARSING_ERROR), (Object)((Object)PNStatusCategory.PNMalformedResponseCategory)) : TuplesKt.to((Object)((Object)PubNubError.HTTP_ERROR), (Object)((Object)(call.isCanceled() ? PNStatusCategory.PNCancelledCategory : PNStatusCategory.PNBadRequestCategory)))))));
                PubNubError error = (PubNubError)((Object)pair.component1());
                PNStatusCategory category = (PNStatusCategory)((Object)pair.component2());
                PubNubException pubnubException = new PubNubException(t.toString(), error, null, 0, null, null, 60, null);
                this.$callback.invoke(null, (Object)Endpoint.createStatusResponse$default(this.this$0, category, null, pubnubException, null, 10, null));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void storeRequestLatency(retrofit2.Response<Input> response) {
        void $this$storeRequestLatency_u24lambda_u240;
        Response response2 = response.raw();
        TelemetryManager telemetryManager = this.pubnub.getTelemetryManager$pubnub_kotlin();
        boolean bl = false;
        long l = $this$storeRequestLatency_u24lambda_u240.receivedResponseAtMillis() - $this$storeRequestLatency_u24lambda_u240.sentRequestAtMillis();
        TelemetryManager.storeLatency$pubnub_kotlin$default(telemetryManager, l, this.operationType(), 0L, 4, null);
    }

    @NotNull
    protected final HashMap<String, String> createBaseParams() {
        HashMap<String, String> map = new HashMap<String, String>();
        ((Map)map).putAll(this.queryParam);
        ((Map)map).put("pnsdk", this.pubnub.getConfiguration().generatePnsdk$pubnub_kotlin(this.pubnub.getVersion()));
        ((Map)map).put("uuid", this.pubnub.getConfiguration().getUserId().getValue());
        if (this.pubnub.getConfiguration().getIncludeInstanceIdentifier()) {
            ((Map)map).put("instanceid", this.pubnub.getInstanceId());
        }
        if (this.pubnub.getConfiguration().getIncludeRequestIdentifier()) {
            ((Map)map).put("requestid", this.pubnub.requestId$pubnub_kotlin());
        }
        if (this.isAuthRequired()) {
            String token = this.pubnub.getTokenManager$pubnub_kotlin().getToken();
            if (token != null) {
                ((Map)map).put("auth", token);
            } else if (PNConfiguration.Companion.isValid$pubnub_kotlin(this.pubnub.getConfiguration().getAuthKey())) {
                ((Map)map).put("auth", this.pubnub.getConfiguration().getAuthKey());
            }
        }
        map.putAll(TelemetryManager.operationsLatency$pubnub_kotlin$default(this.pubnub.getTelemetryManager$pubnub_kotlin(), 0L, 1, null));
        return map;
    }

    @Override
    public void silentCancel() {
        if (this.call != null) {
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            if (!call.isCanceled()) {
                this.silenceFailures = true;
                Call<Input> call2 = this.call;
                if (call2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                    call2 = null;
                }
                call2.cancel();
            }
        }
    }

    private final PNStatus createStatusResponse(PNStatusCategory category, retrofit2.Response<Input> response, PubNubException exception, JsonElement errorBody) {
        List list;
        PNStatus pNStatus;
        List list2;
        PNStatus pnStatus = new PNStatus(category, response == null || exception != null, this.operationType(), exception, null, null, null, null, null, null, null, 2032, null);
        pnStatus.setExecutedEndpoint$pubnub_kotlin(this);
        retrofit2.Response<Input> response2 = response;
        if (response2 != null) {
            retrofit2.Response<Input> it = response2;
            boolean bl = false;
            PNStatus $this$createStatusResponse_u24lambda_u242_u24lambda_u241 = pnStatus;
            boolean bl2 = false;
            $this$createStatusResponse_u24lambda_u242_u24lambda_u241.setStatusCode(it.code());
            $this$createStatusResponse_u24lambda_u242_u24lambda_u241.setTlsEnabled(it.raw().request().url().isHttps());
            $this$createStatusResponse_u24lambda_u242_u24lambda_u241.setOrigin(it.raw().request().url().host());
            $this$createStatusResponse_u24lambda_u242_u24lambda_u241.setUuid(it.raw().request().url().queryParameter("uuid"));
            $this$createStatusResponse_u24lambda_u242_u24lambda_u241.setAuthKey(it.raw().request().url().queryParameter("auth"));
            $this$createStatusResponse_u24lambda_u242_u24lambda_u241.setClientRequest(it.raw().request());
        }
        List errorChannels = new ArrayList();
        List errorGroups = new ArrayList();
        if (errorBody != null && this.pubnub.getMapper().isJsonObject(errorBody) && this.pubnub.getMapper().hasField(errorBody, "payload")) {
            Iterator<JsonElement> iterator;
            JsonElement jsonElement = this.pubnub.getMapper().getField(errorBody, "payload");
            Intrinsics.checkNotNull((Object)jsonElement);
            JsonElement payloadBody = jsonElement;
            if (this.pubnub.getMapper().hasField(payloadBody, "channels")) {
                iterator = this.pubnub.getMapper().getArrayIterator(payloadBody, "channels");
                while (iterator.hasNext()) {
                    String string = this.pubnub.getMapper().elementToString(iterator.next());
                    Intrinsics.checkNotNull((Object)string);
                    errorChannels.add(string);
                }
            }
            if (this.pubnub.getMapper().hasField(payloadBody, "channel-groups")) {
                iterator = this.pubnub.getMapper().getArrayIterator(payloadBody, "channel-groups");
                while (iterator.hasNext()) {
                    String string;
                    String it;
                    JsonElement node = iterator.next();
                    Intrinsics.checkNotNull((Object)this.pubnub.getMapper().elementToString(node));
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)String.valueOf(StringsKt.first((CharSequence)it)), (Object)":")) {
                        String string2 = it.substring(1);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    } else {
                        string = it;
                    }
                    String channelGroupName = string;
                    errorGroups.add(channelGroupName);
                }
            }
        }
        PNStatus pNStatus2 = pnStatus;
        if (!((Collection)errorChannels).isEmpty()) {
            list2 = errorChannels;
        } else {
            List list3;
            pNStatus = pNStatus2;
            try {
                pNStatus2 = pNStatus;
                list3 = this.getAffectedChannels();
            }
            catch (UninitializedPropertyAccessException iterator) {
                pNStatus2 = pNStatus;
                list3 = CollectionsKt.emptyList();
            }
            list2 = list3;
        }
        pNStatus2.setAffectedChannels(list2);
        PNStatus pNStatus3 = pnStatus;
        if (!((Collection)errorGroups).isEmpty()) {
            list = errorGroups;
        } else {
            List list4;
            pNStatus = pNStatus3;
            try {
                pNStatus3 = pNStatus;
                list4 = this.getAffectedChannelGroups();
            }
            catch (UninitializedPropertyAccessException e) {
                pNStatus3 = pNStatus;
                list4 = CollectionsKt.emptyList();
            }
            list = list4;
        }
        pNStatus3.setAffectedChannelGroups(list);
        return pnStatus;
    }

    static /* synthetic */ PNStatus createStatusResponse$default(Endpoint endpoint, PNStatusCategory pNStatusCategory, retrofit2.Response response, PubNubException pubNubException, JsonElement jsonElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createStatusResponse");
        }
        if ((n & 2) != 0) {
            response = null;
        }
        if ((n & 4) != 0) {
            pubNubException = null;
        }
        if ((n & 8) != 0) {
            jsonElement = null;
        }
        return endpoint.createStatusResponse(pNStatusCategory, response, pubNubException, jsonElement);
    }

    @Override
    public void retry() {
        this.silenceFailures = false;
        Function2<? super Output, ? super PNStatus, Unit> function2 = this.cachedCallback;
        if (function2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCallback");
            function2 = null;
        }
        this.async(function2);
    }

    private final Pair<String, JsonElement> extractErrorBody(retrofit2.Response<Input> response) {
        JsonElement jsonElement;
        String string;
        try {
            ResponseBody responseBody = response.errorBody();
            string = responseBody != null ? responseBody.string() : null;
        }
        catch (IOException e) {
            string = "N/A";
        }
        String errorBodyString = string;
        try {
            jsonElement = this.pubnub.getMapper().fromJson(errorBodyString, JsonElement.class);
        }
        catch (PubNubException e) {
            jsonElement = null;
        }
        JsonElement errorBodyJson = jsonElement;
        return TuplesKt.to((Object)errorBodyString, (Object)errorBodyJson);
    }

    private final Output checkAndCreateResponse(retrofit2.Response<Input> input) {
        try {
            return this.createResponse(input);
        }
        catch (PubNubException pubnubException) {
            int n = input.code();
            String string = this.pubnub.getMapper().toJson(input.body());
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call2 = call;
            throw PubNubException.copy$default(pubnubException, null, null, string, n, call2, null, 35, null);
        }
        catch (KotlinNullPointerException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call3 = call;
            int n = input.code();
            String string2 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string2, n, call3, null, 32, null);
        }
        catch (IllegalStateException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call4 = call;
            int n = input.code();
            String string3 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string3, n, call4, null, 32, null);
        }
        catch (IndexOutOfBoundsException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call5 = call;
            int n = input.code();
            String string4 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string4, n, call5, null, 32, null);
        }
        catch (NullPointerException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call6 = call;
            int n = input.code();
            String string5 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string5, n, call6, null, 32, null);
        }
        catch (IllegalArgumentException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call7 = call;
            int n = input.code();
            String string6 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string6, n, call7, null, 32, null);
        }
        catch (TypeCastException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call8 = call;
            int n = input.code();
            String string7 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string7, n, call8, null, 32, null);
        }
        catch (ClassCastException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call9 = call;
            int n = input.code();
            String string8 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string8, n, call9, null, 32, null);
        }
        catch (UninitializedPropertyAccessException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"call");
                call = null;
            }
            Call<Input> call10 = call;
            int n = input.code();
            String string9 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string9, n, call10, null, 32, null);
        }
    }

    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    protected void validateParams() {
        if (this.isSubKeyRequired() && !PNConfiguration.Companion.isValid$pubnub_kotlin(this.pubnub.getConfiguration().getSubscribeKey())) {
            throw new PubNubException(PubNubError.SUBSCRIBE_KEY_MISSING);
        }
        if (this.isPubKeyRequired() && !PNConfiguration.Companion.isValid$pubnub_kotlin(this.pubnub.getConfiguration().getPublishKey())) {
            throw new PubNubException(PubNubError.PUBLISH_KEY_MISSING);
        }
    }

    @NotNull
    protected abstract Call<Input> doWork(@NotNull HashMap<String, String> var1);

    @Nullable
    protected abstract Output createResponse(@NotNull retrofit2.Response<Input> var1);

    protected boolean isSubKeyRequired() {
        return true;
    }

    protected boolean isPubKeyRequired() {
        return false;
    }

    protected boolean isAuthRequired() {
        return true;
    }

    @NotNull
    protected abstract RetryableEndpointGroup getEndpointGroupName();

    protected boolean isEndpointRetryable() {
        return true;
    }

    public static final /* synthetic */ void access$storeRequestLatency(Endpoint $this, retrofit2.Response response) {
        $this.storeRequestLatency(response);
    }

    public static final /* synthetic */ Object access$checkAndCreateResponse(Endpoint $this, retrofit2.Response input) {
        return $this.checkAndCreateResponse(input);
    }

    public static final /* synthetic */ Pair access$extractErrorBody(Endpoint $this, retrofit2.Response response) {
        return $this.extractErrorBody(response);
    }

    public static final /* synthetic */ PNStatus access$createStatusResponse(Endpoint $this, PNStatusCategory category, retrofit2.Response response, PubNubException exception, JsonElement errorBody) {
        return $this.createStatusResponse(category, response, exception, errorBody);
    }

    public static final /* synthetic */ boolean access$getSilenceFailures$p(Endpoint $this) {
        return $this.silenceFailures;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/pubnub/api/Endpoint$Companion;", "", "()V", "SERVER_RESPONSE_BAD_REQUEST", "", "SERVER_RESPONSE_FORBIDDEN", "SERVER_RESPONSE_NOT_FOUND", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

