/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.UserId;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.enums.PNHeartbeatNotificationOptions;
import com.pubnub.api.enums.PNLogVerbosity;
import com.pubnub.api.enums.PNReconnectionPolicy;
import com.pubnub.api.retry.RetryConfiguration;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Authenticator;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionSpec;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00dc\u00012\u00020\u0001:\u0002\u00dc\u0001B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ@\u0010\u00d0\u0001\u001a\u00030\u00d1\u00012.\u0010\u00d2\u0001\u001a\u0018\u0012\u0013\b\u0001\u0012\u000f\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00d4\u00010\u00d3\u0001\"\u000f\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00d4\u0001H\u0007\u00a2\u0006\u0003\u0010\u00d5\u0001J \u0010\u00d0\u0001\u001a\u00030\u00d1\u00012\u0014\u0010\u00d2\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00d6\u0001H\u0007J\u0012\u0010\u00d7\u0001\u001a\u00020 2\u0007\u0010\u00d8\u0001\u001a\u00020 H\u0002J\u0018\u0010\u00d9\u0001\u001a\u00020\u00032\u0007\u0010\u00da\u0001\u001a\u00020\u0003H\u0000\u00a2\u0006\u0003\b\u00db\u0001R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010+\u001a\u0004\u0018\u00010,8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0011\"\u0004\b3\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0011\"\u0004\b5\u0010\u0013R\u001a\u00106\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\"\"\u0004\b8\u0010$R\u001a\u00109\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\f\"\u0004\b;\u0010\u000eR\u001a\u0010<\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0011\"\u0004\b>\u0010\u0013R\u001a\u0010?\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\"\"\u0004\bA\u0010$R\u001a\u0010B\u001a\u00020CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001c\u0010H\u001a\u0004\u0018\u00010IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u001c\u0010N\u001a\u0004\u0018\u00010OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u001a\u0010T\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010\u0011\"\u0004\bV\u0010\u0013R\u001a\u0010W\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010\u0011\"\u0004\bY\u0010\u0013R\u0016\u0010Z\u001a\n \\*\u0004\u0018\u00010[0[X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010]\u001a\u00020^X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010`\"\u0004\ba\u0010bR\u001a\u0010c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010\u0011\"\u0004\be\u0010\u0013R\u001e\u0010f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010k\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\u001a\u0010l\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010\"\"\u0004\bn\u0010$R$\u0010o\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bp\u0010\u001c\u001a\u0004\bq\u0010\"\"\u0004\br\u0010$R\u001a\u0010s\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010\"\"\u0004\bu\u0010$R\u001a\u0010v\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u0010\f\"\u0004\bx\u0010\u000eR\u001a\u0010y\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030zX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010|\u001a\u00020 2\u0006\u0010{\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b}\u0010\"\"\u0004\b~\u0010$R!\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0081\u0001\u0010\u0082\u0001\"\u0006\b\u0083\u0001\u0010\u0084\u0001R\"\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001R\"\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008d\u0001\u0010\u008e\u0001\"\u0006\b\u008f\u0001\u0010\u0090\u0001R\u001d\u0010\u0091\u0001\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0092\u0001\u0010\f\"\u0005\b\u0093\u0001\u0010\u000eR+\u0010\u0094\u0001\u001a\u00030\u0095\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0019\n\u0000\u0012\u0005\b\u0096\u0001\u0010\u001c\u001a\u0006\b\u0097\u0001\u0010\u0098\u0001\"\u0006\b\u0099\u0001\u0010\u009a\u0001R!\u0010\u009b\u0001\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u0012\n\u0002\u0010k\u001a\u0005\b\u009c\u0001\u0010h\"\u0005\b\u009d\u0001\u0010jR!\u0010\u009e\u0001\u001a\u00030\u009f\u00018@X\u0080\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u00a2\u0001\u0010\u00a3\u0001\u001a\u0006\b\u00a0\u0001\u0010\u00a1\u0001R \u0010\u00a4\u0001\u001a\u00030\u009f\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00a5\u0001\u0010\u00a1\u0001\"\u0006\b\u00a6\u0001\u0010\u00a7\u0001R\u001d\u0010\u00a8\u0001\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00a9\u0001\u0010\f\"\u0005\b\u00aa\u0001\u0010\u000eR\u001d\u0010\u00ab\u0001\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00ac\u0001\u0010\u0011\"\u0005\b\u00ad\u0001\u0010\u0013R\"\u0010\u00ae\u0001\u001a\u0005\u0018\u00010\u00af\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00b0\u0001\u0010\u00b1\u0001\"\u0006\b\u00b2\u0001\u0010\u00b3\u0001R\u001d\u0010\u00b4\u0001\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00b5\u0001\u0010\u0011\"\u0005\b\u00b6\u0001\u0010\u0013R\u001d\u0010\u00b7\u0001\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00b8\u0001\u0010\f\"\u0005\b\u00b9\u0001\u0010\u000eR\u001d\u0010\u00ba\u0001\u001a\u00020 X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00bb\u0001\u0010\"\"\u0005\b\u00bc\u0001\u0010$R\u001d\u0010\u00bd\u0001\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00be\u0001\u0010\u0011\"\u0005\b\u00bf\u0001\u0010\u0013R(\u0010\u00c0\u0001\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0017\n\u0000\u0012\u0005\b\u00c1\u0001\u0010\u001c\u001a\u0005\b\u00c2\u0001\u0010\u0011\"\u0005\b\u00c3\u0001\u0010\u0013R\u001d\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u0011\n\u0000\u001a\u0006\b\u00c4\u0001\u0010\u00c5\u0001\"\u0005\b\u00c6\u0001\u0010\tR-\u0010\u0002\u001a\u00020\u00032\u0006\u0010{\u001a\u00020\u00038F@FX\u0087\u000e\u00a2\u0006\u0015\u0012\u0005\b\u00c7\u0001\u0010\u001c\u001a\u0005\b\u00c8\u0001\u0010\f\"\u0005\b\u00c9\u0001\u0010\u000eR\"\u0010\u00ca\u0001\u001a\u0005\u0018\u00010\u00cb\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00cc\u0001\u0010\u00cd\u0001\"\u0006\b\u00ce\u0001\u0010\u00cf\u0001\u00a8\u0006\u00dd\u0001"}, d2={"Lcom/pubnub/api/PNConfiguration;", "", "uuid", "", "enableEventEngine", "", "(Ljava/lang/String;Z)V", "userId", "Lcom/pubnub/api/UserId;", "(Lcom/pubnub/api/UserId;)V", "authKey", "getAuthKey", "()Ljava/lang/String;", "setAuthKey", "(Ljava/lang/String;)V", "cacheBusting", "getCacheBusting", "()Z", "setCacheBusting", "(Z)V", "certificatePinner", "Lokhttp3/CertificatePinner;", "getCertificatePinner", "()Lokhttp3/CertificatePinner;", "setCertificatePinner", "(Lokhttp3/CertificatePinner;)V", "cipherKey", "getCipherKey$annotations", "()V", "getCipherKey", "setCipherKey", "connectTimeout", "", "getConnectTimeout", "()I", "setConnectTimeout", "(I)V", "connectionSpec", "Lokhttp3/ConnectionSpec;", "getConnectionSpec", "()Lokhttp3/ConnectionSpec;", "setConnectionSpec", "(Lokhttp3/ConnectionSpec;)V", "cryptoModule", "Lcom/pubnub/api/crypto/CryptoModule;", "getCryptoModule", "()Lcom/pubnub/api/crypto/CryptoModule;", "setCryptoModule", "(Lcom/pubnub/api/crypto/CryptoModule;)V", "dedupOnSubscribe", "getDedupOnSubscribe", "setDedupOnSubscribe", "getEnableEventEngine", "setEnableEventEngine", "fileMessagePublishRetryLimit", "getFileMessagePublishRetryLimit", "setFileMessagePublishRetryLimit", "filterExpression", "getFilterExpression", "setFilterExpression", "googleAppEngineNetworking", "getGoogleAppEngineNetworking", "setGoogleAppEngineNetworking", "heartbeatInterval", "getHeartbeatInterval", "setHeartbeatInterval", "heartbeatNotificationOptions", "Lcom/pubnub/api/enums/PNHeartbeatNotificationOptions;", "getHeartbeatNotificationOptions", "()Lcom/pubnub/api/enums/PNHeartbeatNotificationOptions;", "setHeartbeatNotificationOptions", "(Lcom/pubnub/api/enums/PNHeartbeatNotificationOptions;)V", "hostnameVerifier", "Ljavax/net/ssl/HostnameVerifier;", "getHostnameVerifier", "()Ljavax/net/ssl/HostnameVerifier;", "setHostnameVerifier", "(Ljavax/net/ssl/HostnameVerifier;)V", "httpLoggingInterceptor", "Lokhttp3/logging/HttpLoggingInterceptor;", "getHttpLoggingInterceptor", "()Lokhttp3/logging/HttpLoggingInterceptor;", "setHttpLoggingInterceptor", "(Lokhttp3/logging/HttpLoggingInterceptor;)V", "includeInstanceIdentifier", "getIncludeInstanceIdentifier", "setIncludeInstanceIdentifier", "includeRequestIdentifier", "getIncludeRequestIdentifier", "setIncludeRequestIdentifier", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logVerbosity", "Lcom/pubnub/api/enums/PNLogVerbosity;", "getLogVerbosity", "()Lcom/pubnub/api/enums/PNLogVerbosity;", "setLogVerbosity", "(Lcom/pubnub/api/enums/PNLogVerbosity;)V", "maintainPresenceState", "getMaintainPresenceState", "setMaintainPresenceState", "maximumConnections", "getMaximumConnections", "()Ljava/lang/Integer;", "setMaximumConnections", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "maximumMessagesCacheSize", "getMaximumMessagesCacheSize", "setMaximumMessagesCacheSize", "maximumReconnectionRetries", "getMaximumReconnectionRetries$annotations", "getMaximumReconnectionRetries", "setMaximumReconnectionRetries", "nonSubscribeRequestTimeout", "getNonSubscribeRequestTimeout", "setNonSubscribeRequestTimeout", "origin", "getOrigin", "setOrigin", "pnsdkSuffixes", "Ljava/util/concurrent/ConcurrentMap;", "value", "presenceTimeout", "getPresenceTimeout", "setPresenceTimeout", "proxy", "Ljava/net/Proxy;", "getProxy", "()Ljava/net/Proxy;", "setProxy", "(Ljava/net/Proxy;)V", "proxyAuthenticator", "Lokhttp3/Authenticator;", "getProxyAuthenticator", "()Lokhttp3/Authenticator;", "setProxyAuthenticator", "(Lokhttp3/Authenticator;)V", "proxySelector", "Ljava/net/ProxySelector;", "getProxySelector", "()Ljava/net/ProxySelector;", "setProxySelector", "(Ljava/net/ProxySelector;)V", "publishKey", "getPublishKey", "setPublishKey", "reconnectionPolicy", "Lcom/pubnub/api/enums/PNReconnectionPolicy;", "getReconnectionPolicy$annotations", "getReconnectionPolicy", "()Lcom/pubnub/api/enums/PNReconnectionPolicy;", "setReconnectionPolicy", "(Lcom/pubnub/api/enums/PNReconnectionPolicy;)V", "requestMessageCountThreshold", "getRequestMessageCountThreshold", "setRequestMessageCountThreshold", "retryConfForOldSubscribeLoop", "Lcom/pubnub/api/retry/RetryConfiguration;", "getRetryConfForOldSubscribeLoop$pubnub_kotlin", "()Lcom/pubnub/api/retry/RetryConfiguration;", "retryConfForOldSubscribeLoop$delegate", "Lkotlin/Lazy;", "retryConfiguration", "getRetryConfiguration", "setRetryConfiguration", "(Lcom/pubnub/api/retry/RetryConfiguration;)V", "secretKey", "getSecretKey", "setSecretKey", "secure", "getSecure", "setSecure", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getSslSocketFactory", "()Ljavax/net/ssl/SSLSocketFactory;", "setSslSocketFactory", "(Ljavax/net/ssl/SSLSocketFactory;)V", "startSubscriberThread", "getStartSubscriberThread", "setStartSubscriberThread", "subscribeKey", "getSubscribeKey", "setSubscribeKey", "subscribeTimeout", "getSubscribeTimeout", "setSubscribeTimeout", "suppressLeaveEvents", "getSuppressLeaveEvents", "setSuppressLeaveEvents", "useRandomInitializationVector", "getUseRandomInitializationVector$annotations", "getUseRandomInitializationVector", "setUseRandomInitializationVector", "getUserId", "()Lcom/pubnub/api/UserId;", "setUserId", "getUuid$annotations", "getUuid", "setUuid", "x509ExtendedTrustManager", "Ljavax/net/ssl/X509ExtendedTrustManager;", "getX509ExtendedTrustManager", "()Ljavax/net/ssl/X509ExtendedTrustManager;", "setX509ExtendedTrustManager", "(Ljavax/net/ssl/X509ExtendedTrustManager;)V", "addPnsdkSuffix", "", "nameToSuffixes", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)V", "", "calculateMaximumReconnectionRetries", "maxRetryNumber", "generatePnsdk", "version", "generatePnsdk$pubnub_kotlin", "Companion", "pubnub-kotlin"})
public class PNConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private UserId userId;
    private final Logger log;
    private boolean enableEventEngine;
    @NotNull
    private String subscribeKey;
    @NotNull
    private String publishKey;
    @NotNull
    private String secretKey;
    @NotNull
    private String authKey;
    @NotNull
    private String cipherKey;
    private boolean useRandomInitializationVector;
    @Nullable
    private CryptoModule cryptoModule;
    @NotNull
    private String origin;
    private boolean secure;
    @NotNull
    private PNLogVerbosity logVerbosity;
    @NotNull
    private PNHeartbeatNotificationOptions heartbeatNotificationOptions;
    @NotNull
    private PNReconnectionPolicy reconnectionPolicy;
    private int presenceTimeout;
    private int heartbeatInterval;
    private int subscribeTimeout;
    private int connectTimeout;
    private int nonSubscribeRequestTimeout;
    private boolean cacheBusting;
    private boolean suppressLeaveEvents;
    private boolean maintainPresenceState;
    @NotNull
    private String filterExpression;
    private boolean includeInstanceIdentifier;
    private boolean includeRequestIdentifier;
    private int maximumReconnectionRetries;
    @Nullable
    private Integer maximumConnections;
    @Nullable
    private Integer requestMessageCountThreshold;
    private boolean googleAppEngineNetworking;
    private boolean startSubscriberThread;
    @Nullable
    private Proxy proxy;
    @Nullable
    private ProxySelector proxySelector;
    @Nullable
    private Authenticator proxyAuthenticator;
    @Nullable
    private CertificatePinner certificatePinner;
    @Nullable
    private HttpLoggingInterceptor httpLoggingInterceptor;
    @Nullable
    private SSLSocketFactory sslSocketFactory;
    @Nullable
    private X509ExtendedTrustManager x509ExtendedTrustManager;
    @Nullable
    private ConnectionSpec connectionSpec;
    @Nullable
    private HostnameVerifier hostnameVerifier;
    private int fileMessagePublishRetryLimit;
    private boolean dedupOnSubscribe;
    private int maximumMessagesCacheSize;
    @NotNull
    private final ConcurrentMap<String, String> pnsdkSuffixes;
    @NotNull
    private RetryConfiguration retryConfiguration;
    @NotNull
    private final Lazy retryConfForOldSubscribeLoop$delegate;
    private static final int DEFAULT_DEDUPE_SIZE = 100;
    private static final int PRESENCE_TIMEOUT = 300;
    private static final int MINIMUM_PRESENCE_TIMEOUT = 20;
    private static final int NON_SUBSCRIBE_REQUEST_TIMEOUT = 10;
    private static final int SUBSCRIBE_TIMEOUT = 310;
    private static final int CONNECT_TIMEOUT = 5;

    public PNConfiguration(@NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.userId = userId;
        this.log = LoggerFactory.getLogger((String)"PNConfiguration");
        this.subscribeKey = "";
        this.publishKey = "";
        this.secretKey = "";
        this.authKey = "";
        this.cipherKey = "";
        this.useRandomInitializationVector = true;
        this.origin = "";
        this.secure = true;
        this.logVerbosity = PNLogVerbosity.NONE;
        this.heartbeatNotificationOptions = PNHeartbeatNotificationOptions.FAILURES;
        this.reconnectionPolicy = PNReconnectionPolicy.NONE;
        this.presenceTimeout = 300;
        this.subscribeTimeout = 310;
        this.connectTimeout = 5;
        this.nonSubscribeRequestTimeout = 10;
        this.maintainPresenceState = true;
        this.filterExpression = "";
        this.includeRequestIdentifier = true;
        this.maximumReconnectionRetries = -1;
        this.startSubscriberThread = true;
        this.fileMessagePublishRetryLimit = 5;
        this.maximumMessagesCacheSize = 100;
        this.pnsdkSuffixes = new ConcurrentHashMap(new LinkedHashMap());
        this.retryConfiguration = RetryConfiguration.None.INSTANCE;
        this.retryConfForOldSubscribeLoop$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RetryConfiguration>(this){
            final /* synthetic */ PNConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RetryConfiguration invoke() {
                RetryConfiguration retryConfiguration;
                if (!Intrinsics.areEqual((Object)this.this$0.getRetryConfiguration(), (Object)RetryConfiguration.None.INSTANCE)) {
                    retryConfiguration = this.this$0.getRetryConfiguration();
                } else {
                    int defaultRetryNumberForLinear = 10;
                    int defaultRetryNumberForExponential = 6;
                    switch (retryConfForOldSubscribeLoop.WhenMappings.$EnumSwitchMapping$0[this.this$0.getReconnectionPolicy().ordinal()]) {
                        case 1: {
                            retryConfiguration = RetryConfiguration.None.INSTANCE;
                            break;
                        }
                        case 2: {
                            retryConfiguration = new RetryConfiguration.Linear(0, PNConfiguration.access$calculateMaximumReconnectionRetries(this.this$0, defaultRetryNumberForLinear), null, 5, null);
                            break;
                        }
                        case 3: {
                            retryConfiguration = new RetryConfiguration.Exponential(0, 0, PNConfiguration.access$calculateMaximumReconnectionRetries(this.this$0, defaultRetryNumberForExponential), null, 11, null);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                return retryConfiguration;
            }
        }));
    }

    @NotNull
    public final UserId getUserId() {
        return this.userId;
    }

    public final void setUserId(@NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"<set-?>");
        this.userId = userId;
    }

    @Deprecated(message="Use PNConfiguration(UserId) instead, and set the enableEventEngine property separately.", replaceWith=@ReplaceWith(expression="PNConfiguration(userId = UserId(uuid))", imports={"com.pubnub.api.PNConfiguration"}), level=DeprecationLevel.WARNING)
    public PNConfiguration(@NotNull String uuid, boolean enableEventEngine) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this(new UserId(uuid));
        this.enableEventEngine = enableEventEngine;
    }

    public /* synthetic */ PNConfiguration(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @NotNull
    public final String getUuid() {
        return this.userId.getValue();
    }

    public final void setUuid(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.userId = new UserId(value);
    }

    @Deprecated(message="Use UserId instead e.g. config.userId.value", replaceWith=@ReplaceWith(expression="userId.value", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getUuid$annotations() {
    }

    public final boolean getEnableEventEngine() {
        return this.enableEventEngine;
    }

    public final void setEnableEventEngine(boolean bl) {
        this.enableEventEngine = bl;
    }

    @NotNull
    public final String getSubscribeKey() {
        return this.subscribeKey;
    }

    public final void setSubscribeKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.subscribeKey = string;
    }

    @NotNull
    public final String getPublishKey() {
        return this.publishKey;
    }

    public final void setPublishKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.publishKey = string;
    }

    @NotNull
    public final String getSecretKey() {
        return this.secretKey;
    }

    public final void setSecretKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.secretKey = string;
    }

    @NotNull
    public final String getAuthKey() {
        return this.authKey;
    }

    public final void setAuthKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.authKey = string;
    }

    @NotNull
    public final String getCipherKey() {
        return this.cipherKey;
    }

    public final void setCipherKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.cipherKey = string;
    }

    @Deprecated(message="Instead of cipherKey and useRandomInitializationVector use CryptoModule instead \n            e.g. config.cryptoModule = CryptoModule.createLegacyCryptoModule(cipherKey = cipherKey, randomIv = true) \n            or config.cryptoModule = CryptoModule.createAesCbcCryptoModule(cipherKey = cipherKey, randomIv = true)", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getCipherKey$annotations() {
    }

    public final boolean getUseRandomInitializationVector() {
        return this.useRandomInitializationVector;
    }

    public final void setUseRandomInitializationVector(boolean bl) {
        this.useRandomInitializationVector = bl;
    }

    @Deprecated(message="Instead of cipherKey and useRandomInitializationVector use CryptoModule instead \n            e.g. config.cryptoModule = CryptoModule.createLegacyCryptoModule(cipherKey = cipherKey, randomIv = true) \n            or config.cryptoModule = CryptoModule.createAesCbcCryptoModule(cipherKey = cipherKey, randomIv = true)", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getUseRandomInitializationVector$annotations() {
    }

    @Nullable
    public final CryptoModule getCryptoModule() {
        CryptoModule cryptoModule = this.cryptoModule;
        if (cryptoModule == null) {
            if (!StringsKt.isBlank((CharSequence)this.cipherKey)) {
                this.log.warn("cipherKey is deprecated. Use CryptoModule instead");
                cryptoModule = this.cryptoModule = CryptoModule.Companion.createLegacyCryptoModule(this.cipherKey, this.useRandomInitializationVector);
            } else {
                cryptoModule = null;
            }
        }
        return cryptoModule;
    }

    public final void setCryptoModule(@Nullable CryptoModule cryptoModule) {
        this.cryptoModule = cryptoModule;
    }

    @NotNull
    public final String getOrigin() {
        return this.origin;
    }

    public final void setOrigin(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.origin = string;
    }

    public final boolean getSecure() {
        return this.secure;
    }

    public final void setSecure(boolean bl) {
        this.secure = bl;
    }

    @NotNull
    public final PNLogVerbosity getLogVerbosity() {
        return this.logVerbosity;
    }

    public final void setLogVerbosity(@NotNull PNLogVerbosity pNLogVerbosity) {
        Intrinsics.checkNotNullParameter((Object)((Object)pNLogVerbosity), (String)"<set-?>");
        this.logVerbosity = pNLogVerbosity;
    }

    @NotNull
    public final PNHeartbeatNotificationOptions getHeartbeatNotificationOptions() {
        return this.heartbeatNotificationOptions;
    }

    public final void setHeartbeatNotificationOptions(@NotNull PNHeartbeatNotificationOptions pNHeartbeatNotificationOptions) {
        Intrinsics.checkNotNullParameter((Object)((Object)pNHeartbeatNotificationOptions), (String)"<set-?>");
        this.heartbeatNotificationOptions = pNHeartbeatNotificationOptions;
    }

    @NotNull
    public final PNReconnectionPolicy getReconnectionPolicy() {
        return this.reconnectionPolicy;
    }

    public final void setReconnectionPolicy(@NotNull PNReconnectionPolicy pNReconnectionPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)pNReconnectionPolicy), (String)"<set-?>");
        this.reconnectionPolicy = pNReconnectionPolicy;
    }

    @Deprecated(message="Instead of reconnectionPolicy and maximumReconnectionRetries use retryConfiguration \n            e.g. config.retryConfiguration = RetryConfiguration.Linear(delayInSec = 3, maxRetryNumber = 5) \n            or config.retryConfiguration = RetryConfiguration.Exponential(minDelayInSec = 3, maxDelayInSec = 10, maxRetryNumber = 5)", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getReconnectionPolicy$annotations() {
    }

    public final int getPresenceTimeout() {
        return this.presenceTimeout;
    }

    public final void setPresenceTimeout(int value) {
        int n;
        if (value < 20) {
            this.log.warn("Presence timeout is too low. Defaulting to: 20");
            n = 20;
        } else {
            n = value;
        }
        this.presenceTimeout = n;
        this.heartbeatInterval = this.presenceTimeout / 2 - 1;
    }

    public final int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public final void setHeartbeatInterval(int n) {
        this.heartbeatInterval = n;
    }

    public final int getSubscribeTimeout() {
        return this.subscribeTimeout;
    }

    public final void setSubscribeTimeout(int n) {
        this.subscribeTimeout = n;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public final int getNonSubscribeRequestTimeout() {
        return this.nonSubscribeRequestTimeout;
    }

    public final void setNonSubscribeRequestTimeout(int n) {
        this.nonSubscribeRequestTimeout = n;
    }

    public final boolean getCacheBusting() {
        return this.cacheBusting;
    }

    public final void setCacheBusting(boolean bl) {
        this.cacheBusting = bl;
    }

    public final boolean getSuppressLeaveEvents() {
        return this.suppressLeaveEvents;
    }

    public final void setSuppressLeaveEvents(boolean bl) {
        this.suppressLeaveEvents = bl;
    }

    public final boolean getMaintainPresenceState() {
        return this.maintainPresenceState;
    }

    public final void setMaintainPresenceState(boolean bl) {
        this.maintainPresenceState = bl;
    }

    @NotNull
    public final String getFilterExpression() {
        return this.filterExpression;
    }

    public final void setFilterExpression(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.filterExpression = string;
    }

    public final boolean getIncludeInstanceIdentifier() {
        return this.includeInstanceIdentifier;
    }

    public final void setIncludeInstanceIdentifier(boolean bl) {
        this.includeInstanceIdentifier = bl;
    }

    public final boolean getIncludeRequestIdentifier() {
        return this.includeRequestIdentifier;
    }

    public final void setIncludeRequestIdentifier(boolean bl) {
        this.includeRequestIdentifier = bl;
    }

    public final int getMaximumReconnectionRetries() {
        return this.maximumReconnectionRetries;
    }

    public final void setMaximumReconnectionRetries(int n) {
        this.maximumReconnectionRetries = n;
    }

    @Deprecated(message="Instead of reconnectionPolicy and maximumReconnectionRetries use retryConfiguration \n            e.g. config.retryConfiguration = RetryConfiguration.Linear(delayInSec = 3, maxRetryNumber = 5) \n            or config.retryConfiguration = RetryConfiguration.Exponential(minDelayInSec = 3, maxDelayInSec = 10, maxRetryNumber = 5)", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getMaximumReconnectionRetries$annotations() {
    }

    @Nullable
    public final Integer getMaximumConnections() {
        return this.maximumConnections;
    }

    public final void setMaximumConnections(@Nullable Integer n) {
        this.maximumConnections = n;
    }

    @Nullable
    public final Integer getRequestMessageCountThreshold() {
        return this.requestMessageCountThreshold;
    }

    public final void setRequestMessageCountThreshold(@Nullable Integer n) {
        this.requestMessageCountThreshold = n;
    }

    public final boolean getGoogleAppEngineNetworking() {
        return this.googleAppEngineNetworking;
    }

    public final void setGoogleAppEngineNetworking(boolean bl) {
        this.googleAppEngineNetworking = bl;
    }

    public final boolean getStartSubscriberThread() {
        return this.startSubscriberThread;
    }

    public final void setStartSubscriberThread(boolean bl) {
        this.startSubscriberThread = bl;
    }

    @Nullable
    public final Proxy getProxy() {
        return this.proxy;
    }

    public final void setProxy(@Nullable Proxy proxy) {
        this.proxy = proxy;
    }

    @Nullable
    public final ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public final void setProxySelector(@Nullable ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
    }

    @Nullable
    public final Authenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public final void setProxyAuthenticator(@Nullable Authenticator authenticator) {
        this.proxyAuthenticator = authenticator;
    }

    @Nullable
    public final CertificatePinner getCertificatePinner() {
        return this.certificatePinner;
    }

    public final void setCertificatePinner(@Nullable CertificatePinner certificatePinner) {
        this.certificatePinner = certificatePinner;
    }

    @Nullable
    public final HttpLoggingInterceptor getHttpLoggingInterceptor() {
        return this.httpLoggingInterceptor;
    }

    public final void setHttpLoggingInterceptor(@Nullable HttpLoggingInterceptor httpLoggingInterceptor) {
        this.httpLoggingInterceptor = httpLoggingInterceptor;
    }

    @Nullable
    public final SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public final void setSslSocketFactory(@Nullable SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    @Nullable
    public final X509ExtendedTrustManager getX509ExtendedTrustManager() {
        return this.x509ExtendedTrustManager;
    }

    public final void setX509ExtendedTrustManager(@Nullable X509ExtendedTrustManager x509ExtendedTrustManager) {
        this.x509ExtendedTrustManager = x509ExtendedTrustManager;
    }

    @Nullable
    public final ConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public final void setConnectionSpec(@Nullable ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
    }

    @Nullable
    public final HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public final void setHostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public final int getFileMessagePublishRetryLimit() {
        return this.fileMessagePublishRetryLimit;
    }

    public final void setFileMessagePublishRetryLimit(int n) {
        this.fileMessagePublishRetryLimit = n;
    }

    public final boolean getDedupOnSubscribe() {
        return this.dedupOnSubscribe;
    }

    public final void setDedupOnSubscribe(boolean bl) {
        this.dedupOnSubscribe = bl;
    }

    public final int getMaximumMessagesCacheSize() {
        return this.maximumMessagesCacheSize;
    }

    public final void setMaximumMessagesCacheSize(int n) {
        this.maximumMessagesCacheSize = n;
    }

    @NotNull
    public final String generatePnsdk$pubnub_kotlin(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Collection collection = MapsKt.toSortedMap((Map)this.pnsdkSuffixes).values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"pnsdkSuffixes.toSortedMap().values");
        String joinedSuffixes = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        return "PubNub-Kotlin/" + version + (!StringsKt.isBlank((CharSequence)joinedSuffixes) ? ' ' + joinedSuffixes : "");
    }

    @Deprecated(message="To be used by components", level=DeprecationLevel.WARNING)
    public final void addPnsdkSuffix(Pair<String, String> ... nameToSuffixes) {
        Intrinsics.checkNotNullParameter(nameToSuffixes, (String)"nameToSuffixes");
        this.addPnsdkSuffix(MapsKt.toMap(nameToSuffixes));
    }

    @Deprecated(message="To be used by components", level=DeprecationLevel.WARNING)
    public final void addPnsdkSuffix(@NotNull Map<String, String> nameToSuffixes) {
        Intrinsics.checkNotNullParameter(nameToSuffixes, (String)"nameToSuffixes");
        this.pnsdkSuffixes.putAll(nameToSuffixes);
    }

    @NotNull
    public final RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    public final void setRetryConfiguration(@NotNull RetryConfiguration retryConfiguration) {
        Intrinsics.checkNotNullParameter((Object)retryConfiguration, (String)"<set-?>");
        this.retryConfiguration = retryConfiguration;
    }

    @NotNull
    public final RetryConfiguration getRetryConfForOldSubscribeLoop$pubnub_kotlin() {
        Lazy lazy = this.retryConfForOldSubscribeLoop$delegate;
        return (RetryConfiguration)lazy.getValue();
    }

    private final int calculateMaximumReconnectionRetries(int maxRetryNumber) {
        return this.maximumReconnectionRetries <= -1 ? maxRetryNumber : (this.maximumReconnectionRetries > maxRetryNumber ? maxRetryNumber : this.maximumReconnectionRetries);
    }

    public static final /* synthetic */ int access$calculateMaximumReconnectionRetries(PNConfiguration $this, int maxRetryNumber) {
        return $this.calculateMaximumReconnectionRetries(maxRetryNumber);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\n\u001a\u00020\u000b*\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/pubnub/api/PNConfiguration$Companion;", "", "()V", "CONNECT_TIMEOUT", "", "DEFAULT_DEDUPE_SIZE", "MINIMUM_PRESENCE_TIMEOUT", "NON_SUBSCRIBE_REQUEST_TIMEOUT", "PRESENCE_TIMEOUT", "SUBSCRIBE_TIMEOUT", "isValid", "", "", "isValid$pubnub_kotlin", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValid$pubnub_kotlin(@NotNull String $this$isValid) {
            Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
            return !StringsKt.isBlank((CharSequence)$this$isValid);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

