/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints;

import com.google.gson.JsonElement;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.PNBoundedPage;
import com.pubnub.api.models.consumer.history.HistoryMessageType;
import com.pubnub.api.models.consumer.history.PNFetchMessageItem;
import com.pubnub.api.models.consumer.history.PNFetchMessagesResult;
import com.pubnub.api.models.server.FetchMessagesEnvelope;
import com.pubnub.api.models.server.FetchMessagesPage;
import com.pubnub.api.models.server.history.ServerFetchMessageItem;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.extension.IntKt;
import com.pubnub.extension.JsonElementKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001+BE\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0014J2\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0#j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`$H\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u001bH\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/pubnub/api/endpoints/FetchMessages;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/FetchMessagesEnvelope;", "Lcom/pubnub/api/models/consumer/history/PNFetchMessagesResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channels", "", "", "page", "Lcom/pubnub/api/models/consumer/PNBoundedPage;", "includeUUID", "", "includeMeta", "includeMessageActions", "includeMessageType", "(Lcom/pubnub/api/PubNub;Ljava/util/List;Lcom/pubnub/api/models/consumer/PNBoundedPage;ZZZZ)V", "getChannels", "()Ljava/util/List;", "getIncludeMessageActions", "()Z", "getIncludeMessageType", "getIncludeMeta", "getIncludeUUID", "getPage", "()Lcom/pubnub/api/models/consumer/PNBoundedPage;", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNFetchMessagesOperation;", "validateParams", "Companion", "pubnub-kotlin"})
public final class FetchMessages
extends Endpoint<FetchMessagesEnvelope, PNFetchMessagesResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> channels;
    @NotNull
    private final PNBoundedPage page;
    private final boolean includeUUID;
    private final boolean includeMeta;
    private final boolean includeMessageActions;
    private final boolean includeMessageType;
    private static final int SINGLE_CHANNEL_DEFAULT_MESSAGES = 100;
    private static final int SINGLE_CHANNEL_MAX_MESSAGES = 100;
    private static final int MULTIPLE_CHANNEL_DEFAULT_MESSAGES = 25;
    private static final int MULTIPLE_CHANNEL_MAX_MESSAGES = 25;
    private static final int DEFAULT_MESSAGES_WITH_ACTIONS = 25;
    private static final int MAX_MESSAGES_WITH_ACTIONS = 25;
    @NotNull
    public static final String INCLUDE_MESSAGE_TYPE_QUERY_PARAM = "include_message_type";

    public FetchMessages(@NotNull PubNub pubnub, @NotNull List<String> channels, @NotNull PNBoundedPage page, boolean includeUUID, boolean includeMeta, boolean includeMessageActions, boolean includeMessageType) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        super(pubnub);
        this.channels = channels;
        this.page = page;
        this.includeUUID = includeUUID;
        this.includeMeta = includeMeta;
        this.includeMessageActions = includeMessageActions;
        this.includeMessageType = includeMessageType;
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public final PNBoundedPage getPage() {
        return this.page;
    }

    public final boolean getIncludeUUID() {
        return this.includeUUID;
    }

    public final boolean getIncludeMeta() {
        return this.includeMeta;
    }

    public final boolean getIncludeMessageActions() {
        return this.includeMessageActions;
    }

    public final boolean getIncludeMessageType() {
        return this.includeMessageType;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.channels.isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (this.includeMessageActions && this.channels.size() > 1) {
            throw new PubNubException(PubNubError.HISTORY_MESSAGE_ACTIONS_MULTIPLE_CHANNELS);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected Call<FetchMessagesEnvelope> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return !this.includeMessageActions ? this.getPubnub().getRetrofitManager$pubnub_kotlin().getHistoryService$pubnub_kotlin().fetchMessages(this.getPubnub().getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.channels), (Map<String, String>)queryParams) : this.getPubnub().getRetrofitManager$pubnub_kotlin().getHistoryService$pubnub_kotlin().fetchMessagesWithActions(this.getPubnub().getConfiguration().getSubscribeKey(), (String)CollectionsKt.first(this.channels), (Map<String, String>)queryParams);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected PNFetchMessagesResult createResponse(@NotNull Response<FetchMessagesEnvelope> input) {
        PNBoundedPage pNBoundedPage;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        FetchMessagesEnvelope body = (FetchMessagesEnvelope)object;
        Map<String, List<ServerFetchMessageItem>> $this$mapValues$iv = body.getChannels();
        boolean $i$f$mapValues = false;
        Map<String, List<ServerFetchMessageItem>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            List value = (List)entry2.getValue();
            Iterable $this$map$iv = value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map map4;
                void serverMessageItem;
                ServerFetchMessageItem serverFetchMessageItem = (ServerFetchMessageItem)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Pair<JsonElement, PubNubError> pair = JsonElementKt.tryDecryptMessage(serverMessageItem.getMessage(), this.getPubnub().getCryptoModule$pubnub_kotlin(), this.getPubnub().getMapper());
                JsonElement newMessage = (JsonElement)pair.component1();
                PubNubError error = (PubNubError)((Object)pair.component2());
                if (this.includeMessageActions) {
                    map4 = serverMessageItem.getActions();
                    if (map4 == null) {
                        map4 = MapsKt.emptyMap();
                    }
                } else {
                    map4 = serverMessageItem.getActions();
                }
                Map newActions = map4;
                collection.add(new PNFetchMessageItem(serverMessageItem.getUuid(), newMessage, serverMessageItem.getMeta(), serverMessageItem.getTimetoken(), newActions, this.includeMessageType ? HistoryMessageType.Companion.of$pubnub_kotlin(serverMessageItem.getMessageType()) : null, error));
            }
            List list = (List)destination$iv$iv2;
            map3.put(k, list);
        }
        Map channelsMap = MapsKt.toMap((Map)destination$iv$iv);
        FetchMessagesPage fetchMessagesPage = body.getMore();
        if (fetchMessagesPage != null) {
            FetchMessagesPage it = fetchMessagesPage;
            boolean bl = false;
            pNBoundedPage = new PNBoundedPage(it.getStart(), it.getEnd(), it.getMax());
        } else {
            pNBoundedPage = null;
        }
        PNBoundedPage page = pNBoundedPage;
        return new PNFetchMessagesResult(channelsMap, page);
    }

    @Override
    @NotNull
    public PNOperationType.PNFetchMessagesOperation operationType() {
        return PNOperationType.PNFetchMessagesOperation.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_PERSISTENCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        String string;
        String string2;
        Map<String, String> map;
        queryParams.put("max", String.valueOf(Companion.effectiveMax$pubnub_kotlin(this.page.getLimit(), this.includeMessageActions, this.channels.size())));
        queryParams.put("include_uuid", String.valueOf(this.includeUUID));
        Long l = this.page.getStart();
        if (l != null) {
            long $this$addQueryParams_u24lambda_u243 = ((Number)l).longValue();
            boolean bl = false;
            map = queryParams;
            string2 = "start";
            string = String.valueOf($this$addQueryParams_u24lambda_u243);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            string = string3;
            map.put(string2, string);
        }
        Long l2 = this.page.getEnd();
        if (l2 != null) {
            long $this$addQueryParams_u24lambda_u244 = ((Number)l2).longValue();
            boolean bl = false;
            map = queryParams;
            string2 = "end";
            string = String.valueOf($this$addQueryParams_u24lambda_u244);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string4 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
            string = string4;
            map.put(string2, string);
        }
        queryParams.put(INCLUDE_MESSAGE_TYPE_QUERY_PARAM, String.valueOf(this.includeMessageType));
        if (this.includeMeta) {
            queryParams.put("include_meta", "true");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pubnub/api/endpoints/FetchMessages$Companion;", "", "()V", "DEFAULT_MESSAGES_WITH_ACTIONS", "", "INCLUDE_MESSAGE_TYPE_QUERY_PARAM", "", "MAX_MESSAGES_WITH_ACTIONS", "MULTIPLE_CHANNEL_DEFAULT_MESSAGES", "MULTIPLE_CHANNEL_MAX_MESSAGES", "SINGLE_CHANNEL_DEFAULT_MESSAGES", "SINGLE_CHANNEL_MAX_MESSAGES", "effectiveMax", "maximumPerChannel", "includeMessageActions", "", "numberOfChannels", "effectiveMax$pubnub_kotlin", "(Ljava/lang/Integer;ZI)I", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public final int effectiveMax$pubnub_kotlin(@Nullable Integer maximumPerChannel, boolean includeMessageActions, int numberOfChannels) {
            Integer n;
            Integer n2;
            Integer n3;
            return includeMessageActions ? ((n3 = maximumPerChannel) != null && (n3 = IntKt.nonPositiveToNull(IntKt.limit(n3, 25))) != null ? n3 : 25) : (numberOfChannels == 1 ? ((n2 = maximumPerChannel) != null && (n2 = IntKt.nonPositiveToNull(IntKt.limit(n2, 100))) != null ? n2 : 100) : ((n = maximumPerChannel) != null && (n = IntKt.nonPositiveToNull(IntKt.limit(n, 25))) != null ? n : 25));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

