/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.access;

import com.google.gson.JsonElement;
import com.pubnub.api.Endpoint;
import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtilKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.models.consumer.access_manager.PNAccessManagerGrantResult;
import com.pubnub.api.models.consumer.access_manager.PNAccessManagerKeyData;
import com.pubnub.api.models.consumer.access_manager.PNAccessManagerKeysData;
import com.pubnub.api.models.server.Envelope;
import com.pubnub.api.models.server.access_manager.AccessManagerGrantPayload;
import com.pubnub.api.retry.RetryableEndpointGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001Bq\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\"H\u0002J\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'H\u0002J\u001e\u0010(\u001a\u0004\u0018\u00010\u00042\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020)H\u0014J(\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020+2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100,H\u0014J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\b\u0010/\u001a\u000200H\u0014J\b\u00101\u001a\u00020\bH\u0014J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020 H\u0014R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019\u00a8\u00065"}, d2={"Lcom/pubnub/api/endpoints/access/Grant;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/Envelope;", "Lcom/pubnub/api/models/server/access_manager/AccessManagerGrantPayload;", "Lcom/pubnub/api/models/consumer/access_manager/PNAccessManagerGrantResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "read", "", "write", "manage", "delete", "ttl", "", "authKeys", "", "", "channels", "channelGroups", "(Lcom/pubnub/api/PubNub;ZZZZILjava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAuthKeys", "()Ljava/util/List;", "getChannelGroups", "getChannels", "getDelete", "()Z", "getManage", "getRead", "getTtl", "()I", "getWrite", "addQueryParams", "", "queryParams", "", "createKeyMap", "", "Lcom/pubnub/api/models/consumer/access_manager/PNAccessManagerKeyData;", "input", "Lcom/google/gson/JsonElement;", "createResponse", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isAuthRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNAccessManagerGrant;", "validateParams", "pubnub-kotlin"})
public final class Grant
extends Endpoint<Envelope<AccessManagerGrantPayload>, PNAccessManagerGrantResult> {
    private final boolean read;
    private final boolean write;
    private final boolean manage;
    private final boolean delete;
    private final int ttl;
    @NotNull
    private final List<String> authKeys;
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;

    public Grant(@NotNull PubNub pubnub, boolean read, boolean write, boolean manage, boolean delete, int ttl, @NotNull List<String> authKeys, @NotNull List<String> channels, @NotNull List<String> channelGroups) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(authKeys, (String)"authKeys");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        super(pubnub);
        this.read = read;
        this.write = write;
        this.manage = manage;
        this.delete = delete;
        this.ttl = ttl;
        this.authKeys = authKeys;
        this.channels = channels;
        this.channelGroups = channelGroups;
    }

    public /* synthetic */ Grant(PubNub pubNub, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, List list, List list2, List list3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        if ((n2 & 8) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x10) != 0) {
            bl4 = false;
        }
        if ((n2 & 0x20) != 0) {
            n = -1;
        }
        if ((n2 & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x80) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x100) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        this(pubNub, bl, bl2, bl3, bl4, n, list, list2, list3);
    }

    public final boolean getRead() {
        return this.read;
    }

    public final boolean getWrite() {
        return this.write;
    }

    public final boolean getManage() {
        return this.manage;
    }

    public final boolean getDelete() {
        return this.delete;
    }

    public final int getTtl() {
        return this.ttl;
    }

    @NotNull
    public final List<String> getAuthKeys() {
        return this.authKeys;
    }

    @NotNull
    public final List<String> getChannels() {
        return this.channels;
    }

    @NotNull
    public final List<String> getChannelGroups() {
        return this.channelGroups;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (!PNConfiguration.Companion.isValid$pubnub_kotlin(this.getPubnub().getConfiguration().getSecretKey())) {
            throw new PubNubException(PubNubError.SECRET_KEY_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    @NotNull
    protected Call<Envelope<AccessManagerGrantPayload>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getAccessManagerService$pubnub_kotlin().grant(this.getPubnub().getConfiguration().getSubscribeKey(), (Map<String, String>)queryParams);
    }

    @Override
    @Nullable
    protected PNAccessManagerGrantResult createResponse(@NotNull Response<Envelope<AccessManagerGrantPayload>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        Object t = ((Envelope)object).getPayload$pubnub_kotlin();
        Intrinsics.checkNotNull(t);
        AccessManagerGrantPayload data = (AccessManagerGrantPayload)t;
        Map constructedChannels = new LinkedHashMap();
        Map constructedGroups = new LinkedHashMap();
        String string = data.getChannel$pubnub_kotlin();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Map<String, PNAccessManagerKeyData> map = data.getAuthKeys$pubnub_kotlin();
            Intrinsics.checkNotNull(map);
            constructedChannels.put(it, map);
        }
        if (this.channelGroups.size() == 1) {
            String string2 = this.getPubnub().getMapper().elementToString(data.getChannelGroups$pubnub_kotlin());
            Intrinsics.checkNotNull((Object)string2);
            Map<String, PNAccessManagerKeyData> map = data.getAuthKeys$pubnub_kotlin();
            Intrinsics.checkNotNull(map);
            constructedGroups.put(string2, map);
        } else if (this.channelGroups.size() > 1) {
            MapperManager mapperManager = this.getPubnub().getMapper();
            JsonElement jsonElement = data.getChannelGroups$pubnub_kotlin();
            Intrinsics.checkNotNull((Object)jsonElement);
            Iterator<Map.Entry<String, JsonElement>> it = mapperManager.getObjectIterator(jsonElement);
            while (it.hasNext()) {
                Map.Entry<String, JsonElement> entry = it.next();
                Intrinsics.checkNotNullExpressionValue(entry, (String)"next()");
                String k = entry.getKey();
                JsonElement v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)k, (String)"k");
                Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
                constructedGroups.put(k, this.createKeyMap(v));
            }
        }
        Map<String, PNAccessManagerKeysData> map = data.getChannels$pubnub_kotlin();
        if (map != null) {
            Map<String, PNAccessManagerKeysData> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, PNAccessManagerKeysData>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PNAccessManagerKeysData> element$iv;
                Map.Entry<String, PNAccessManagerKeysData> it = element$iv = iterator.next();
                boolean bl = false;
                String string3 = it.getKey();
                PNAccessManagerKeysData pNAccessManagerKeysData = data.getChannels$pubnub_kotlin().get(it.getKey());
                Intrinsics.checkNotNull((Object)pNAccessManagerKeysData);
                constructedChannels.put(string3, pNAccessManagerKeysData.getAuthKeys$pubnub_kotlin());
            }
        }
        String string4 = data.getLevel$pubnub_kotlin();
        Intrinsics.checkNotNull((Object)string4);
        int n = data.getTtl$pubnub_kotlin();
        String string5 = data.getSubscribeKey$pubnub_kotlin();
        Intrinsics.checkNotNull((Object)string5);
        return new PNAccessManagerGrantResult(string4, n, string5, constructedChannels, constructedGroups);
    }

    @Override
    @NotNull
    public PNOperationType.PNAccessManagerGrant operationType() {
        return PNOperationType.PNAccessManagerGrant.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.ACCESS_MANAGER;
    }

    private final Map<String, PNAccessManagerKeyData> createKeyMap(JsonElement input) {
        Map result = new HashMap();
        Iterator<Map.Entry<String, JsonElement>> it = this.getPubnub().getMapper().getObjectIterator(input, "auths");
        while (it.hasNext()) {
            Map.Entry<String, JsonElement> keyMap = it.next();
            PNAccessManagerKeyData pnAccessManagerKeyData = new PNAccessManagerKeyData();
            pnAccessManagerKeyData.setManageEnabled$pubnub_kotlin(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "m"));
            pnAccessManagerKeyData.setWriteEnabled$pubnub_kotlin(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "w"));
            pnAccessManagerKeyData.setReadEnabled$pubnub_kotlin(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "r"));
            pnAccessManagerKeyData.setDeleteEnabled$pubnub_kotlin(this.getPubnub().getMapper().getAsBoolean(keyMap.getValue(), "d"));
            result.put(keyMap.getKey(), pnAccessManagerKeyData);
        }
        return result;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        List<String> $this$addQueryParams_u24lambda_u242 = this.channels;
        boolean bl = false;
        if (!((Collection)$this$addQueryParams_u24lambda_u242).isEmpty()) {
            queryParams.put("channel", PubNubUtilKt.toCsv($this$addQueryParams_u24lambda_u242));
        }
        List<String> $this$addQueryParams_u24lambda_u243 = this.channelGroups;
        boolean bl2 = false;
        if (!((Collection)$this$addQueryParams_u24lambda_u243).isEmpty()) {
            queryParams.put("channel-group", PubNubUtilKt.toCsv($this$addQueryParams_u24lambda_u243));
        }
        List<String> $this$addQueryParams_u24lambda_u244 = this.authKeys;
        boolean bl3 = false;
        if (!((Collection)$this$addQueryParams_u24lambda_u244).isEmpty()) {
            queryParams.put("auth", PubNubUtilKt.toCsv($this$addQueryParams_u24lambda_u244));
        }
        if (this.ttl >= -1) {
            queryParams.put("ttl", String.valueOf(this.ttl));
        }
        queryParams.put("r", this.read ? "1" : "0");
        queryParams.put("w", this.write ? "1" : "0");
        queryParams.put("m", this.manage ? "1" : "0");
        queryParams.put("d", this.delete ? "1" : "0");
    }
}

