/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.access;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGrant;
import com.pubnub.api.models.consumer.access_manager.v3.ChannelGroupGrant;
import com.pubnub.api.models.consumer.access_manager.v3.PNGrantTokenResult;
import com.pubnub.api.models.consumer.access_manager.v3.UUIDGrant;
import com.pubnub.api.models.server.access_manager.v3.GrantTokenData;
import com.pubnub.api.models.server.access_manager.v3.GrantTokenRequestBody;
import com.pubnub.api.models.server.access_manager.v3.GrantTokenResponse;
import com.pubnub.api.retry.RetryableEndpointGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BS\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0014J2\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\"\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001cj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b`\u001dH\u0014J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0014J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0014J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0014R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/pubnub/api/endpoints/access/GrantToken;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/access_manager/v3/GrantTokenResponse;", "Lcom/pubnub/api/models/consumer/access_manager/v3/PNGrantTokenResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "ttl", "", "meta", "", "authorizedUUID", "", "channels", "", "Lcom/pubnub/api/models/consumer/access_manager/v3/ChannelGrant;", "channelGroups", "Lcom/pubnub/api/models/consumer/access_manager/v3/ChannelGroupGrant;", "uuids", "Lcom/pubnub/api/models/consumer/access_manager/v3/UUIDGrant;", "(Lcom/pubnub/api/PubNub;ILjava/lang/Object;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getTtl", "()I", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isAuthRequired", "", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "validateParams", "", "pubnub-kotlin"})
public final class GrantToken
extends Endpoint<GrantTokenResponse, PNGrantTokenResult> {
    private final int ttl;
    @Nullable
    private final Object meta;
    @Nullable
    private final String authorizedUUID;
    @NotNull
    private final List<ChannelGrant> channels;
    @NotNull
    private final List<ChannelGroupGrant> channelGroups;
    @NotNull
    private final List<UUIDGrant> uuids;

    public GrantToken(@NotNull PubNub pubnub, int ttl, @Nullable Object meta, @Nullable String authorizedUUID, @NotNull List<? extends ChannelGrant> channels, @NotNull List<? extends ChannelGroupGrant> channelGroups, @NotNull List<? extends UUIDGrant> uuids) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelGroups, (String)"channelGroups");
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        super(pubnub);
        this.ttl = ttl;
        this.meta = meta;
        this.authorizedUUID = authorizedUUID;
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.uuids = uuids;
    }

    public final int getTtl() {
        return this.ttl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.channels;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelGrant channelGrant = (ChannelGrant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.channelGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelGroupGrant channelGroupGrant = (ChannelGroupGrant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void validateParams() {
        if (!PNConfiguration.Companion.isValid$pubnub_kotlin(this.getPubnub().getConfiguration().getSecretKey())) {
            throw new PubNubException(PubNubError.SECRET_KEY_MISSING);
        }
        if (!PNConfiguration.Companion.isValid$pubnub_kotlin(this.getPubnub().getConfiguration().getSubscribeKey())) {
            throw new PubNubException(PubNubError.SUBSCRIBE_KEY_MISSING);
        }
        if (CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.channels, (Iterable)this.channelGroups), (Iterable)this.uuids).isEmpty()) {
            PubNubError pubNubError = PubNubError.RESOURCES_MISSING;
            throw new PubNubException("At least one grant required", pubNubError, null, 0, null, null, 60, null);
        }
    }

    @Override
    @NotNull
    protected Call<GrantTokenResponse> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        GrantTokenRequestBody requestBody = GrantTokenRequestBody.Companion.of(this.ttl, this.channels, this.channelGroups, this.uuids, this.meta, this.authorizedUUID);
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getAccessManagerService$pubnub_kotlin().grantToken(this.getPubnub().getConfiguration().getSubscribeKey(), requestBody, (Map<String, String>)queryParams);
    }

    @Override
    @Nullable
    protected PNGrantTokenResult createResponse(@NotNull Response<GrantTokenResponse> input) {
        PNGrantTokenResult pNGrantTokenResult;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = (GrantTokenResponse)input.body();
        if (object != null && (object = ((GrantTokenResponse)object).getData()) != null && (object = ((GrantTokenData)object).getToken()) != null) {
            Object it = object;
            boolean bl = false;
            pNGrantTokenResult = new PNGrantTokenResult((String)it);
        } else {
            pNGrantTokenResult = null;
        }
        return pNGrantTokenResult;
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.PNAccessManagerGrantToken.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.ACCESS_MANAGER;
    }
}

