/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.access;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.server.access_manager.v3.RevokeTokenResponse;
import com.pubnub.api.retry.RetryableEndpointGroup;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0014J2\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\"\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000fj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pubnub/api/endpoints/access/RevokeToken;", "Lcom/pubnub/api/Endpoint;", "Lcom/pubnub/api/models/server/access_manager/v3/RevokeTokenResponse;", "", "pubnub", "Lcom/pubnub/api/PubNub;", "token", "", "(Lcom/pubnub/api/PubNub;Ljava/lang/String;)V", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isAuthRequired", "", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "repairEncoding", "validateParams", "pubnub-kotlin"})
public final class RevokeToken
extends Endpoint<RevokeTokenResponse, Unit> {
    @NotNull
    private final String token;

    public RevokeToken(@NotNull PubNub pubnub, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        super(pubnub);
        this.token = token;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (!PNConfiguration.Companion.isValid$pubnub_kotlin(this.getPubnub().getConfiguration().getSecretKey())) {
            throw new PubNubException(PubNubError.SECRET_KEY_MISSING);
        }
        if (StringsKt.isBlank((CharSequence)this.token)) {
            throw new PubNubException(PubNubError.TOKEN_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<RevokeTokenResponse> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getAccessManagerService$pubnub_kotlin().revokeToken(this.getPubnub().getConfiguration().getSubscribeKey(), this.repairEncoding(this.token), (Map<String, String>)queryParams);
    }

    @Override
    protected void createResponse(@NotNull Response<RevokeTokenResponse> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.PNAccessManagerRevokeToken.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.ACCESS_MANAGER;
    }

    private final String repairEncoding(String token) {
        String string = URLEncoder.encode(token, "utf-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(token, \"utf-8\")");
        return StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }
}

