/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.channel_groups;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.channel_group.PNChannelGroupsDeleteGroupResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0014J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/pubnub/api/endpoints/channel_groups/DeleteChannelGroup;", "Lcom/pubnub/api/Endpoint;", "Ljava/lang/Void;", "Lcom/pubnub/api/models/consumer/channel_group/PNChannelGroupsDeleteGroupResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channelGroup", "", "(Lcom/pubnub/api/PubNub;Ljava/lang/String;)V", "getChannelGroup", "()Ljava/lang/String;", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "getAffectedChannelGroups", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNRemoveGroupOperation;", "validateParams", "", "pubnub-kotlin"})
public final class DeleteChannelGroup
extends Endpoint<Void, PNChannelGroupsDeleteGroupResult> {
    @NotNull
    private final String channelGroup;

    public DeleteChannelGroup(@NotNull PubNub pubnub, @NotNull String channelGroup) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channelGroup, (String)"channelGroup");
        super(pubnub);
        this.channelGroup = channelGroup;
    }

    @NotNull
    public final String getChannelGroup() {
        return this.channelGroup;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.channelGroup)) {
            throw new PubNubException(PubNubError.GROUP_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.listOf((Object)this.channelGroup);
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getChannelGroupService$pubnub_kotlin().deleteChannelGroup(this.getPubnub().getConfiguration().getSubscribeKey(), this.channelGroup, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNChannelGroupsDeleteGroupResult createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return new PNChannelGroupsDeleteGroupResult();
    }

    @Override
    @NotNull
    public PNOperationType.PNRemoveGroupOperation operationType() {
        return PNOperationType.PNRemoveGroupOperation.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.CHANNEL_GROUP;
    }
}

