/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.files.PNFileUrlResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJB\u0010\u0015\u001a\u00020\u001228\u0010\u0016\u001a4\u0012\u0015\u0012\u0013\u0018\u00010\u0003\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\fH\u0016J\u0016\u0010\u0017\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0014J2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001dj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u001eH\u0014J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 H\u0014J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050 H\u0014J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020%H\u0014J\b\u0010'\u001a\u00020%H\u0014J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\n\u0010+\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010,\u001a\u00020\u0012H\u0014R@\u0010\u000b\u001a4\u0012\u0015\u0012\u0013\u0018\u00010\u0003\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/pubnub/api/endpoints/files/GetFileUrl;", "Lcom/pubnub/api/Endpoint;", "Lokhttp3/ResponseBody;", "Lcom/pubnub/api/models/consumer/files/PNFileUrlResult;", "channel", "", "fileName", "fileId", "pubNub", "Lcom/pubnub/api/PubNub;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/api/PubNub;)V", "cachedCallback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "result", "Lcom/pubnub/api/models/consumer/PNStatus;", "status", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "async", "callback", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isAuthRequired", "", "isPubKeyRequired", "isSubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "retry", "sync", "validateParams", "pubnub-kotlin"})
public final class GetFileUrl
extends Endpoint<ResponseBody, PNFileUrlResult> {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;
    @NotNull
    private final String fileId;
    private Function2<? super PNFileUrlResult, ? super PNStatus, Unit> cachedCallback;
    @NotNull
    private final ExecutorService executorService;

    public GetFileUrl(@NotNull String channel, @NotNull String fileName, @NotNull String fileId, @NotNull PubNub pubNub) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
        super(pubNub);
        this.channel = channel;
        this.fileName = fileName;
        this.fileId = fileId;
        this.executorService = pubNub.getRetrofitManager$pubnub_kotlin().getTransactionClientExecutorService();
    }

    @Override
    protected void validateParams() throws PubNubException {
        super.validateParams();
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @Nullable
    public PNFileUrlResult sync() throws PubNubException {
        PNFileUrlResult pNFileUrlResult;
        try {
            Map baseParams = this.createBaseParams();
            Call<ResponseBody> call = this.getPubnub().getRetrofitManager$pubnub_kotlin().getFilesService$pubnub_kotlin().downloadFile(this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, this.fileId, this.fileName, baseParams);
            Request request = call.request();
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"call.request()");
            Request signedRequest = PubNubUtil.INSTANCE.signRequest(request, this.getPubnub().getConfiguration(), this.getPubnub().timestamp$pubnub_kotlin());
            pNFileUrlResult = new PNFileUrlResult(signedRequest.url().toString());
        }
        catch (Exception e) {
            throw new PubNubException(e.getMessage(), null, null, 0, null, null, 62, null);
        }
        return pNFileUrlResult;
    }

    @Override
    public void async(@NotNull Function2<? super PNFileUrlResult, ? super PNStatus, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.cachedCallback = callback;
        this.executorService.execute(() -> GetFileUrl.async$lambda$1(this, callback));
    }

    @Override
    @NotNull
    protected Call<ResponseBody> doWork(@NotNull HashMap<String, String> queryParams) throws PubNubException {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        throw new PubNubException(PubNubError.INTERNAL_ERROR);
    }

    @Override
    @NotNull
    protected PNFileUrlResult createResponse(@NotNull Response<ResponseBody> input) throws PubNubException {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        throw new PubNubException(PubNubError.INTERNAL_ERROR);
    }

    @Override
    public void retry() {
        Function2<? super PNFileUrlResult, ? super PNStatus, Unit> function2 = this.cachedCallback;
        if (function2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCallback");
            function2 = null;
        }
        this.async(function2);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.FILE_PERSISTENCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void async$lambda$1(GetFileUrl this$0, Function2 $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        try {
            PNFileUrlResult res = this$0.sync();
            PNStatusCategory pNStatusCategory = PNStatusCategory.PNAcknowledgmentCategory;
            PNOperationType pNOperationType = this$0.operationType();
            $callback.invoke((Object)res, (Object)new PNStatus(pNStatusCategory, false, pNOperationType, null, null, null, null, null, null, null, null, 2040, null));
        }
        catch (PubNubException ex) {
            void $this$async_u24lambda_u241_u24lambda_u240;
            Object object = PNStatusCategory.PNUnknownCategory;
            Object object2 = this$0.operationType();
            List<String> list = this$0.getAffectedChannels();
            object = new PNStatus((PNStatusCategory)((Object)object), true, (PNOperationType)object2, ex, null, null, null, null, null, list, null, 1520, null);
            object2 = object;
            Object var7_10 = null;
            Function2 function2 = $callback;
            boolean bl = false;
            $this$async_u24lambda_u241_u24lambda_u240.setExecutedEndpoint$pubnub_kotlin(this$0);
            Unit unit = Unit.INSTANCE;
            function2.invoke(var7_10, object);
        }
    }
}

