/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.files;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.crypto.CryptoModuleKt;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.files.PNBaseFile;
import com.pubnub.api.models.consumer.files.PNPublishFileMessageResult;
import com.pubnub.api.models.server.files.FileUploadNotification;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.extension.BooleanKt;
import com.pubnub.extension.StringKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001:\u0001)BU\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0016\u001a\u00020\u00042\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0018H\u0014J8\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001a2\"\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001cj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u001dH\u0014J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0002H\u0014J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0002H\u0014J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\u000eH\u0014J\b\u0010#\u001a\u00020\u000eH\u0014J\b\u0010$\u001a\u00020\u000eH\u0014J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006*"}, d2={"Lcom/pubnub/api/endpoints/files/PublishFileMessage;", "Lcom/pubnub/api/Endpoint;", "", "", "Lcom/pubnub/api/models/consumer/files/PNPublishFileMessageResult;", "channel", "", "fileName", "fileId", "message", "meta", "ttl", "", "shouldStore", "", "pubNub", "Lcom/pubnub/api/PubNub;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/Boolean;Lcom/pubnub/api/PubNub;)V", "pnFile", "Lcom/pubnub/api/models/consumer/files/PNBaseFile;", "Ljava/lang/Boolean;", "Ljava/lang/Integer;", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isAuthRequired", "isPubKeyRequired", "isSubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "validateParams", "", "Factory", "pubnub-kotlin"})
public class PublishFileMessage
extends Endpoint<List<? extends Object>, PNPublishFileMessageResult> {
    @NotNull
    private final String channel;
    @Nullable
    private final Object message;
    @Nullable
    private final Object meta;
    @Nullable
    private final Integer ttl;
    @Nullable
    private final Boolean shouldStore;
    @NotNull
    private final PNBaseFile pnFile;

    public PublishFileMessage(@NotNull String channel, @NotNull String fileName, @NotNull String fileId, @Nullable Object message, @Nullable Object meta, @Nullable Integer ttl, @Nullable Boolean shouldStore, @NotNull PubNub pubNub) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
        super(pubNub);
        this.channel = channel;
        this.message = message;
        this.meta = meta;
        this.ttl = ttl;
        this.shouldStore = shouldStore;
        this.pnFile = new PNBaseFile(fileId, fileName);
    }

    public /* synthetic */ PublishFileMessage(String string, String string2, String string3, Object object, Object object2, Integer n, Boolean bl, PubNub pubNub, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            object = null;
        }
        if ((n2 & 0x10) != 0) {
            object2 = null;
        }
        if ((n2 & 0x20) != 0) {
            n = null;
        }
        if ((n2 & 0x40) != 0) {
            bl = null;
        }
        this(string, string2, string3, object, object2, n, bl, pubNub);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<List<Object>> doWork(@NotNull HashMap<String, String> queryParams) throws PubNubException {
        Object messageAsString;
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            String stringifiedMessage = this.getPubnub().getMapper().toJson(new FileUploadNotification(this.message, this.pnFile));
            Object object2 = this.getPubnub().getCryptoModule$pubnub_kotlin();
            if (object2 == null || (object2 = CryptoModuleKt.encryptString((CryptoModule)object2, stringifiedMessage)) == null || (object2 = StringKt.quoted((String)object2)) == null) {
                object2 = stringifiedMessage;
            }
            messageAsString = object2;
            Object object3 = this.meta;
            if (object3 != null) {
                Object it = object3;
                boolean bl = false;
                String stringifiedMeta = this.getPubnub().getMapper().toJson(it);
                ((Map)queryParams).put("meta", stringifiedMeta);
            }
            if ((object = this.shouldStore) != null && (object = BooleanKt.getNumericString((Boolean)object)) != null) {
                Object it = object;
                boolean bl = false;
                ((Map)queryParams).put("store", it);
            }
            Integer n = this.ttl;
            if (n == null) break block3;
            int it = ((Number)n).intValue();
            boolean bl = false;
            ((Map)queryParams).put("ttl", String.valueOf(it));
        }
        return this.getPubnub().getRetrofitManager$pubnub_kotlin().getFilesService$pubnub_kotlin().notifyAboutFileUpload(this.getPubnub().getConfiguration().getPublishKey(), this.getPubnub().getConfiguration().getSubscribeKey(), this.channel, (String)messageAsString, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNPublishFileMessageResult createResponse(@NotNull Response<List<Object>> input) throws PubNubException {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        List list = (List)input.body();
        if (list == null) {
            throw new PubNubException(PubNubError.INTERNAL_ERROR);
        }
        List body = list;
        boolean bl = false;
        long timetoken = Long.parseLong(body.get(2).toString());
        return new PNPublishFileMessageResult(timetoken);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation.INSTANCE;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return true;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PUBLISH;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JY\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pubnub/api/endpoints/files/PublishFileMessage$Factory;", "", "pubNub", "Lcom/pubnub/api/PubNub;", "(Lcom/pubnub/api/PubNub;)V", "create", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "Lcom/pubnub/api/models/consumer/files/PNPublishFileMessageResult;", "channel", "", "fileName", "fileId", "message", "meta", "ttl", "", "shouldStore", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/Boolean;)Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "pubnub-kotlin"})
    public static final class Factory {
        @NotNull
        private final PubNub pubNub;

        public Factory(@NotNull PubNub pubNub) {
            Intrinsics.checkNotNullParameter((Object)pubNub, (String)"pubNub");
            this.pubNub = pubNub;
        }

        @NotNull
        public final ExtendedRemoteAction<PNPublishFileMessageResult> create(@NotNull String channel, @NotNull String fileName, @NotNull String fileId, @Nullable Object message, @Nullable Object meta, @Nullable Integer ttl, @Nullable Boolean shouldStore) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
            return new PublishFileMessage(channel, fileName, fileId, message, meta, ttl, shouldStore, this.pubNub);
        }

        public static /* synthetic */ ExtendedRemoteAction create$default(Factory factory, String string, String string2, String string3, Object object, Object object2, Integer n, Boolean bl, int n2, Object object3) {
            if ((n2 & 8) != 0) {
                object = null;
            }
            if ((n2 & 0x10) != 0) {
                object2 = null;
            }
            if ((n2 & 0x20) != 0) {
                n = null;
            }
            if ((n2 & 0x40) != 0) {
                bl = null;
            }
            return factory.create(string, string2, string3, object, object2, n, bl);
        }
    }
}

