/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.message_actions;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.message_actions.PNRemoveMessageActionResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.services.MessageActionService;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B'\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0014J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017H\u0014J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006 "}, d2={"Lcom/pubnub/api/endpoints/message_actions/RemoveMessageAction;", "Lcom/pubnub/api/Endpoint;", "Ljava/lang/Void;", "Lcom/pubnub/api/models/consumer/message_actions/PNRemoveMessageActionResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "channel", "", "messageTimetoken", "", "actionTimetoken", "(Lcom/pubnub/api/PubNub;Ljava/lang/String;JJ)V", "getActionTimetoken", "()J", "getChannel", "()Ljava/lang/String;", "getMessageTimetoken", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "getAffectedChannels", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNDeleteMessageAction;", "validateParams", "", "pubnub-kotlin"})
public final class RemoveMessageAction
extends Endpoint<Void, PNRemoveMessageActionResult> {
    @NotNull
    private final String channel;
    private final long messageTimetoken;
    private final long actionTimetoken;

    public RemoveMessageAction(@NotNull PubNub pubnub, @NotNull String channel, long messageTimetoken, long actionTimetoken) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(pubnub);
        this.channel = channel;
        this.messageTimetoken = messageTimetoken;
        this.actionTimetoken = actionTimetoken;
    }

    @NotNull
    public final String getChannel() {
        return this.channel;
    }

    public final long getMessageTimetoken() {
        return this.messageTimetoken;
    }

    public final long getActionTimetoken() {
        return this.actionTimetoken;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.channel)) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf((Object)this.channel);
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        MessageActionService messageActionService = this.getPubnub().getRetrofitManager$pubnub_kotlin().getMessageActionService$pubnub_kotlin();
        String string = this.getPubnub().getConfiguration().getSubscribeKey();
        String string2 = String.valueOf(this.messageTimetoken);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        string2 = String.valueOf(this.actionTimetoken);
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
        String string4 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
        return messageActionService.deleteMessageAction(string, this.channel, string3, string4, (Map<String, String>)queryParams);
    }

    @Override
    @Nullable
    protected PNRemoveMessageActionResult createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        return new PNRemoveMessageActionResult();
    }

    @Override
    @NotNull
    public PNOperationType.PNDeleteMessageAction operationType() {
        return PNOperationType.PNDeleteMessageAction.INSTANCE;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_REACTION;
    }
}

