/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.push;

import com.pubnub.api.Endpoint;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.models.consumer.push.PNPushListProvisionsResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B5\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001bH\u0014J(\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001d2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0016H\u0014R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/pubnub/api/endpoints/push/ListPushProvisions;", "Lcom/pubnub/api/Endpoint;", "", "", "Lcom/pubnub/api/models/consumer/push/PNPushListProvisionsResult;", "pubnub", "Lcom/pubnub/api/PubNub;", "pushType", "Lcom/pubnub/api/enums/PNPushType;", "deviceId", "topic", "environment", "Lcom/pubnub/api/enums/PNPushEnvironment;", "(Lcom/pubnub/api/PubNub;Lcom/pubnub/api/enums/PNPushType;Ljava/lang/String;Ljava/lang/String;Lcom/pubnub/api/enums/PNPushEnvironment;)V", "getDeviceId", "()Ljava/lang/String;", "getEnvironment", "()Lcom/pubnub/api/enums/PNPushEnvironment;", "getPushType", "()Lcom/pubnub/api/enums/PNPushType;", "getTopic", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNPushNotificationEnabledChannelsOperation;", "validateParams", "pubnub-kotlin"})
public final class ListPushProvisions
extends Endpoint<List<? extends String>, PNPushListProvisionsResult> {
    @NotNull
    private final PNPushType pushType;
    @NotNull
    private final String deviceId;
    @Nullable
    private final String topic;
    @NotNull
    private final PNPushEnvironment environment;

    public ListPushProvisions(@NotNull PubNub pubnub, @NotNull PNPushType pushType, @NotNull String deviceId, @Nullable String topic, @NotNull PNPushEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        Intrinsics.checkNotNullParameter((Object)((Object)pushType), (String)"pushType");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        super(pubnub);
        this.pushType = pushType;
        this.deviceId = deviceId;
        this.topic = topic;
        this.environment = environment;
    }

    public /* synthetic */ ListPushProvisions(PubNub pubNub, PNPushType pNPushType, String string, String string2, PNPushEnvironment pNPushEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            pNPushEnvironment = PNPushEnvironment.DEVELOPMENT;
        }
        this(pubNub, pNPushType, string, string2, pNPushEnvironment);
    }

    @NotNull
    public final PNPushType getPushType() {
        return this.pushType;
    }

    @NotNull
    public final String getDeviceId() {
        return this.deviceId;
    }

    @Nullable
    public final String getTopic() {
        return this.topic;
    }

    @NotNull
    public final PNPushEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    protected void validateParams() {
        CharSequence charSequence;
        super.validateParams();
        if (StringsKt.isBlank((CharSequence)this.deviceId)) {
            throw new PubNubException(PubNubError.DEVICE_ID_MISSING);
        }
        if (this.pushType == PNPushType.APNS2 && ((charSequence = (CharSequence)this.topic) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            throw new PubNubException(PubNubError.PUSH_TOPIC_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<List<String>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.pushType != PNPushType.APNS2 ? this.getPubnub().getRetrofitManager$pubnub_kotlin().getPushService$pubnub_kotlin().listChannelsForDevice(this.getPubnub().getConfiguration().getSubscribeKey(), this.deviceId, (Map<String, String>)queryParams) : this.getPubnub().getRetrofitManager$pubnub_kotlin().getPushService$pubnub_kotlin().listChannelsForDeviceApns2(this.getPubnub().getConfiguration().getSubscribeKey(), this.deviceId, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNPushListProvisionsResult createResponse(@NotNull Response<List<String>> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = input.body();
        Intrinsics.checkNotNull((Object)object);
        return new PNPushListProvisionsResult((List)object);
    }

    @Override
    @NotNull
    public PNOperationType.PNPushNotificationEnabledChannelsOperation operationType() {
        return PNOperationType.PNPushNotificationEnabledChannelsOperation.INSTANCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        block1: {
            if (this.pushType != PNPushType.APNS2) {
                queryParams.put("type", this.pushType.toParamString());
                return;
            }
            Map<String, String> map = queryParams;
            String string = "environment";
            String string2 = this.environment.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            string2 = string3;
            map.put(string, string2);
            String string4 = this.topic;
            if (string4 == null) break block1;
            String $this$addQueryParams_u24lambda_u240 = string4;
            boolean bl = false;
            queryParams.put("topic", $this$addQueryParams_u24lambda_u240);
        }
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PUSH_NOTIFICATION;
    }
}

