/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.remoteaction;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u001c\u001dB+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJB\u0010\u0013\u001a\u00020\u001228\u0010\u0014\u001a4\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\fH\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u000f\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0002R@\u0010\u000b\u001a4\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/pubnub/api/endpoints/remoteaction/RetryingRemoteAction;", "T", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "remoteAction", "maxNumberOfAutomaticRetries", "", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;ILcom/pubnub/api/enums/PNOperationType;Ljava/util/concurrent/ExecutorService;)V", "cachedCallback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "result", "Lcom/pubnub/api/models/consumer/PNStatus;", "status", "", "async", "callback", "retry", "silentCancel", "sync", "()Ljava/lang/Object;", "syncAsync", "Lcom/pubnub/api/endpoints/remoteaction/RetryingRemoteAction$ResultAndStatus;", "validate", "Companion", "ResultAndStatus", "pubnub-kotlin"})
public final class RetryingRemoteAction<T>
implements ExtendedRemoteAction<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtendedRemoteAction<T> remoteAction;
    private final int maxNumberOfAutomaticRetries;
    @NotNull
    private final PNOperationType operationType;
    @NotNull
    private final ExecutorService executorService;
    private Function2<? super T, ? super PNStatus, Unit> cachedCallback;

    public RetryingRemoteAction(@NotNull ExtendedRemoteAction<T> remoteAction, int maxNumberOfAutomaticRetries, @NotNull PNOperationType operationType, @NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter(remoteAction, (String)"remoteAction");
        Intrinsics.checkNotNullParameter((Object)operationType, (String)"operationType");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.remoteAction = remoteAction;
        this.maxNumberOfAutomaticRetries = maxNumberOfAutomaticRetries;
        this.operationType = operationType;
        this.executorService = executorService;
    }

    @Override
    @Nullable
    public T sync() throws PubNubException {
        this.validate();
        PubNubException thrownException = null;
        int n = this.maxNumberOfAutomaticRetries;
        for (int i = 0; i < n; ++i) {
            try {
                return (T)this.remoteAction.sync();
            }
            catch (PubNubException ex) {
                thrownException = ex;
                continue;
            }
        }
        PubNubException pubNubException = thrownException;
        Intrinsics.checkNotNull(pubNubException);
        throw pubNubException;
    }

    @Override
    public void async(@NotNull Function2<? super T, ? super PNStatus, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.cachedCallback = callback;
        this.executorService.execute(() -> RetryingRemoteAction.async$lambda$1(this, callback));
    }

    @Override
    public void retry() {
        Function2<? super T, ? super PNStatus, Unit> function2 = this.cachedCallback;
        if (function2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCallback");
            function2 = null;
        }
        this.async(function2);
    }

    @Override
    public void silentCancel() {
        this.remoteAction.silentCancel();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return this.remoteAction.operationType();
    }

    /*
     * WARNING - void declaration
     */
    private final ResultAndStatus<T> syncAsync() {
        ResultAndStatus<Object> resultAndStatus;
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference atomicResultAndStatus = new AtomicReference();
        this.remoteAction.async((Function2)new Function2<T, PNStatus, Unit>(atomicResultAndStatus, latch, this){
            final /* synthetic */ AtomicReference<ResultAndStatus<T>> $atomicResultAndStatus;
            final /* synthetic */ CountDownLatch $latch;
            final /* synthetic */ RetryingRemoteAction<T> this$0;
            {
                this.$atomicResultAndStatus = $atomicResultAndStatus;
                this.$latch = $latch;
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@Nullable T result, @NotNull PNStatus status) {
                void $this$invoke_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                PNStatus pNStatus = PNStatus.copy$default(status, null, false, null, null, null, null, null, null, null, null, null, 2047, null);
                RetryingRemoteAction<T> retryingRemoteAction = this.this$0;
                PNStatus pNStatus2 = pNStatus;
                T t = result;
                AtomicReference<ResultAndStatus<T>> atomicReference = this.$atomicResultAndStatus;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setExecutedEndpoint$pubnub_kotlin((ExtendedRemoteAction)retryingRemoteAction);
                Unit unit = Unit.INSTANCE;
                PNStatus pNStatus3 = pNStatus;
                T t2 = t;
                atomicReference.set(new ResultAndStatus<T>(t2, pNStatus3));
                this.$latch.countDown();
            }
        });
        try {
            latch.await();
            ResultAndStatus resultAndStatus2 = atomicResultAndStatus.get();
            Intrinsics.checkNotNullExpressionValue(resultAndStatus2, (String)"{\n            latch.awai\u2026AndStatus.get()\n        }");
            resultAndStatus = resultAndStatus2;
        }
        catch (InterruptedException e) {
            void $this$syncAsync_u24lambda_u242;
            this.remoteAction.silentCancel();
            Object object = PNStatusCategory.PNUnknownCategory;
            Object object2 = this.operationType;
            PubNubException pubNubException = new PubNubException(e.getMessage(), null, null, 0, null, null, 62, null);
            object = new PNStatus((PNStatusCategory)((Object)object), true, (PNOperationType)object2, pubNubException, null, null, null, null, null, null, null, 2032, null);
            object2 = object;
            Object t = null;
            boolean bl = false;
            $this$syncAsync_u24lambda_u242.setExecutedEndpoint$pubnub_kotlin(this);
            Object object3 = object;
            Object t2 = t;
            resultAndStatus = new ResultAndStatus<Object>(t2, (PNStatus)object3);
        }
        return resultAndStatus;
    }

    private final void validate() throws PubNubException {
        if (this.maxNumberOfAutomaticRetries < 1) {
            throw new PubNubException(PubNubError.INVALID_ARGUMENTS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void async$lambda$1(RetryingRemoteAction this$0, Function2 $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        try {
            this$0.validate();
        }
        catch (PubNubException ex) {
            void $this$async_u24lambda_u241_u24lambda_u240;
            Object object = this$0.operationType;
            Object object2 = PNStatusCategory.PNBadRequestCategory;
            object = new PNStatus((PNStatusCategory)((Object)object2), true, (PNOperationType)object, ex, null, null, null, null, null, null, null, 2032, null);
            object2 = object;
            Object var7_8 = null;
            Function2 function2 = $callback;
            boolean bl = false;
            $this$async_u24lambda_u241_u24lambda_u240.setExecutedEndpoint$pubnub_kotlin(this$0);
            Unit unit = Unit.INSTANCE;
            function2.invoke(var7_8, object);
            return;
        }
        ResultAndStatus lastResultAndStatus = null;
        int n = this$0.maxNumberOfAutomaticRetries;
        for (int i = 0; i < n; ++i) {
            lastResultAndStatus = this$0.syncAsync();
            if (lastResultAndStatus.getStatus().getError()) continue;
            $callback.invoke(lastResultAndStatus.getResult(), (Object)lastResultAndStatus.getStatus());
            return;
        }
        ResultAndStatus resultAndStatus = lastResultAndStatus;
        Intrinsics.checkNotNull(resultAndStatus);
        $callback.invoke(resultAndStatus.getResult(), (Object)lastResultAndStatus.getStatus());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0019\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00018\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00018\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/pubnub/api/endpoints/remoteaction/RetryingRemoteAction$ResultAndStatus;", "T", "", "result", "status", "Lcom/pubnub/api/models/consumer/PNStatus;", "(Ljava/lang/Object;Lcom/pubnub/api/models/consumer/PNStatus;)V", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStatus", "()Lcom/pubnub/api/models/consumer/PNStatus;", "component1", "component2", "copy", "(Ljava/lang/Object;Lcom/pubnub/api/models/consumer/PNStatus;)Lcom/pubnub/api/endpoints/remoteaction/RetryingRemoteAction$ResultAndStatus;", "equals", "", "other", "hashCode", "", "toString", "", "pubnub-kotlin"})
    private static final class ResultAndStatus<T> {
        @Nullable
        private final T result;
        @NotNull
        private final PNStatus status;

        public ResultAndStatus(@Nullable T result, @NotNull PNStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.result = result;
            this.status = status;
        }

        public /* synthetic */ ResultAndStatus(Object object, PNStatus pNStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                object = null;
            }
            this(object, pNStatus);
        }

        @Nullable
        public final T getResult() {
            return this.result;
        }

        @NotNull
        public final PNStatus getStatus() {
            return this.status;
        }

        @Nullable
        public final T component1() {
            return this.result;
        }

        @NotNull
        public final PNStatus component2() {
            return this.status;
        }

        @NotNull
        public final ResultAndStatus<T> copy(@Nullable T result, @NotNull PNStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return new ResultAndStatus<T>(result, status);
        }

        public static /* synthetic */ ResultAndStatus copy$default(ResultAndStatus resultAndStatus, Object object, PNStatus pNStatus, int n, Object object2) {
            if ((n & 1) != 0) {
                object = resultAndStatus.result;
            }
            if ((n & 2) != 0) {
                pNStatus = resultAndStatus.status;
            }
            return resultAndStatus.copy(object, pNStatus);
        }

        @NotNull
        public String toString() {
            return "ResultAndStatus(result=" + this.result + ", status=" + this.status + ')';
        }

        public int hashCode() {
            int result = this.result == null ? 0 : this.result.hashCode();
            result = result * 31 + this.status.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResultAndStatus)) {
                return false;
            }
            ResultAndStatus resultAndStatus = (ResultAndStatus)other;
            if (!Intrinsics.areEqual(this.result, resultAndStatus.result)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.status, (Object)resultAndStatus.status);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/pubnub/api/endpoints/remoteaction/RetryingRemoteAction$Companion;", "", "()V", "autoRetry", "Lcom/pubnub/api/endpoints/remoteaction/RetryingRemoteAction;", "T", "remoteAction", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "maxNumberOfAutomaticRetries", "", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "executorService", "Ljava/util/concurrent/ExecutorService;", "pubnub-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> RetryingRemoteAction<T> autoRetry(@NotNull ExtendedRemoteAction<T> remoteAction, int maxNumberOfAutomaticRetries, @NotNull PNOperationType operationType, @NotNull ExecutorService executorService) {
            Intrinsics.checkNotNullParameter(remoteAction, (String)"remoteAction");
            Intrinsics.checkNotNullParameter((Object)operationType, (String)"operationType");
            Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
            return new RetryingRemoteAction<T>(remoteAction, maxNumberOfAutomaticRetries, operationType, executorService);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

