/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.ReconnectionCallback;
import com.pubnub.api.endpoints.Time;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.PNTimeResult;
import com.pubnub.api.retry.RetryConfiguration;
import java.util.Calendar;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\rH\u0002J\b\u0010\u001f\u001a\u00020\u0006H\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\u0015\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/pubnub/api/managers/ReconnectionManager;", "", "pubnub", "Lcom/pubnub/api/PubNub;", "(Lcom/pubnub/api/PubNub;)V", "exponentialMultiplier", "", "failedCalls", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "maxConnectionRetries", "pnReconnectionPolicy", "Lcom/pubnub/api/retry/RetryConfiguration;", "getPubnub", "()Lcom/pubnub/api/PubNub;", "random", "Ljava/util/Random;", "reconnectionCallback", "Lcom/pubnub/api/callbacks/ReconnectionCallback;", "getReconnectionCallback$pubnub_kotlin", "()Lcom/pubnub/api/callbacks/ReconnectionCallback;", "setReconnectionCallback$pubnub_kotlin", "(Lcom/pubnub/api/callbacks/ReconnectionCallback;)V", "timer", "Ljava/util/Timer;", "callTime", "", "getBestIntervalInMillis", "getMaxConnectionRetries", "retryConfiguration", "getRandomDelayInMilliSeconds", "isReconnectionPolicyUndefined", "", "registerRetryTimer", "startPolling", "pnConfiguration", "Lcom/pubnub/api/PNConfiguration;", "startPolling$pubnub_kotlin", "stopRetryTimer", "Companion", "pubnub-kotlin"})
public final class ReconnectionManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PubNub pubnub;
    private final Logger log;
    public ReconnectionCallback reconnectionCallback;
    private int exponentialMultiplier;
    private int failedCalls;
    private RetryConfiguration pnReconnectionPolicy;
    private int maxConnectionRetries;
    @Nullable
    private Timer timer;
    @NotNull
    private final Random random;
    @Deprecated
    private static final int LINEAR_INTERVAL = 3;
    @Deprecated
    private static final int MIN_EXPONENTIAL_BACKOFF = 1;
    @Deprecated
    private static final int MAX_EXPONENTIAL_BACKOFF = 32;
    @Deprecated
    private static final int MILLISECONDS = 1000;
    @Deprecated
    private static final int MAX_RANDOM_DELAY_IN_MILLIS = 1000;
    @Deprecated
    private static final int NO_RETRIES = 0;

    public ReconnectionManager(@NotNull PubNub pubnub) {
        Intrinsics.checkNotNullParameter((Object)pubnub, (String)"pubnub");
        this.pubnub = pubnub;
        this.log = LoggerFactory.getLogger((String)"ReconnectionManager");
        this.exponentialMultiplier = 1;
        this.maxConnectionRetries = 6;
        this.random = new Random();
    }

    @NotNull
    public final PubNub getPubnub() {
        return this.pubnub;
    }

    @NotNull
    public final ReconnectionCallback getReconnectionCallback$pubnub_kotlin() {
        ReconnectionCallback reconnectionCallback = this.reconnectionCallback;
        if (reconnectionCallback != null) {
            return reconnectionCallback;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"reconnectionCallback");
        return null;
    }

    public final void setReconnectionCallback$pubnub_kotlin(@NotNull ReconnectionCallback reconnectionCallback) {
        Intrinsics.checkNotNullParameter((Object)reconnectionCallback, (String)"<set-?>");
        this.reconnectionCallback = reconnectionCallback;
    }

    public final void startPolling$pubnub_kotlin(@NotNull PNConfiguration pnConfiguration) {
        Intrinsics.checkNotNullParameter((Object)pnConfiguration, (String)"pnConfiguration");
        this.pnReconnectionPolicy = pnConfiguration.getRetryConfForOldSubscribeLoop$pubnub_kotlin();
        if (this.isReconnectionPolicyUndefined()) {
            return;
        }
        RetryConfiguration retryConfiguration = this.pnReconnectionPolicy;
        if (retryConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pnReconnectionPolicy");
            retryConfiguration = null;
        }
        this.maxConnectionRetries = this.getMaxConnectionRetries(retryConfiguration);
        this.exponentialMultiplier = 1;
        this.failedCalls = 0;
        this.registerRetryTimer();
    }

    private final int getMaxConnectionRetries(RetryConfiguration retryConfiguration) {
        int n;
        RetryConfiguration retryConfiguration2 = retryConfiguration;
        if (retryConfiguration2 instanceof RetryConfiguration.None) {
            n = 0;
        } else if (retryConfiguration2 instanceof RetryConfiguration.Linear) {
            n = ((RetryConfiguration.Linear)retryConfiguration).getMaxRetryNumber();
        } else if (retryConfiguration2 instanceof RetryConfiguration.Exponential) {
            n = ((RetryConfiguration.Exponential)retryConfiguration).getMaxRetryNumber();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final void registerRetryTimer() {
        block2: {
            this.stopRetryTimer();
            if (this.isReconnectionPolicyUndefined()) {
                return;
            }
            if (this.failedCalls >= this.maxConnectionRetries) {
                this.getReconnectionCallback$pubnub_kotlin().onMaxReconnectionExhaustion();
                return;
            }
            Timer timer = this.timer = new Timer("Reconnection Manager timer", true);
            if (timer == null) break block2;
            timer.schedule(new TimerTask(this){
                final /* synthetic */ ReconnectionManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void run() {
                    ReconnectionManager.access$callTime(this.this$0);
                }
            }, this.getBestIntervalInMillis());
        }
    }

    private final int getBestIntervalInMillis() {
        RetryConfiguration retryConfiguration;
        int timerInterval = 0;
        RetryConfiguration retryConfiguration2 = this.pnReconnectionPolicy;
        if (retryConfiguration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pnReconnectionPolicy");
            retryConfiguration2 = null;
        }
        if ((retryConfiguration = retryConfiguration2) instanceof RetryConfiguration.Exponential) {
            timerInterval = (int)(Math.pow(2.0, this.exponentialMultiplier) - 1.0);
            if (timerInterval > 32) {
                timerInterval = 1;
                this.exponentialMultiplier = 1;
                this.log.info("timerInterval > MAXEXPONENTIALBACKOFF at: " + Calendar.getInstance().getTime());
            } else if (timerInterval < 1) {
                timerInterval = 1;
            }
            timerInterval = timerInterval * 1000 + this.getRandomDelayInMilliSeconds();
            this.log.info("timerInterval = " + timerInterval + "ms at: " + Calendar.getInstance().getTime());
        } else if (retryConfiguration instanceof RetryConfiguration.Linear) {
            timerInterval = 3000 + this.getRandomDelayInMilliSeconds();
        } else if (retryConfiguration instanceof RetryConfiguration.None) {
            timerInterval = 3000 + this.getRandomDelayInMilliSeconds();
        }
        return timerInterval;
    }

    private final int getRandomDelayInMilliSeconds() {
        return this.random.nextInt(1000);
    }

    private final void stopRetryTimer() {
        block0: {
            Timer timer = this.timer;
            if (timer == null) break block0;
            timer.cancel();
        }
    }

    private final void callTime() {
        new Time(this.pubnub, true).async((Function2)new Function2<PNTimeResult, PNStatus, Unit>(this){
            final /* synthetic */ ReconnectionManager this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@Nullable PNTimeResult pNTimeResult, @NotNull PNStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                if (!status.getError()) {
                    ReconnectionManager.access$stopRetryTimer(this.this$0);
                    this.this$0.getReconnectionCallback$pubnub_kotlin().onReconnection();
                } else {
                    ReconnectionManager.access$getLog$p(this.this$0).info("callTime at " + System.currentTimeMillis());
                    ReconnectionManager reconnectionManager = this.this$0;
                    int n = ReconnectionManager.access$getExponentialMultiplier$p(reconnectionManager);
                    ReconnectionManager.access$setExponentialMultiplier$p(reconnectionManager, n + 1);
                    reconnectionManager = this.this$0;
                    n = ReconnectionManager.access$getFailedCalls$p(reconnectionManager);
                    ReconnectionManager.access$setFailedCalls$p(reconnectionManager, n + 1);
                    ReconnectionManager.access$registerRetryTimer(this.this$0);
                }
            }
        });
    }

    private final boolean isReconnectionPolicyUndefined() {
        RetryConfiguration retryConfiguration = this.pnReconnectionPolicy;
        if (retryConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pnReconnectionPolicy");
            retryConfiguration = null;
        }
        if (Intrinsics.areEqual((Object)retryConfiguration, (Object)RetryConfiguration.None.INSTANCE)) {
            this.log.info("reconnection policy is disabled, please handle reconnection manually.");
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void access$callTime(ReconnectionManager $this) {
        $this.callTime();
    }

    public static final /* synthetic */ void access$stopRetryTimer(ReconnectionManager $this) {
        $this.stopRetryTimer();
    }

    public static final /* synthetic */ Logger access$getLog$p(ReconnectionManager $this) {
        return $this.log;
    }

    public static final /* synthetic */ int access$getExponentialMultiplier$p(ReconnectionManager $this) {
        return $this.exponentialMultiplier;
    }

    public static final /* synthetic */ void access$setExponentialMultiplier$p(ReconnectionManager $this, int n) {
        $this.exponentialMultiplier = n;
    }

    public static final /* synthetic */ int access$getFailedCalls$p(ReconnectionManager $this) {
        return $this.failedCalls;
    }

    public static final /* synthetic */ void access$setFailedCalls$p(ReconnectionManager $this, int n) {
        $this.failedCalls = n;
    }

    public static final /* synthetic */ void access$registerRetryTimer(ReconnectionManager $this) {
        $this.registerRetryTimer();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/pubnub/api/managers/ReconnectionManager$Companion;", "", "()V", "LINEAR_INTERVAL", "", "MAX_EXPONENTIAL_BACKOFF", "MAX_RANDOM_DELAY_IN_MILLIS", "MILLISECONDS", "MIN_EXPONENTIAL_BACKOFF", "NO_RETRIES", "pubnub-kotlin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

