/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.TelemetryManager;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J#\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00192\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001aJ'\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001fR6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lcom/pubnub/api/managers/TelemetryManager;", "", "()V", "latencies", "Ljava/util/HashMap;", "", "", "Lcom/pubnub/api/managers/TelemetryManager$Latency;", "Lkotlin/collections/HashMap;", "numberFormat", "Ljava/text/NumberFormat;", "kotlin.jvm.PlatformType", "getNumberFormat", "()Ljava/text/NumberFormat;", "numberFormat$delegate", "Lkotlin/Lazy;", "averageLatencyFromData", "", "endpointLatencies", "", "cleanUpTelemetryData", "", "currentDate", "", "operationsLatency", "", "operationsLatency$pubnub_kotlin", "storeLatency", "latency", "type", "Lcom/pubnub/api/enums/PNOperationType;", "storeLatency$pubnub_kotlin", "Companion", "Latency", "pubnub-kotlin"})
public final class TelemetryManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, List<Latency>> latencies = new HashMap();
    @NotNull
    private final Lazy numberFormat$delegate = LazyKt.lazy((Function0)numberFormat.2.INSTANCE);
    @Deprecated
    private static final int MAX_FRACTION_DIGITS = 3;
    @Deprecated
    private static final int TIMESTAMP_DIVIDER = 1000;
    @Deprecated
    private static final double MAXIMUM_LATENCY_DATA_AGE = 60.0;

    private final NumberFormat getNumberFormat() {
        Lazy lazy = this.numberFormat$delegate;
        return (NumberFormat)lazy.getValue();
    }

    @NotNull
    public final synchronized Map<String, String> operationsLatency$pubnub_kotlin(long currentDate) {
        this.cleanUpTelemetryData(currentDate);
        HashMap operationLatencies = new HashMap();
        Set<Map.Entry<String, List<Latency>>> set = this.latencies.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"latencies.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            String latencyKey = "l_" + (String)it.getKey();
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            double endpointAverageLatency = this.averageLatencyFromData((List)v);
            if (!(endpointAverageLatency > 0.0)) continue;
            Map map = operationLatencies;
            Intrinsics.checkNotNullExpressionValue((Object)this.getNumberFormat().format(endpointAverageLatency), (String)"numberFormat.format(endpointAverageLatency)");
            map.put(latencyKey, string);
        }
        return operationLatencies;
    }

    public static /* synthetic */ Map operationsLatency$pubnub_kotlin$default(TelemetryManager telemetryManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = new Date().getTime();
        }
        return telemetryManager.operationsLatency$pubnub_kotlin(l);
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void cleanUpTelemetryData(long currentDate) {
        Map.Entry element$iv2;
        double date = (double)currentDate / 1000.0;
        Map $this$forEach$iv = this.latencies;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv2 : $this$forEach$iv.entrySet()) {
            void $this$filterTo$iv$iv;
            Map.Entry entry = element$iv2;
            boolean bl = false;
            List operationLatencies = (List)entry.getValue();
            Iterable $this$filter$iv = operationLatencies;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Latency it = (Latency)element$iv$iv;
                boolean bl2 = false;
                if (!it.isOutdated(date)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List outdated = (List)destination$iv$iv;
            CollectionsKt.removeAll((Collection)operationLatencies, (Iterable)outdated);
        }
        Map $this$filterValues$iv = this.latencies;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        element$iv2 = $this$filterValues$iv.entrySet().iterator();
        while (element$iv2.hasNext()) {
            Map.Entry entry = (Map.Entry)element$iv2.next();
            List it = (List)entry.getValue();
            boolean bl = false;
            Collection collection = it;
            boolean bl2 = collection == null || collection.isEmpty();
            if (!bl2) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filterValues$iv = result$iv;
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv2 = iterator.next();
            boolean bl = false;
            String endpoint = (String)entry.getKey();
            ((Map)this.latencies).remove(endpoint);
        }
    }

    static /* synthetic */ void cleanUpTelemetryData$default(TelemetryManager telemetryManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = new Date().getTime();
        }
        telemetryManager.cleanUpTelemetryData(l);
    }

    /*
     * WARNING - void declaration
     */
    private final double averageLatencyFromData(List<Latency> endpointLatencies) {
        Iterable iterable = endpointLatencies;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            Latency latency = (Latency)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getLatency();
            d = d2 + d3;
        }
        double sumOfLatencies = d;
        return sumOfLatencies / (double)endpointLatencies.size();
    }

    public final synchronized void storeLatency$pubnub_kotlin(long latency, @NotNull PNOperationType type, long currentDate) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            String string = type.getQueryParam();
            if (string == null) break block3;
            String queryParam = string;
            boolean bl = false;
            if (latency > 0L) {
                double storeDate = (double)currentDate / 1000.0;
                if (this.latencies.get(queryParam) == null) {
                    ((Map)this.latencies).put(queryParam, new ArrayList());
                }
                List<Latency> list = this.latencies.get(queryParam);
                if (list != null) {
                    List<Latency> it = list;
                    boolean bl2 = false;
                    double d = (double)latency / (double)1000;
                    Latency latencyEntry = new Latency(d, storeDate);
                    it.add(latencyEntry);
                }
            }
        }
    }

    public static /* synthetic */ void storeLatency$pubnub_kotlin$default(TelemetryManager telemetryManager, long l, PNOperationType pNOperationType, long l2, int n, Object object) {
        if ((n & 4) != 0) {
            l2 = new Date().getTime();
        }
        telemetryManager.storeLatency$pubnub_kotlin(l, pNOperationType, l2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/pubnub/api/managers/TelemetryManager$Companion;", "", "()V", "MAXIMUM_LATENCY_DATA_AGE", "", "MAX_FRACTION_DIGITS", "", "TIMESTAMP_DIVIDER", "pubnub-kotlin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/pubnub/api/managers/TelemetryManager$Latency;", "", "latency", "", "date", "(DD)V", "getDate", "()D", "getLatency", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isOutdated", "currentDate", "toString", "", "pubnub-kotlin"})
    private static final class Latency {
        private final double latency;
        private final double date;

        public Latency(double latency, double date) {
            this.latency = latency;
            this.date = date;
        }

        public final double getLatency() {
            return this.latency;
        }

        public final double getDate() {
            return this.date;
        }

        public final boolean isOutdated(double currentDate) {
            return currentDate - this.date > 60.0;
        }

        public final double component1() {
            return this.latency;
        }

        public final double component2() {
            return this.date;
        }

        @NotNull
        public final Latency copy(double latency, double date) {
            return new Latency(latency, date);
        }

        public static /* synthetic */ Latency copy$default(Latency latency, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                d = latency.latency;
            }
            if ((n & 2) != 0) {
                d2 = latency.date;
            }
            return latency.copy(d, d2);
        }

        @NotNull
        public String toString() {
            return "Latency(latency=" + this.latency + ", date=" + this.date + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.latency);
            result = result * 31 + Double.hashCode(this.date);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Latency)) {
                return false;
            }
            Latency latency = (Latency)other;
            if (Double.compare(this.latency, latency.latency) != 0) {
                return false;
            }
            return Double.compare(this.date, latency.date) == 0;
        }
    }
}

