/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.presence.eventengine.effect;

import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.eventengine.ManagedEffect;
import com.pubnub.api.eventengine.Sink;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.server.SubscribeEnvelope;
import com.pubnub.api.presence.eventengine.event.PresenceEvent;
import com.pubnub.api.retry.RetryConfiguration;
import com.pubnub.api.retry.RetryableBase;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.extension.ScheduledExecutorServiceKt;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002BC\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/pubnub/api/presence/eventengine/effect/DelayedHeartbeatEffect;", "Lcom/pubnub/api/eventengine/ManagedEffect;", "Lcom/pubnub/api/retry/RetryableBase;", "Lcom/pubnub/api/models/server/SubscribeEnvelope;", "heartbeatRemoteAction", "Lcom/pubnub/api/endpoints/remoteaction/RemoteAction;", "", "presenceEventSink", "Lcom/pubnub/api/eventengine/Sink;", "Lcom/pubnub/api/presence/eventengine/event/PresenceEvent;", "retryConfiguration", "Lcom/pubnub/api/retry/RetryConfiguration;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "attempts", "", "reason", "Lcom/pubnub/api/PubNubException;", "(Lcom/pubnub/api/endpoints/remoteaction/RemoteAction;Lcom/pubnub/api/eventengine/Sink;Lcom/pubnub/api/retry/RetryConfiguration;Ljava/util/concurrent/ScheduledExecutorService;ILcom/pubnub/api/PubNubException;)V", "getAttempts", "()I", "cancelled", "getExecutorService", "()Ljava/util/concurrent/ScheduledExecutorService;", "getHeartbeatRemoteAction", "()Lcom/pubnub/api/endpoints/remoteaction/RemoteAction;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getPresenceEventSink", "()Lcom/pubnub/api/eventengine/Sink;", "getReason", "()Lcom/pubnub/api/PubNubException;", "getRetryConfiguration", "()Lcom/pubnub/api/retry/RetryConfiguration;", "scheduled", "Ljava/util/concurrent/ScheduledFuture;", "cancel", "", "runEffect", "pubnub-kotlin"})
public final class DelayedHeartbeatEffect
extends RetryableBase<SubscribeEnvelope>
implements ManagedEffect {
    @NotNull
    private final RemoteAction<Boolean> heartbeatRemoteAction;
    @NotNull
    private final Sink<PresenceEvent> presenceEventSink;
    @NotNull
    private final RetryConfiguration retryConfiguration;
    @NotNull
    private final ScheduledExecutorService executorService;
    private final int attempts;
    @Nullable
    private final PubNubException reason;
    private final Logger log;
    @Nullable
    private transient ScheduledFuture<?> scheduled;
    private transient boolean cancelled;

    public DelayedHeartbeatEffect(@NotNull RemoteAction<Boolean> heartbeatRemoteAction, @NotNull Sink<PresenceEvent> presenceEventSink, @NotNull RetryConfiguration retryConfiguration, @NotNull ScheduledExecutorService executorService, int attempts, @Nullable PubNubException reason) {
        Intrinsics.checkNotNullParameter(heartbeatRemoteAction, (String)"heartbeatRemoteAction");
        Intrinsics.checkNotNullParameter(presenceEventSink, (String)"presenceEventSink");
        Intrinsics.checkNotNullParameter((Object)retryConfiguration, (String)"retryConfiguration");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        super(retryConfiguration, RetryableEndpointGroup.PRESENCE);
        this.heartbeatRemoteAction = heartbeatRemoteAction;
        this.presenceEventSink = presenceEventSink;
        this.retryConfiguration = retryConfiguration;
        this.executorService = executorService;
        this.attempts = attempts;
        this.reason = reason;
        this.log = LoggerFactory.getLogger(DelayedHeartbeatEffect.class);
    }

    @NotNull
    public final RemoteAction<Boolean> getHeartbeatRemoteAction() {
        return this.heartbeatRemoteAction;
    }

    @NotNull
    public final Sink<PresenceEvent> getPresenceEventSink() {
        return this.presenceEventSink;
    }

    @NotNull
    public final RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    @NotNull
    public final ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public final int getAttempts() {
        return this.attempts;
    }

    @Nullable
    public final PubNubException getReason() {
        return this.reason;
    }

    @Override
    public synchronized void runEffect() {
        Serializable serializable;
        this.log.trace("Running DelayedHeartbeatEffect");
        if (this.cancelled) {
            return;
        }
        if (!this.shouldRetry(this.attempts)) {
            PubNubException pubNubException = this.reason;
            if (pubNubException == null) {
                pubNubException = new PubNubException("Unknown error", null, null, 0, null, null, 62, null);
            }
            this.presenceEventSink.add(new PresenceEvent.HeartbeatGiveup(pubNubException));
            return;
        }
        PubNubException pubNubException = this.reason;
        long effectiveDelay = this.getEffectiveDelay-3nIYWDw(pubNubException != null ? pubNubException.getStatusCode() : 0, (serializable = this.reason) != null && (serializable = ((PubNubException)serializable).getRetryAfterHeaderValue()) != null ? (Integer)serializable : 0);
        this.scheduled = ScheduledExecutorServiceKt.scheduleWithDelay-8Mi8wO0(this.executorService, effectiveDelay, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DelayedHeartbeatEffect this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getHeartbeatRemoteAction().async((Function2<Boolean, PNStatus, Unit>)((Function2)new Function2<Boolean, PNStatus, Unit>(this.this$0){
                    final /* synthetic */ DelayedHeartbeatEffect this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@Nullable Boolean bl, @NotNull PNStatus status) {
                        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                        if (status.getError()) {
                            Sink<PresenceEvent> sink = this.this$0.getPresenceEventSink();
                            PubNubException pubNubException = status.getException();
                            if (pubNubException == null) {
                                pubNubException = new PubNubException("Unknown error", null, null, 0, null, null, 62, null);
                            }
                            sink.add(new PresenceEvent.HeartbeatFailure(pubNubException));
                        } else {
                            this.this$0.getPresenceEventSink().add(PresenceEvent.HeartbeatSuccess.INSTANCE);
                        }
                    }
                }));
            }
        }));
    }

    @Override
    public synchronized void cancel() {
        block1: {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.heartbeatRemoteAction.silentCancel();
            ScheduledFuture<?> scheduledFuture = this.scheduled;
            if (scheduledFuture == null) break block1;
            scheduledFuture.cancel(true);
        }
    }
}

