/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.retry;

import com.pubnub.api.retry.RetryConfiguration;
import com.pubnub.api.retry.RetryableBase;
import com.pubnub.api.retry.RetryableEndpointGroup;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\f\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0014\u0010\u001c\u001a\u00020\u000b2\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fH\u0002J\u001e\u0010 \u001a\u00020!2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\"\u001a\u00020#H\u0016J\u001e\u0010$\u001a\u00020!2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\"\u001a\u00020#H&J$\u0010%\u001a\u00020!2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H&J$\u0010&\u001a\u00020!2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u001d\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u0017H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b)\u0010*J\b\u0010+\u001a\u00020!H\u0002J\u0016\u0010,\u001a\u00020!2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0002J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010.\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Lcom/pubnub/api/retry/RetryableCallback;", "T", "Lretrofit2/Callback;", "Lcom/pubnub/api/retry/RetryableBase;", "retryConfiguration", "Lcom/pubnub/api/retry/RetryConfiguration;", "endpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "call", "Lretrofit2/Call;", "isEndpointRetryable", "", "(Lcom/pubnub/api/retry/RetryConfiguration;Lcom/pubnub/api/retry/RetryableEndpointGroup;Lretrofit2/Call;Z)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "exponentialMultiplier", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "retryCount", "", "getDelayForRetryOnResponse", "Lkotlin/time/Duration;", "response", "Lretrofit2/Response;", "getDelayForRetryOnResponse-5sfh64U", "(Lretrofit2/Response;)J", "isExceptionRetryable", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onFailure", "", "t", "", "onFinalFailure", "onFinalResponse", "onResponse", "retry", "delay", "retry-LRDsOJo", "(J)V", "retryOnFailure", "retryOnResponseWithError", "shouldRetryOnFailure", "shouldRetryOnResponse", "pubnub-kotlin"})
public abstract class RetryableCallback<T>
extends RetryableBase<T>
implements Callback<T> {
    @NotNull
    private final Call<T> call;
    private final boolean isEndpointRetryable;
    private final Logger log;
    private int retryCount;
    private double exponentialMultiplier;
    @NotNull
    private final ExecutorService executorService;

    public RetryableCallback(@NotNull RetryConfiguration retryConfiguration, @NotNull RetryableEndpointGroup endpointGroupName, @NotNull Call<T> call, boolean isEndpointRetryable) {
        Intrinsics.checkNotNullParameter((Object)retryConfiguration, (String)"retryConfiguration");
        Intrinsics.checkNotNullParameter((Object)((Object)endpointGroupName), (String)"endpointGroupName");
        Intrinsics.checkNotNullParameter(call, (String)"call");
        super(retryConfiguration, endpointGroupName);
        this.call = call;
        this.isEndpointRetryable = isEndpointRetryable;
        this.log = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.executorService = executorService;
    }

    public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Intrinsics.checkNotNullParameter(response, (String)"response");
        if (this.shouldRetryOnResponse(response)) {
            this.retryOnResponseWithError(response);
        } else {
            this.executorService.shutdown();
            this.onFinalResponse(call, response);
        }
    }

    public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (this.shouldRetryOnFailure(t)) {
            this.retryOnFailure();
        } else {
            this.executorService.shutdown();
            this.onFinalFailure(call, t);
        }
    }

    private final boolean shouldRetryOnResponse(Response<T> response) {
        return !response.isSuccessful() && this.retryCount < this.getMaxRetryNumberFromConfiguration() && this.isErrorCodeRetryable(response.raw().code()) && this.isRetryConfSetForThisRestCall$pubnub_kotlin() && this.isEndpointRetryable;
    }

    private final boolean shouldRetryOnFailure(Throwable t) {
        Exception exception = new Exception(t);
        return this.retryCount < this.getMaxRetryNumberFromConfiguration() && this.isExceptionRetryable(exception) && this.isRetryConfSetForThisRestCall$pubnub_kotlin() && this.isEndpointRetryable;
    }

    private final boolean isExceptionRetryable(Exception e) {
        boolean bl;
        block5: {
            Throwable throwable = e.getCause();
            if (throwable != null) {
                Throwable cause = throwable;
                boolean bl2 = false;
                Iterable $this$any$iv = RetryableBase.Companion.getRetryableExceptions$pubnub_kotlin();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Class it = (Class)element$iv;
                        boolean bl3 = false;
                        if (!it.isInstance(cause)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void retryOnFailure() {
        long effectiveDelay = this.getDelayFromRetryConfiguration-UwyO8pc$pubnub_kotlin();
        this.retry-LRDsOJo(effectiveDelay);
    }

    private final void retryOnResponseWithError(Response<T> response) {
        long effectiveDelay = this.getDelayForRetryOnResponse-5sfh64U(response);
        this.retry-LRDsOJo(effectiveDelay);
    }

    private final void retry-LRDsOJo(long delay) {
        int n = this.retryCount;
        this.retryCount = n + 1;
        int randomDelayInMillis = this.getRandom().nextInt(1000);
        long effectiveDelayInMillis = Duration.getInWholeMilliseconds-impl((long)delay) + (long)randomDelayInMillis;
        this.log.trace("Added random delay so effective retry delay is " + effectiveDelayInMillis);
        this.executorService.execute(() -> RetryableCallback.retry_LRDsOJo$lambda$2(effectiveDelayInMillis, this));
    }

    private final long getDelayForRetryOnResponse-5sfh64U(Response<T> response) {
        return this.getDelayBasedOnResponse-5sfh64U$pubnub_kotlin(response);
    }

    public abstract void onFinalResponse(@NotNull Call<T> var1, @NotNull Response<T> var2);

    public abstract void onFinalFailure(@NotNull Call<T> var1, @NotNull Throwable var2);

    private static final void retry_LRDsOJo$lambda$2(long $effectiveDelayInMillis, RetryableCallback this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            Thread.sleep($effectiveDelayInMillis);
            this$0.call.clone().enqueue((Callback)this$0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

