/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.retry;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubRetryableException;
import com.pubnub.api.retry.RetryConfiguration;
import com.pubnub.api.retry.RetryableBase;
import com.pubnub.api.retry.RetryableEndpointGroup;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0000\u00a2\u0006\u0002\b\u0016J\"\u0010\u0017\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0014\u0012\f\u0012\n\u0018\u00010\u0019j\u0004\u0018\u0001`\u001a0\u0018H\u0002J\u0014\u0010\u001b\u001a\u00020\b2\n\u0010\u001c\u001a\u00060\u0019j\u0002`\u001aH\u0002J\u0016\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0002R \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/pubnub/api/retry/RetryableRestCaller;", "T", "Lcom/pubnub/api/retry/RetryableBase;", "retryConfiguration", "Lcom/pubnub/api/retry/RetryConfiguration;", "endpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isEndpointRetryable", "", "(Lcom/pubnub/api/retry/RetryConfiguration;Lcom/pubnub/api/retry/RetryableEndpointGroup;Z)V", "call", "Lretrofit2/Call;", "getCall$pubnub_kotlin", "()Lretrofit2/Call;", "setCall$pubnub_kotlin", "(Lretrofit2/Call;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "execute", "Lretrofit2/Response;", "callToBeExecuted", "execute$pubnub_kotlin", "executeRestCall", "Lkotlin/Pair;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isExceptionRetryable", "e", "shouldRetry", "response", "pubnub-kotlin"})
public final class RetryableRestCaller<T>
extends RetryableBase<T> {
    private final boolean isEndpointRetryable;
    private final Logger log;
    public Call<T> call;

    public RetryableRestCaller(@NotNull RetryConfiguration retryConfiguration, @NotNull RetryableEndpointGroup endpointGroupName, boolean isEndpointRetryable) {
        Intrinsics.checkNotNullParameter((Object)retryConfiguration, (String)"retryConfiguration");
        Intrinsics.checkNotNullParameter((Object)((Object)endpointGroupName), (String)"endpointGroupName");
        super(retryConfiguration, endpointGroupName);
        this.isEndpointRetryable = isEndpointRetryable;
        this.log = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    }

    @NotNull
    public final Call<T> getCall$pubnub_kotlin() {
        Call<T> call = this.call;
        if (call != null) {
            return call;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"call");
        return null;
    }

    public final void setCall$pubnub_kotlin(@NotNull Call<T> call) {
        Intrinsics.checkNotNullParameter(call, (String)"<set-?>");
        this.call = call;
    }

    @NotNull
    public final Response<T> execute$pubnub_kotlin(@NotNull Call<T> callToBeExecuted) {
        Intrinsics.checkNotNullParameter(callToBeExecuted, (String)"callToBeExecuted");
        this.setCall$pubnub_kotlin(callToBeExecuted);
        int numberOfAttempts = 0;
        while (true) {
            Pair<Response<T>, Exception> pair = this.executeRestCall();
            Response response = (Response)pair.component1();
            Exception exception = (Exception)pair.component2();
            if (!this.shouldRetry(response) || numberOfAttempts++ >= this.getMaxRetryNumberFromConfiguration()) {
                if (response.isSuccessful() || exception == null) {
                    return response;
                }
                throw exception;
            }
            int randomDelayInMillis = this.getRandom().nextInt(1000);
            long effectiveDelayInMillis = Duration.getInWholeMilliseconds-impl((long)this.getDelayBasedOnResponse-5sfh64U$pubnub_kotlin(response)) + (long)randomDelayInMillis;
            this.log.trace("Added random delay so effective retry delay is " + effectiveDelayInMillis);
            Thread.sleep(effectiveDelayInMillis);
            Call call = this.getCall$pubnub_kotlin().clone();
            Intrinsics.checkNotNullExpressionValue((Object)call, (String)"call.clone()");
            this.setCall$pubnub_kotlin(call);
        }
    }

    private final Pair<Response<T>, Exception> executeRestCall() {
        Exception pubNubException = null;
        try {
            Response response;
            try {
                response = this.getCall$pubnub_kotlin().execute();
                response = new Pair((Object)response, pubNubException);
            }
            catch (Exception e) {
                PubNubError pubNubError = PubNubError.PARSING_ERROR;
                String string = e.toString();
                Call<T> call = this.getCall$pubnub_kotlin();
                pubNubException = new PubNubException(string, pubNubError, null, 0, call, null, 44, null);
                if (this.isExceptionRetryable(e)) {
                    pubNubError = PubNubError.CONNECT_EXCEPTION;
                    string = e.toString();
                    throw new PubNubRetryableException(string, pubNubError, 503);
                }
                throw pubNubException;
            }
            return response;
        }
        catch (PubNubRetryableException e) {
            int n = e.getStatusCode();
            String string = e.getErrorMessage();
            if (string == null || (string = ResponseBody.Companion.create$default((ResponseBody.Companion)ResponseBody.Companion, (String)string, null, (int)1, null)) == null) {
                string = ResponseBody.Companion.create$default((ResponseBody.Companion)ResponseBody.Companion, (String)"", null, (int)1, null);
            }
            return new Pair((Object)Response.error((int)n, (ResponseBody)string), pubNubException);
        }
    }

    private final boolean isExceptionRetryable(Exception e) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = RetryableBase.Companion.getRetryableExceptions$pubnub_kotlin();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Class it = (Class)element$iv;
                    boolean bl2 = false;
                    if (!it.isInstance(e)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean shouldRetry(Response<T> response) {
        return !response.isSuccessful() && this.isErrorCodeRetryable(response.raw().code()) && this.isRetryConfSetForThisRestCall$pubnub_kotlin() && this.isEndpointRetryable;
    }
}

