/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.subscribe.eventengine.effect;

import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.RemoteAction;
import com.pubnub.api.eventengine.ManagedEffect;
import com.pubnub.api.eventengine.Sink;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.server.SubscribeEnvelope;
import com.pubnub.api.retry.RetryConfiguration;
import com.pubnub.api.retry.RetryableBase;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.subscribe.eventengine.effect.ReceiveMessagesResult;
import com.pubnub.api.subscribe.eventengine.event.SubscribeEvent;
import com.pubnub.extension.ScheduledExecutorServiceKt;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002BC\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/pubnub/api/subscribe/eventengine/effect/ReceiveReconnectEffect;", "Lcom/pubnub/api/eventengine/ManagedEffect;", "Lcom/pubnub/api/retry/RetryableBase;", "Lcom/pubnub/api/models/server/SubscribeEnvelope;", "receiveMessagesRemoteAction", "Lcom/pubnub/api/endpoints/remoteaction/RemoteAction;", "Lcom/pubnub/api/subscribe/eventengine/effect/ReceiveMessagesResult;", "subscribeEventSink", "Lcom/pubnub/api/eventengine/Sink;", "Lcom/pubnub/api/subscribe/eventengine/event/SubscribeEvent;", "retryConfiguration", "Lcom/pubnub/api/retry/RetryConfiguration;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "attempts", "", "reason", "Lcom/pubnub/api/PubNubException;", "(Lcom/pubnub/api/endpoints/remoteaction/RemoteAction;Lcom/pubnub/api/eventengine/Sink;Lcom/pubnub/api/retry/RetryConfiguration;Ljava/util/concurrent/ScheduledExecutorService;ILcom/pubnub/api/PubNubException;)V", "cancelled", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scheduled", "Ljava/util/concurrent/ScheduledFuture;", "cancel", "", "runEffect", "pubnub-kotlin"})
public final class ReceiveReconnectEffect
extends RetryableBase<SubscribeEnvelope>
implements ManagedEffect {
    @NotNull
    private final RemoteAction<ReceiveMessagesResult> receiveMessagesRemoteAction;
    @NotNull
    private final Sink<SubscribeEvent> subscribeEventSink;
    @NotNull
    private final ScheduledExecutorService executorService;
    private final int attempts;
    @Nullable
    private final PubNubException reason;
    private final Logger log;
    @Nullable
    private transient ScheduledFuture<?> scheduled;
    private transient boolean cancelled;

    public ReceiveReconnectEffect(@NotNull RemoteAction<ReceiveMessagesResult> receiveMessagesRemoteAction, @NotNull Sink<SubscribeEvent> subscribeEventSink, @NotNull RetryConfiguration retryConfiguration, @NotNull ScheduledExecutorService executorService, int attempts, @Nullable PubNubException reason) {
        Intrinsics.checkNotNullParameter(receiveMessagesRemoteAction, (String)"receiveMessagesRemoteAction");
        Intrinsics.checkNotNullParameter(subscribeEventSink, (String)"subscribeEventSink");
        Intrinsics.checkNotNullParameter((Object)retryConfiguration, (String)"retryConfiguration");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        super(retryConfiguration, RetryableEndpointGroup.SUBSCRIBE);
        this.receiveMessagesRemoteAction = receiveMessagesRemoteAction;
        this.subscribeEventSink = subscribeEventSink;
        this.executorService = executorService;
        this.attempts = attempts;
        this.reason = reason;
        this.log = LoggerFactory.getLogger(ReceiveReconnectEffect.class);
    }

    @Override
    public synchronized void runEffect() {
        Serializable serializable;
        this.log.trace("Running ReceiveReconnectEffect");
        if (this.cancelled) {
            return;
        }
        if (!this.shouldRetry(this.attempts)) {
            PubNubException pubNubException = this.reason;
            if (pubNubException == null) {
                pubNubException = new PubNubException("Unknown error", null, null, 0, null, null, 62, null);
            }
            this.subscribeEventSink.add(new SubscribeEvent.ReceiveReconnectGiveup(pubNubException));
            return;
        }
        PubNubException pubNubException = this.reason;
        long effectiveDelay = this.getEffectiveDelay-3nIYWDw(pubNubException != null ? pubNubException.getStatusCode() : 0, (serializable = this.reason) != null && (serializable = ((PubNubException)serializable).getRetryAfterHeaderValue()) != null ? (Integer)serializable : 0);
        this.scheduled = ScheduledExecutorServiceKt.scheduleWithDelay-8Mi8wO0(this.executorService, effectiveDelay, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ReceiveReconnectEffect this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ReceiveReconnectEffect.access$getReceiveMessagesRemoteAction$p(this.this$0).async((Function2)new Function2<ReceiveMessagesResult, PNStatus, Unit>(this.this$0){
                    final /* synthetic */ ReceiveReconnectEffect this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@Nullable ReceiveMessagesResult result, @NotNull PNStatus status) {
                        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                        if (status.getError()) {
                            Sink sink = ReceiveReconnectEffect.access$getSubscribeEventSink$p(this.this$0);
                            PubNubException pubNubException = status.getException();
                            if (pubNubException == null) {
                                pubNubException = new PubNubException("Unknown error", null, null, 0, null, null, 62, null);
                            }
                            sink.add(new SubscribeEvent.ReceiveReconnectFailure(pubNubException));
                        } else {
                            Sink sink = ReceiveReconnectEffect.access$getSubscribeEventSink$p(this.this$0);
                            ReceiveMessagesResult receiveMessagesResult = result;
                            Intrinsics.checkNotNull((Object)receiveMessagesResult);
                            sink.add(new SubscribeEvent.ReceiveReconnectSuccess(receiveMessagesResult.getMessages(), result.getSubscriptionCursor()));
                        }
                    }
                });
            }
        }));
    }

    @Override
    public synchronized void cancel() {
        block1: {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.receiveMessagesRemoteAction.silentCancel();
            ScheduledFuture<?> scheduledFuture = this.scheduled;
            if (scheduledFuture == null) break block1;
            scheduledFuture.cancel(true);
        }
    }

    public static final /* synthetic */ RemoteAction access$getReceiveMessagesRemoteAction$p(ReceiveReconnectEffect $this) {
        return $this.receiveMessagesRemoteAction;
    }

    public static final /* synthetic */ Sink access$getSubscribeEventSink$p(ReceiveReconnectEffect $this) {
        return $this.subscribeEventSink;
    }
}

