/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.api.resumableio;

import com.qiniu.api.resumableio.SliceUpload;
import com.qiniu.api.resumableio.UploadBlock;
import com.qiniu.api.resumableio.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.Lock;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.AbstractHttpEntity;

public class RandomAccessFileUploadBlock
extends UploadBlock {
    protected RandomAccessFile file;
    private final Lock fileUploadLock;

    RandomAccessFileUploadBlock(SliceUpload sliceUpload, HttpClient httpClient, String host, int blockIdx, long offset, int len, RandomAccessFile file, Lock fileUploadLock) {
        super(sliceUpload, httpClient, host, blockIdx, offset, len);
        this.file = file;
        this.fileUploadLock = fileUploadLock;
    }

    @Override
    protected HttpEntity buildHttpEntity(final int start, final int len) {
        AbstractHttpEntity entity = new AbstractHttpEntity(){
            private boolean consumed = false;
            private long length = len;

            public boolean isRepeatable() {
                return true;
            }

            public long getContentLength() {
                return this.length;
            }

            public InputStream getContent() throws IOException, IllegalStateException {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(OutputStream os) throws IOException {
                this.consumed = false;
                try {
                    byte[] b = new byte[4096];
                    int len2 = -1;
                    long off = RandomAccessFileUploadBlock.this.offset + (long)start;
                    RandomAccessFileUploadBlock.this.fileUploadLock.lock();
                    RandomAccessFileUploadBlock.this.file.seek(off);
                    while ((len2 = RandomAccessFileUploadBlock.this.file.read(b)) != -1) {
                        os.write(b, 0, len2);
                        off += (long)len2;
                    }
                    os.flush();
                }
                finally {
                    RandomAccessFileUploadBlock.this.fileUploadLock.unlock();
                    this.consumed = true;
                }
            }

            public boolean isStreaming() {
                return !this.consumed;
            }
        };
        entity.setContentType("application/octet-stream");
        return entity;
    }

    @Override
    protected long buildCrc32(int start, int len) {
        return Util.crc32(this.copy2New(start, len));
    }

    private byte[] copy2New(int start, int len) {
        byte[] data = new byte[len];
        try {
            long off = this.offset + (long)start;
            this.fileUploadLock.lock();
            this.file.seek(off);
            this.file.read(data);
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.fileUploadLock.unlock();
        }
    }

    @Override
    protected void clean() {
    }
}

