/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.api.resumableio;

import com.qiniu.api.resumableio.SliceUpload;
import com.qiniu.api.resumableio.StreamUploadBlock;
import com.qiniu.api.resumableio.UploadBlock;
import java.io.IOException;
import java.io.InputStream;

public class StreamSliceUpload
extends SliceUpload {
    protected InputStream is;
    private int currentBlockIdx = 0;

    public StreamSliceUpload(InputStream is, String token, String key, String mimeType) {
        this(is, token, key, mimeType, -1L);
    }

    public StreamSliceUpload(InputStream is, String token, String key, String mimeType, long totalLength) {
        super(token, key, mimeType);
        this.contentLength = totalLength;
        this.is = is;
    }

    @Override
    protected boolean hasNext() {
        try {
            return this.is != null && (this.is.available() > 0 || (long)(this.currentBlockIdx * 0x400000) < this.contentLength);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected UploadBlock buildNextBlockUpload() throws IOException {
        long left = this.is.available();
        left = left > 0L ? left : this.contentLength - (long)(this.currentBlockIdx * 0x400000);
        long start = this.currentBlockIdx * 0x400000;
        int len = (int)Math.min(0x400000L, left);
        ByteRef br = new ByteRef();
        byte[] b = new byte[len];
        this.is.read(b, 0, len);
        br.setBuf(b);
        StreamUploadBlock bu = new StreamUploadBlock(this, this.httpClient, this.host, this.currentBlockIdx, start, len, br);
        ++this.currentBlockIdx;
        return bu;
    }

    protected UploadBlock buildBlockUpload(int blockIdx, long start, int len) throws IOException {
        ByteRef br = new ByteRef();
        byte[] b = new byte[len];
        this.is.read(b, 0, len);
        br.setBuf(b);
        StreamUploadBlock bu = new StreamUploadBlock(this, this.httpClient, this.host, blockIdx, start, len, br);
        return bu;
    }

    @Override
    protected void clean() throws Exception {
        if (this.is != null) {
            this.is.close();
        }
    }

    protected class ByteRef {
        private byte[] buf;

        protected ByteRef() {
        }

        public byte[] getBuf() {
            return this.buf;
        }

        protected void setBuf(byte[] buf) {
            this.buf = buf;
        }

        public void clean() {
            this.buf = null;
        }

        public boolean isEmpty() {
            return this.buf == null;
        }
    }
}

