/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.common.Region;
import com.qiniu.common.RegionReqInfo;
import com.qiniu.http.Dns;
import com.qiniu.http.ProxyConfiguration;

public final class Configuration
implements Cloneable {
    public Region region;
    public boolean useHttpsDomains = true;
    public boolean useAccUpHost = true;
    public long putThreshold = 0x400000L;
    public int connectTimeout = 10;
    public int writeTimeout = 0;
    public int readTimeout = 30;
    public int dispatcherMaxRequests = 64;
    public int dispatcherMaxRequestsPerHost = 16;
    public int connectionPoolMaxIdleCount = 32;
    public int connectionPoolMaxIdleMinutes = 5;
    public int retryMax = 5;
    public Dns dns;
    public boolean useDnsHostFirst;
    public ProxyConfiguration proxy;
    public static String defaultRsHost = "rs.qiniu.com";
    public static String defaultApiHost = "api.qiniu.com";
    public static String defaultUcHost = "uc.qbox.me";

    public Configuration() {
    }

    public Configuration(Region region) {
        this.region = region;
    }

    public Configuration clone() {
        try {
            return (Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String upHost(String upToken) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(upToken);
        if (this.region == null) {
            this.region = Region.autoRegion();
        }
        return this.useAccUpHost ? this.getScheme() + this.region.getAccUpHost(regionReqInfo) : this.getScheme() + this.region.getSrcUpHost(regionReqInfo);
    }

    public String upHostBackup(String upToken) throws QiniuException {
        RegionReqInfo regionReqInfo = new RegionReqInfo(upToken);
        if (this.region == null) {
            this.region = Region.autoRegion();
        }
        return this.useAccUpHost ? this.getScheme() + this.region.getAccUpHostBackup(regionReqInfo) : this.getScheme() + this.region.getSrcUpHostBackup(regionReqInfo);
    }

    public String ioHost(String ak, String bucket) {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        if (this.region == null) {
            this.region = Region.autoRegion();
        }
        return this.getScheme() + this.region.getIovipHost(regionReqInfo);
    }

    public String apiHost(String ak, String bucket) {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        if (this.region == null) {
            this.region = Region.autoRegion();
        }
        return this.getScheme() + this.region.getApiHost(regionReqInfo);
    }

    public String rsHost(String ak, String bucket) {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        if (this.region == null) {
            this.region = Region.autoRegion();
        }
        return this.getScheme() + this.region.getRsHost(regionReqInfo);
    }

    public String rsfHost(String ak, String bucket) {
        RegionReqInfo regionReqInfo = new RegionReqInfo(ak, bucket);
        if (this.region == null) {
            this.region = Region.autoRegion();
        }
        return this.getScheme() + this.region.getRsfHost(regionReqInfo);
    }

    public String rsHost() {
        return this.getScheme() + defaultRsHost;
    }

    public String apiHost() {
        return this.getScheme() + defaultApiHost;
    }

    public String ucHost() {
        return this.getScheme() + defaultUcHost;
    }

    String getScheme() {
        return this.useHttpsDomains ? "https://" : "http://";
    }
}

