/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.spatial;

import com.querydsl.sql.types.AbstractType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;
import org.jetbrains.annotations.Nullable;
import org.postgis.PGgeometry;

class PGgeometryType
extends AbstractType<Geometry> {
    public static final PGgeometryType DEFAULT = new PGgeometryType();

    PGgeometryType() {
        super(2002);
    }

    public Class<Geometry> getReturnedClass() {
        return Geometry.class;
    }

    @Nullable
    public Geometry getValue(ResultSet rs, int startIndex) throws SQLException {
        PGgeometry obj = (PGgeometry)rs.getObject(startIndex);
        if (obj == null) {
            return null;
        }
        return Wkt.newDecoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).decode(obj.getValue());
    }

    public void setValue(PreparedStatement st, int startIndex, Geometry value) throws SQLException {
        String encode = Wkt.newEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).encode(value);
        PGgeometry geometry = new PGgeometry(encode);
        st.setObject(startIndex, geometry);
    }

    public String getLiteral(Geometry geometry) {
        return "'" + Wkt.newEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).encode(geometry) + "'";
    }
}

