/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.rabbitmq.http.client.RestTemplateConfigurator;
import com.rabbitmq.http.client.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.util.Assert;

public class ClientParameters {
    private URL url;
    private String username;
    private String password;
    private RestTemplateConfigurator restTemplateConfigurator;

    public ClientParameters url(URL url) {
        this.url = url;
        return this;
    }

    public ClientParameters url(String url) throws MalformedURLException {
        this.url = new URL(url);
        if (this.url.getUserInfo() != null) {
            this.url = new URL(Utils.urlWithoutCredentials(url));
            String[] usernamePassword = Utils.extractUsernamePassword(url);
            this.username = usernamePassword[0];
            this.password = usernamePassword[1];
        }
        return this;
    }

    public ClientParameters username(String username) {
        this.username = username;
        return this;
    }

    public ClientParameters password(String password) {
        this.password = password;
        return this;
    }

    public ClientParameters restTemplateConfigurator(RestTemplateConfigurator restTemplateConfigurator) {
        this.restTemplateConfigurator = restTemplateConfigurator;
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public RestTemplateConfigurator getRestTemplateConfigurator() {
        return this.restTemplateConfigurator;
    }

    void validate() {
        Assert.notNull((Object)this.url, (String)"URL is required; it must not be null");
        Assert.notNull((Object)this.username, (String)"username is required; it must not be null");
        Assert.notNull((Object)this.password, (String)"password is required; it must not be null");
    }
}

