/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.rabbitmq.http.client.GetAckMode;
import com.rabbitmq.http.client.GetEncoding;
import com.rabbitmq.http.client.domain.OutboundMessage;
import com.rabbitmq.http.client.domain.VhostLimits;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

class Utils {
    private static final Charset CHARSET_UTF8;
    public static final JsonDeserializer<VhostLimits> VHOST_LIMITS_JSON_DESERIALIZER;
    private static final int RADIX = 16;
    private static final BitSet UNRESERVED;
    private static final BitSet PUNCT;
    private static final BitSet USERINFO;
    private static final BitSet PATHSAFE;
    private static final BitSet URIC;
    private static final BitSet RESERVED;
    private static final BitSet URLENCODER;

    Utils() {
    }

    static Map<String, Object> bodyForPublish(String routingKey, OutboundMessage outboundMessage) {
        if (routingKey == null) {
            throw new IllegalArgumentException("routing key cannot be null");
        }
        if (outboundMessage == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        if (outboundMessage.getPayload() == null) {
            throw new IllegalArgumentException("message payload cannot be null");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("routing_key", routingKey);
        body.put("properties", outboundMessage.getProperties() == null ? Collections.EMPTY_MAP : outboundMessage.getProperties());
        body.put("payload", outboundMessage.getPayload());
        body.put("payload_encoding", outboundMessage.getPayloadEncoding());
        return body;
    }

    static Map<String, Object> bodyForGet(int count, GetAckMode ackMode, GetEncoding encoding, int truncate) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be greater than 0");
        }
        if (ackMode == null) {
            throw new IllegalArgumentException("acknowledgment mode cannot be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding cannot be null");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("count", count);
        body.put("ackmode", ackMode.ackMode);
        body.put("encoding", encoding.encoding);
        if (truncate >= 0) {
            body.put("truncate", truncate);
        }
        return body;
    }

    static String[] extractUsernamePassword(String url) {
        String userInfo = null;
        try {
            userInfo = new URL(url).getUserInfo();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL", e);
        }
        if (userInfo == null) {
            throw new IllegalArgumentException("Could not extract password from URL. URL should be like 'https://guest:guest@localhost:15672/api/'");
        }
        String[] usernamePassword = userInfo.split(":");
        if (usernamePassword == null || usernamePassword.length != 2) {
            throw new IllegalArgumentException("Could not extract password from URL. URL should be like 'https://guest:guest@localhost:15672/api/'");
        }
        return new String[]{Utils.decode(usernamePassword[0]), Utils.decode(usernamePassword[1])};
    }

    static String decode(String potentiallyEncodedString) {
        if (potentiallyEncodedString != null && !potentiallyEncodedString.isEmpty()) {
            try {
                return URLDecoder.decode(potentiallyEncodedString, CHARSET_UTF8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Error while decoding string", e);
            }
        }
        return potentiallyEncodedString;
    }

    static String urlWithoutCredentials(String url) {
        URL url1 = null;
        try {
            url1 = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL is malformed");
        }
        return StringUtils.replace((String)url, (String)(url1.getUserInfo() + "@"), (String)"");
    }

    static String encodePath(String content, Charset charset) {
        StringBuilder buf = new StringBuilder();
        ByteBuffer bb = charset.encode(content);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (PATHSAFE.get(b)) {
                buf.append((char)b);
                continue;
            }
            buf.append("%");
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buf.append(hex1);
            buf.append(hex2);
        }
        return buf.toString();
    }

    static String encode(String content) {
        return Utils.encodePath(content, CHARSET_UTF8);
    }

    static {
        int i;
        CHARSET_UTF8 = Charset.forName("UTF-8");
        VHOST_LIMITS_JSON_DESERIALIZER = new VhostLimitsDeserializer();
        UNRESERVED = new BitSet(256);
        PUNCT = new BitSet(256);
        USERINFO = new BitSet(256);
        PATHSAFE = new BitSet(256);
        URIC = new BitSet(256);
        RESERVED = new BitSet(256);
        URLENCODER = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            UNRESERVED.set(i);
        }
        UNRESERVED.set(95);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(42);
        URLENCODER.or(UNRESERVED);
        UNRESERVED.set(33);
        UNRESERVED.set(126);
        UNRESERVED.set(39);
        UNRESERVED.set(40);
        UNRESERVED.set(41);
        PUNCT.set(44);
        PUNCT.set(59);
        PUNCT.set(58);
        PUNCT.set(36);
        PUNCT.set(38);
        PUNCT.set(43);
        PUNCT.set(61);
        USERINFO.or(UNRESERVED);
        USERINFO.or(PUNCT);
        PATHSAFE.or(UNRESERVED);
        PATHSAFE.set(59);
        PATHSAFE.set(58);
        PATHSAFE.set(64);
        PATHSAFE.set(38);
        PATHSAFE.set(61);
        PATHSAFE.set(43);
        PATHSAFE.set(36);
        PATHSAFE.set(44);
        RESERVED.set(59);
        RESERVED.set(47);
        RESERVED.set(63);
        RESERVED.set(58);
        RESERVED.set(64);
        RESERVED.set(38);
        RESERVED.set(61);
        RESERVED.set(43);
        RESERVED.set(36);
        RESERVED.set(44);
        RESERVED.set(91);
        RESERVED.set(93);
        URIC.or(RESERVED);
        URIC.or(UNRESERVED);
    }

    private static class VhostLimitsDeserializer
    extends StdDeserializer<VhostLimits> {
        private static final long serialVersionUID = -1881403692606830843L;
        public static final String VHOST_FIELD = "vhost";
        public static final String VALUE_FIELD = "value";
        public static final String MAX_QUEUES_FIELD = "max-queues";
        public static final String MAX_CONNECTIONS_FIELD = "max-connections";

        private VhostLimitsDeserializer() {
            super(VhostLimits.class);
        }

        public VhostLimits deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (node.isArray()) {
                if (node.isEmpty()) {
                    return new VhostLimits(null, -1, -1);
                }
                node = node.get(0);
            }
            JsonNode value = node.get(VALUE_FIELD);
            return new VhostLimits(this.getVhost(node), this.getLimit(value, MAX_QUEUES_FIELD), this.getLimit(value, MAX_CONNECTIONS_FIELD));
        }

        private String getVhost(JsonNode node) {
            return node.get(VHOST_FIELD).asText();
        }

        private int getLimit(JsonNode value, String name) {
            JsonNode limit = value.get(name);
            if (limit == null) {
                return -1;
            }
            return limit.asInt(-1);
        }
    }
}

