/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.GetResponse;
import com.rabbitmq.jms.client.RMQMessageConsumer;
import com.rabbitmq.jms.util.TimeTracker;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DelayedReceiver {
    private final Logger logger = LoggerFactory.getLogger(DelayedReceiver.class);
    private static final TimeTracker POLLING_INTERVAL = new TimeTracker(100L, TimeUnit.MILLISECONDS);
    private final int batchingSize;
    private final RMQMessageConsumer rmqMessageConsumer;
    private final Object responseLock = new Object();
    private boolean aborted = false;

    public DelayedReceiver(int batchingSize, RMQMessageConsumer rmqMessageConsumer) {
        this.batchingSize = batchingSize;
        this.rmqMessageConsumer = rmqMessageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResponse get(TimeTracker tt) {
        try {
            Object object = this.responseLock;
            synchronized (object) {
                GetResponse resp = this.rmqMessageConsumer.getFromRabbitQueue();
                if (resp != null) {
                    return resp;
                }
                while (!this.aborted && !tt.timedOut() && (resp = this.rmqMessageConsumer.getFromRabbitQueue()) == null) {
                    new TimeTracker(POLLING_INTERVAL).timedWait(this.responseLock);
                }
                return resp;
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Get interrupted while buffer.poll-ing.", (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort() {
        Object object = this.responseLock;
        synchronized (object) {
            this.aborted = true;
            this.responseLock.notifyAll();
        }
    }

    public void close() {
        this.abort();
    }
}

