/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MessageFormatException;

abstract class Utils {
    static final Predicate<String> SUBSCRIPTION_NAME_PREDICATE = name -> {
        if (name == null) {
            return true;
        }
        if (name.length() > 128) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_' || c == '.' || c == '-' || Character.isLetter(c) || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    };

    private Utils() {
    }

    static JMSRuntimeException wrap(JMSException e) {
        return Utils.wrap(e.getMessage(), e);
    }

    static JMSRuntimeException wrap(String message, JMSException e) {
        return new JMSRuntimeException(message, e.getErrorCode(), (Throwable)e);
    }

    static <T> T wrap(JmsExceptionCallable<T> operation) {
        try {
            return operation.call();
        }
        catch (JMSException e) {
            throw Utils.wrap(e);
        }
    }

    static void wrap(JmsExceptionRunnable operation) {
        try {
            operation.run();
        }
        catch (JMSException e) {
            throw Utils.wrap(e);
        }
    }

    static boolean getBooleanProperty(Map<String, Serializable> properties, String name) throws JMSException {
        Serializable o = properties.get(name);
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)((Object)o));
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new MessageFormatException(String.format("Unable to convert from class [%s]", o.getClass().getName()));
    }

    static byte getByteProperty(Map<String, Serializable> properties, String name) throws JMSException {
        Serializable o = properties.get(name);
        if (o == null) {
            throw new NumberFormatException("Null is not a valid byte");
        }
        if (o instanceof String) {
            return Byte.parseByte((String)((Object)o));
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        throw new MessageFormatException(String.format("Unable to convert from class [%s]", o.getClass().getName()));
    }

    static short getShortProperty(Map<String, Serializable> properties, String name) throws JMSException {
        Serializable o = properties.get(name);
        if (o == null) {
            throw new NumberFormatException("Null is not a valid short");
        }
        if (o instanceof String) {
            return Short.parseShort((String)((Object)o));
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        throw new MessageFormatException(String.format("Unable to convert from class [%s]", o.getClass().getName()));
    }

    static int getIntProperty(Map<String, Serializable> properties, String name) throws JMSException {
        Serializable o = properties.get(name);
        if (o == null) {
            throw new NumberFormatException("Null is not a valid int");
        }
        if (o instanceof String) {
            return Integer.parseInt((String)((Object)o));
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new MessageFormatException(String.format("Unable to convert from class [%s]", o.getClass().getName()));
    }

    static long getLongProperty(Map<String, Serializable> properties, String name) throws JMSException {
        Serializable o = properties.get(name);
        return Utils.convertToLong(o);
    }

    static long convertToLong(Object o) throws JMSException {
        if (o == null) {
            throw new NumberFormatException("Null is not a valid long");
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new MessageFormatException(String.format("Unable to convert from class [%s]", o.getClass().getName()));
    }

    static float getFloatProperty(Map<String, Serializable> properties, String name) throws JMSException {
        Serializable o = properties.get(name);
        if (o == null) {
            throw new NumberFormatException("Null is not a valid float");
        }
        if (o instanceof String) {
            return Float.parseFloat((String)((Object)o));
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        throw new MessageFormatException(String.format("Unable to convert from class [%s]", o.getClass().getName()));
    }

    static double getDoubleProperty(Map<String, Serializable> properties, String name) throws JMSException {
        Serializable o = properties.get(name);
        if (o == null) {
            throw new NumberFormatException("Null is not a valid double");
        }
        if (o instanceof String) {
            return Double.parseDouble((String)((Object)o));
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        throw new MessageFormatException(String.format("Unable to convert from class [%s]", o.getClass().getName()));
    }

    static String getStringProperty(Map<String, Serializable> properties, String name) {
        Serializable o = properties.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)((Object)o);
        }
        return o.toString();
    }

    static interface JmsExceptionRunnable {
        public void run() throws JMSException;
    }

    static interface JmsExceptionCallable<T> {
        public T call() throws JMSException;
    }
}

