/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.convert;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.stereotype.Component;

@Component
@WritingConverter
public class LocalDateToBytesConverter
implements Converter<LocalDate, byte[]> {
    byte[] fromString(String source) {
        return source.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] convert(LocalDate source) {
        Instant instant = source.atStartOfDay(ZoneId.systemDefault()).toInstant();
        long unixTime = instant.getEpochSecond();
        return this.fromString(Long.toString(unixTime));
    }
}

