/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.redis.om.spring.RediSearchIndexer;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.jedis.JedisValues;
import com.redis.om.spring.util.ObjectUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.domain.Example;
import org.springframework.data.geo.Point;
import redis.clients.jedis.search.Schema;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.QueryNode;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class ExampleToNodeConverter<E> {
    private final RediSearchIndexer indexer;
    private static final Pattern SCHEMA_FIELD_NAME_PATTERN = Pattern.compile("Field\\{name='(.*?)'");

    public ExampleToNodeConverter(RediSearchIndexer indexer) {
        this.indexer = indexer;
    }

    private static Optional<String> getAliasForSchemaField(Schema.Field schemaField) {
        String name;
        int aliasStart;
        Optional<String> alias = Optional.empty();
        Matcher matcher = SCHEMA_FIELD_NAME_PATTERN.matcher(schemaField.toString());
        if (matcher.find() && (aliasStart = (name = matcher.group(1)).indexOf("AS")) != -1) {
            alias = Optional.of(name.substring(aliasStart + 3));
        }
        return alias;
    }

    public Node processExample(Example<E> example, Node rootNode) {
        Class entityClass = example.getProbeType();
        Schema schema = this.indexer.getSchemaFor(entityClass);
        boolean matchingAll = example.getMatcher().isAllMatching();
        Set toIgnore = example.getMatcher().getIgnoredPaths();
        if (schema != null) {
            block12: for (Schema.Field schemaField : schema.fields) {
                Object value;
                Optional<String> maybeAlias = ExampleToNodeConverter.getAliasForSchemaField(schemaField);
                String fieldName = maybeAlias.orElseGet(() -> schemaField.name.replace("$.", ""));
                if (toIgnore.contains(fieldName) || (value = ObjectUtils.getValueByPath(example.getProbe(), schemaField.name)) == null) continue;
                Class<?> cls = value.getClass();
                block0 : switch (schemaField.type) {
                    case TAG: {
                        if (Iterable.class.isAssignableFrom(value.getClass())) {
                            Iterable values = (Iterable)value;
                            if (!(values = (Iterable)StreamSupport.stream(values.spliterator(), false).filter(Objects::nonNull).collect(Collectors.toList())).iterator().hasNext()) continue block12;
                            QueryNode and = QueryBuilders.intersect((Node[])new Node[0]);
                            for (Object v : values) {
                                if (v.toString().isBlank()) continue;
                                and.add(fieldName, new String[]{"{" + v + "}"});
                            }
                            if (matchingAll) {
                                rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode, and});
                                break;
                            }
                            rootNode = QueryBuilders.union((Node[])new Node[]{rootNode, and});
                            break;
                        }
                        if (matchingAll) {
                            rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{"{" + value + "}"});
                            break;
                        }
                        rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new String[]{"{" + value + "}"});
                        break;
                    }
                    case TEXT: {
                        switch (example.getMatcher().getDefaultStringMatcher()) {
                            case DEFAULT: 
                            case EXACT: {
                                rootNode = org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)value) ? QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{QueryUtils.escape(value.toString(), false)}) : rootNode;
                                break block0;
                            }
                            case STARTING: {
                                rootNode = org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)value) ? QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{QueryUtils.escape(value.toString(), false) + "*"}) : rootNode;
                                break block0;
                            }
                            case ENDING: {
                                rootNode = org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)value) ? QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{"*" + QueryUtils.escape(value.toString(), false)}) : rootNode;
                                break block0;
                            }
                            case CONTAINING: {
                                rootNode = org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)value) ? QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{"*" + QueryUtils.escape(value.toString(), false) + "*"}) : rootNode;
                                break block0;
                            }
                        }
                        break;
                    }
                    case GEO: {
                        if (cls == Point.class) {
                            Point point = (Point)value;
                            double x = point.getX();
                            double y = point.getY();
                            if (matchingAll) {
                                rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{String.format("[%s %s 0.0001 mi]", x, y)});
                                break;
                            }
                            rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new String[]{String.format("[%s %s 0.0001 mi]", x, y)});
                            break;
                        }
                        if (!CharSequence.class.isAssignableFrom(cls)) continue block12;
                        String[] coordinates = value.toString().split(",");
                        double x = Double.parseDouble(coordinates[0]);
                        double y = Double.parseDouble(coordinates[1]);
                        if (matchingAll) {
                            rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new String[]{String.format("[%s %s 0.0001 mi]", x, y)});
                            break;
                        }
                        rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new String[]{String.format("[%s %s 0.0001 mi]", x, y)});
                        break;
                    }
                    case NUMERIC: {
                        if (Iterable.class.isAssignableFrom(value.getClass())) {
                            Iterable values = (Iterable)value;
                            if (!(values = (Iterable)StreamSupport.stream(values.spliterator(), false).filter(Objects::nonNull).collect(Collectors.toList())).iterator().hasNext()) continue block12;
                            Class<?> elementClass = values.iterator().next().getClass();
                            QueryNode and = QueryBuilders.intersect((Node[])new Node[0]);
                            for (Object v : values) {
                                if (matchingAll) {
                                    if (elementClass == LocalDate.class) {
                                        and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDate)v)})});
                                        continue;
                                    }
                                    if (elementClass == Date.class) {
                                        and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Date)v)})});
                                        continue;
                                    }
                                    if (elementClass == LocalDateTime.class) {
                                        and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDateTime)v)})});
                                        continue;
                                    }
                                    if (elementClass == Instant.class) {
                                        and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Instant)v)})});
                                        continue;
                                    }
                                    if (elementClass == Integer.class) {
                                        and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((int)Integer.parseInt(v.toString()))})});
                                        continue;
                                    }
                                    if (elementClass == Long.class) {
                                        and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Long.parseLong(v.toString()))})});
                                        continue;
                                    }
                                    if (elementClass != Double.class) continue;
                                    and.add(new Node[]{QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Double.parseDouble(v.toString()))})});
                                    continue;
                                }
                                if (elementClass == LocalDate.class) {
                                    and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDate)v)})});
                                    continue;
                                }
                                if (elementClass == Date.class) {
                                    and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Date)v)})});
                                    continue;
                                }
                                if (elementClass == LocalDateTime.class) {
                                    and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDateTime)v)})});
                                    continue;
                                }
                                if (elementClass == Instant.class) {
                                    and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Instant)v)})});
                                    continue;
                                }
                                if (elementClass == Integer.class) {
                                    and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((int)Integer.parseInt(v.toString()))})});
                                    continue;
                                }
                                if (elementClass == Long.class) {
                                    and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Long.parseLong(v.toString()))})});
                                    continue;
                                }
                                if (elementClass != Double.class) continue;
                                and.add(new Node[]{QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Double.parseDouble(v.toString()))})});
                            }
                            if (matchingAll) {
                                rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode, and});
                                break;
                            }
                            rootNode = QueryBuilders.union((Node[])new Node[]{rootNode, and});
                            break;
                        }
                        if (matchingAll) {
                            if (cls == LocalDate.class) {
                                rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDate)value)});
                                break;
                            }
                            if (cls == Date.class) {
                                rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Date)value)});
                                break;
                            }
                            if (cls == LocalDateTime.class) {
                                rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDateTime)value)});
                                break;
                            }
                            if (cls == Instant.class) {
                                rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Instant)value)});
                                break;
                            }
                            if (cls == Integer.class) {
                                rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((int)Integer.parseInt(value.toString()))});
                                break;
                            }
                            if (cls == Long.class) {
                                rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Long.parseLong(value.toString()))});
                                break;
                            }
                            if (cls != Double.class) break;
                            rootNode = QueryBuilders.intersect((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Double.parseDouble(value.toString()))});
                            break;
                        }
                        if (cls == LocalDate.class) {
                            rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDate)value)});
                            break;
                        }
                        if (cls == Date.class) {
                            rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Date)value)});
                            break;
                        }
                        if (cls == LocalDateTime.class) {
                            rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((LocalDateTime)value)});
                            break;
                        }
                        if (cls == Instant.class) {
                            rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{JedisValues.eq((Instant)value)});
                            break;
                        }
                        if (cls == Integer.class) {
                            rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((int)Integer.parseInt(value.toString()))});
                            break;
                        }
                        if (cls == Long.class) {
                            rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Long.parseLong(value.toString()))});
                            break;
                        }
                        if (cls != Double.class) break;
                        rootNode = QueryBuilders.union((Node[])new Node[]{rootNode}).add(fieldName, new Value[]{Values.eq((double)Double.parseDouble(value.toString()))});
                        break;
                    }
                }
            }
        }
        return rootNode;
    }
}

