/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.geo;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.geo.Point;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class NotEqualPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private T value;
    private Double x;
    private Double y;

    public NotEqualPredicate(SearchFieldAccessor field, T value) {
        super(field);
        this.value = value;
        if (value.getClass() == Point.class) {
            Point point = (Point)value;
            this.x = point.getX();
            this.y = point.getY();
        }
    }

    public NotEqualPredicate(SearchFieldAccessor field, String xy) {
        super(field);
        String[] coordinates = xy.split(",");
        this.x = Double.parseDouble(coordinates[0]);
        this.y = Double.parseDouble(coordinates[1]);
    }

    public NotEqualPredicate(SearchFieldAccessor field, Double x, Double y) {
        super(field);
        this.x = x;
        this.y = y;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        boolean paramsPresent = ObjectUtils.isNotEmpty((Object)this.x) && ObjectUtils.isNotEmpty((Object)this.y);
        return paramsPresent ? QueryBuilders.intersect((Node[])new Node[]{root}).add(new Node[]{QueryBuilders.disjunct((String)this.getSearchAlias(), (Value[])new Value[]{Values.value((String)String.format("[%s %s 0.0001 mi]", this.x, this.y))})}) : root;
    }
}

