/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.tag;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import org.apache.commons.lang3.ObjectUtils;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.QueryNode;

public class EqualPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final T value;

    public EqualPredicate(SearchFieldAccessor field, T value) {
        super(field);
        this.value = QueryUtils.escape(value);
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        if (ObjectUtils.isEmpty(this.getValue())) {
            return root;
        }
        if (Iterable.class.isAssignableFrom(this.getValue().getClass())) {
            Iterable values = (Iterable)this.getValue();
            QueryNode and = QueryBuilders.intersect((Node[])new Node[0]);
            for (Object v : values) {
                and.add(this.getSearchAlias(), new String[]{"{" + v.toString() + "}"});
            }
            return QueryBuilders.intersect((Node[])new Node[]{root, and});
        }
        return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new String[]{"{" + this.value.toString() + "}"});
    }
}

