/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.geo.Metrics;

@ConfigurationProperties(prefix="redis.om.spring", ignoreInvalidFields=true)
public class RedisOMProperties {
    public static final String ROMS_VERSION = "0.9.7";
    public static final int MAX_SEARCH_RESULTS = 10000;
    public static final double DEFAULT_DISTANCE = 5.0E-4;
    public static final Metrics DEFAULT_DISTANCE_METRIC = Metrics.MILES;
    private final Repository repository = new Repository();
    private final References references = new References();
    private final Djl djl = new Djl();
    private final OpenAi openAi = new OpenAi();
    private final AzureOpenAi azureOpenAi = new AzureOpenAi();
    private final VertexAi vertexAi = new VertexAi();
    private final BedrockCohere bedrockCohere = new BedrockCohere();
    private final BedrockTitan bedrockTitan = new BedrockTitan();
    private final Ollama ollama = new Ollama();

    public Repository getRepository() {
        return this.repository;
    }

    public References getReferences() {
        return this.references;
    }

    public Djl getDjl() {
        return this.djl;
    }

    public OpenAi getOpenAi() {
        return this.openAi;
    }

    public AzureOpenAi getAzureOpenAi() {
        return this.azureOpenAi;
    }

    public VertexAi getVertexAi() {
        return this.vertexAi;
    }

    public BedrockCohere getBedrockCohere() {
        return this.bedrockCohere;
    }

    public BedrockTitan getBedrockTitan() {
        return this.bedrockTitan;
    }

    public Ollama getOllama() {
        return this.ollama;
    }

    public static class Repository {
        private final Query query = new Query();
        private boolean dropAndRecreateIndexOnDeleteAll = false;
        private int deleteBatchSize = 500;

        public Query getQuery() {
            return this.query;
        }

        public boolean isDropAndRecreateIndexOnDeleteAll() {
            return this.dropAndRecreateIndexOnDeleteAll;
        }

        public void setDropAndRecreateIndexOnDeleteAll(boolean dropAndRecreateIndexOnDeleteAll) {
            this.dropAndRecreateIndexOnDeleteAll = dropAndRecreateIndexOnDeleteAll;
        }

        public int getDeleteBatchSize() {
            return this.deleteBatchSize;
        }

        public void setDeleteBatchSize(int deleteBatchSize) {
            this.deleteBatchSize = deleteBatchSize;
        }

        public static class Query {
            private int limit = 10000;
            private double defaultDistance = 5.0E-4;
            private Metrics defaultDistanceMetric = DEFAULT_DISTANCE_METRIC;

            public int getLimit() {
                return this.limit;
            }

            public void setLimit(int limit) {
                this.limit = limit;
            }

            public double getDefaultDistance() {
                return this.defaultDistance;
            }

            public void setDefaultDistance(double defaultDistance) {
                this.defaultDistance = defaultDistance;
            }

            public Metrics getDefaultDistanceMetrics() {
                return this.defaultDistanceMetric;
            }

            public void setDefaultDistanceMetric(Metrics defaultDistanceMetric) {
                this.defaultDistanceMetric = defaultDistanceMetric;
            }
        }
    }

    public static class References {
        private String cacheName = "roms-reference-cache";
        private List<String> cachedReferenceClasses = new ArrayList<String>();

        public String getCacheName() {
            return this.cacheName;
        }

        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }

        public List<String> getCachedReferenceClasses() {
            return this.cachedReferenceClasses;
        }

        public void setCachedReferenceClasses(List<String> cachedReferenceClasses) {
            this.cachedReferenceClasses = cachedReferenceClasses;
        }
    }

    public static class Djl {
        private static final String DEFAULT_ENGINE = "PyTorch";
        private boolean enabled = false;
        @NotNull
        private String imageEmbeddingModelEngine = "PyTorch";
        @NotNull
        private String imageEmbeddingModelModelUrls = "djl://ai.djl.pytorch/resnet18_embedding";
        private int defaultImagePipelineResizeWidth = 224;
        private int defaultImagePipelineResizeHeight = 224;
        private boolean defaultImagePipelineCenterCrop = true;
        @NotNull
        private String sentenceTokenizerMaxLength = "768";
        @NotNull
        private String sentenceTokenizerModelMaxLength = "768";
        @NotNull
        private String sentenceTokenizerModel = "sentence-transformers/all-mpnet-base-v2";
        @NotNull
        private String faceDetectionModelEngine = "PyTorch";
        @NotNull
        private String faceDetectionModelName = "retinaface";
        @NotNull
        private String faceDetectionModelModelUrls = "https://resources.djl.ai/test-models/pytorch/retinaface.zip";
        @NotNull
        private String faceEmbeddingModelEngine = "PyTorch";
        @NotNull
        private String faceEmbeddingModelName = "face_feature";
        @NotNull
        private String faceEmbeddingModelModelUrls = "https://resources.djl.ai/test-models/pytorch/face_feature.zip";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @NotNull
        public String getImageEmbeddingModelEngine() {
            return this.imageEmbeddingModelEngine;
        }

        public void setImageEmbeddingModelEngine(@NotNull String imageEmbeddingModelEngine) {
            this.imageEmbeddingModelEngine = imageEmbeddingModelEngine;
        }

        @NotNull
        public String getImageEmbeddingModelModelUrls() {
            return this.imageEmbeddingModelModelUrls;
        }

        public void setImageEmbeddingModelModelUrls(@NotNull String imageEmbeddingModelModelUrls) {
            this.imageEmbeddingModelModelUrls = imageEmbeddingModelModelUrls;
        }

        public int getDefaultImagePipelineResizeWidth() {
            return this.defaultImagePipelineResizeWidth;
        }

        public void setDefaultImagePipelineResizeWidth(int defaultImagePipelineResizeWidth) {
            this.defaultImagePipelineResizeWidth = defaultImagePipelineResizeWidth;
        }

        public int getDefaultImagePipelineResizeHeight() {
            return this.defaultImagePipelineResizeHeight;
        }

        public void setDefaultImagePipelineResizeHeight(int defaultImagePipelineResizeHeight) {
            this.defaultImagePipelineResizeHeight = defaultImagePipelineResizeHeight;
        }

        public boolean isDefaultImagePipelineCenterCrop() {
            return this.defaultImagePipelineCenterCrop;
        }

        public void setDefaultImagePipelineCenterCrop(boolean defaultImagePipelineCenterCrop) {
            this.defaultImagePipelineCenterCrop = defaultImagePipelineCenterCrop;
        }

        @NotNull
        public String getSentenceTokenizerMaxLength() {
            return this.sentenceTokenizerMaxLength;
        }

        public void setSentenceTokenizerMaxLength(@NotNull String sentenceTokenizerMaxLength) {
            this.sentenceTokenizerMaxLength = sentenceTokenizerMaxLength;
        }

        @NotNull
        public String getSentenceTokenizerModelMaxLength() {
            return this.sentenceTokenizerModelMaxLength;
        }

        public void setSentenceTokenizerModelMaxLength(@NotNull String sentenceTokenizerModelMaxLength) {
            this.sentenceTokenizerModelMaxLength = sentenceTokenizerModelMaxLength;
        }

        @NotNull
        public String getSentenceTokenizerModel() {
            return this.sentenceTokenizerModel;
        }

        public void setSentenceTokenizerModel(@NotNull String sentenceTokenizerModel) {
            this.sentenceTokenizerModel = sentenceTokenizerModel;
        }

        @NotNull
        public String getFaceDetectionModelEngine() {
            return this.faceDetectionModelEngine;
        }

        public void setFaceDetectionModelEngine(@NotNull String faceDetectionModelEngine) {
            this.faceDetectionModelEngine = faceDetectionModelEngine;
        }

        @NotNull
        public String getFaceDetectionModelName() {
            return this.faceDetectionModelName;
        }

        public void setFaceDetectionModelName(@NotNull String faceDetectionModelName) {
            this.faceDetectionModelName = faceDetectionModelName;
        }

        @NotNull
        public String getFaceDetectionModelModelUrls() {
            return this.faceDetectionModelModelUrls;
        }

        public void setFaceDetectionModelModelUrls(@NotNull String faceDetectionModelModelUrls) {
            this.faceDetectionModelModelUrls = faceDetectionModelModelUrls;
        }

        @NotNull
        public String getFaceEmbeddingModelEngine() {
            return this.faceEmbeddingModelEngine;
        }

        public void setFaceEmbeddingModelEngine(@NotNull String faceEmbeddingModelEngine) {
            this.faceEmbeddingModelEngine = faceEmbeddingModelEngine;
        }

        @NotNull
        public String getFaceEmbeddingModelName() {
            return this.faceEmbeddingModelName;
        }

        public void setFaceEmbeddingModelName(@NotNull String faceEmbeddingModelName) {
            this.faceEmbeddingModelName = faceEmbeddingModelName;
        }

        @NotNull
        public String getFaceEmbeddingModelModelUrls() {
            return this.faceEmbeddingModelModelUrls;
        }

        public void setFaceEmbeddingModelModelUrls(@NotNull String faceEmbeddingModelModelUrls) {
            this.faceEmbeddingModelModelUrls = faceEmbeddingModelModelUrls;
        }

        public String toString() {
            return "RedisOMSpringProperties.Djl(enabled=" + this.isEnabled() + ", imageEmbeddingModelEngine=" + this.getImageEmbeddingModelEngine() + ", imageEmbeddingModelModelUrls=" + this.getImageEmbeddingModelModelUrls() + ", defaultImagePipelineResizeWidth=" + this.getDefaultImagePipelineResizeWidth() + ", defaultImagePipelineResizeHeight=" + this.getDefaultImagePipelineResizeHeight() + ", defaultImagePipelineCenterCrop=" + this.isDefaultImagePipelineCenterCrop() + ", sentenceTokenizerMaxLength=" + this.getSentenceTokenizerMaxLength() + ", sentenceTokenizerModelMaxLength=" + this.getSentenceTokenizerModelMaxLength() + ", sentenceTokenizerModel=" + this.getSentenceTokenizerModel() + ", faceDetectionModelEngine=" + this.getFaceDetectionModelEngine() + ", faceDetectionModelName=" + this.getFaceDetectionModelName() + ", faceDetectionModelModelUrls=" + this.getFaceDetectionModelModelUrls() + ", faceEmbeddingModelEngine=" + this.getFaceEmbeddingModelEngine() + ", faceEmbeddingModelName=" + this.getFaceEmbeddingModelName() + ", faceEmbeddingModelModelUrls=" + this.getFaceEmbeddingModelModelUrls() + ")";
        }
    }

    public static class OpenAi {
        private String apiKey;
        private String model = OpenAiApi.EmbeddingModel.TEXT_EMBEDDING_ADA_002.getValue();

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }
    }

    public static class AzureOpenAi {
        private String apiKey;
        private String endPoint;
        private String model;

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getEndPoint() {
            return this.endPoint;
        }

        public void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }
    }

    public static class VertexAi {
        private String apiKey;
        private String endPoint;
        private String model;

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getEndPoint() {
            return this.endPoint;
        }

        public void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }
    }

    public static class BedrockCohere {
        private String region;
        private String accessKey;
        private String secretKey;
        private String model;

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }
    }

    public static class BedrockTitan {
        private String region;
        private String accessKey;
        private String secretKey;
        private String model;

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }
    }

    public static class Ollama {
        private String baseUrl = "http://localhost:11434";

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }
    }
}

