/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.annotations;

import com.redis.om.spring.annotations.EmbeddingProvider;
import com.redis.om.spring.annotations.EmbeddingType;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.ai.bedrock.cohere.api.CohereEmbeddingBedrockApi;
import org.springframework.ai.bedrock.titan.api.TitanEmbeddingBedrockApi;
import org.springframework.ai.ollama.api.OllamaModel;
import org.springframework.ai.openai.api.OpenAiApi;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.ANNOTATION_TYPE})
public @interface Vectorize {
    public String destination();

    public EmbeddingType embeddingType() default EmbeddingType.SENTENCE;

    public EmbeddingProvider provider() default EmbeddingProvider.DJL;

    public OpenAiApi.EmbeddingModel openAiEmbeddingModel() default OpenAiApi.EmbeddingModel.TEXT_EMBEDDING_ADA_002;

    public OllamaModel ollamaEmbeddingModel() default OllamaModel.MISTRAL;

    public String azureOpenAiDeploymentName() default "text-embedding-ada-002";

    public String vertexAiPaLm2ApiModel() default "embedding-gecko-001";

    public CohereEmbeddingBedrockApi.CohereEmbeddingModel cohereEmbeddingModel() default CohereEmbeddingBedrockApi.CohereEmbeddingModel.COHERE_EMBED_MULTILINGUAL_V1;

    public TitanEmbeddingBedrockApi.TitanEmbeddingModel titanEmbeddingModel() default TitanEmbeddingBedrockApi.TitanEmbeddingModel.TITAN_EMBED_IMAGE_V1;
}

