/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.metamodel;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.aggregations.filters.AggregationFilter;
import com.redis.om.spring.search.stream.aggregations.filters.ExistsFilter;
import com.redis.om.spring.search.stream.aggregations.filters.NotExistsFilter;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.function.Function;
import org.springframework.data.domain.Sort;

public class MetamodelField<E, T>
implements Comparator<E>,
Function<E, T> {
    protected SearchFieldAccessor searchFieldAccessor;
    protected boolean indexed;
    protected String alias;
    protected Class<?> targetClass;

    public MetamodelField(SearchFieldAccessor searchFieldAccessor, boolean indexed) {
        this.searchFieldAccessor = searchFieldAccessor;
        this.indexed = indexed;
        this.alias = null;
    }

    public MetamodelField(String alias, Class<?> targetClass, boolean indexed) {
        this.searchFieldAccessor = null;
        this.indexed = indexed;
        this.alias = alias;
        this.targetClass = targetClass;
    }

    public MetamodelField(String alias, Class<?> targetClass) {
        this.searchFieldAccessor = null;
        this.indexed = false;
        this.alias = alias;
        this.targetClass = targetClass;
    }

    public MetamodelField(Class<E> targetClass, String fieldName) {
        SearchFieldAccessor sfa;
        Field field;
        try {
            field = ObjectUtils.getDeclaredFieldTransitively(targetClass, fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        this.searchFieldAccessor = sfa = new SearchFieldAccessor(fieldName, "$." + fieldName, field);
        this.indexed = true;
        this.alias = fieldName;
    }

    public SearchFieldAccessor getSearchFieldAccessor() {
        return this.searchFieldAccessor;
    }

    @Override
    public int compare(E o1, E o2) {
        return 0;
    }

    @Override
    public T apply(E t) {
        return null;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public String getSearchAlias() {
        return this.searchFieldAccessor != null ? this.searchFieldAccessor.getSearchAlias() : this.alias;
    }

    public Class<?> getTargetClass() {
        return this.searchFieldAccessor != null ? this.searchFieldAccessor.getTargetClass() : this.targetClass;
    }

    public String getJSONPath() {
        return this.searchFieldAccessor != null ? this.searchFieldAccessor.getJsonPath() : "";
    }

    public Sort.Order asc() {
        return Sort.Order.asc((String)("@" + this.getSearchAlias()));
    }

    public Sort.Order desc() {
        return Sort.Order.desc((String)("@" + this.getSearchAlias()));
    }

    public AggregationFilter exists() {
        return new ExistsFilter(this.getSearchAlias());
    }

    public AggregationFilter notExists() {
        return new NotExistsFilter(this.getSearchAlias());
    }
}

