/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.query.clause;

import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.repository.query.clause.QueryClauseTemplate;
import com.redis.om.spring.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.repository.query.parser.Part;
import redis.clients.jedis.search.Schema;

public enum QueryClause {
    TEXT_ALL(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.SIMPLE_PROPERTY, "$param_0", 1)),
    TEXT_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.SIMPLE_PROPERTY, "@$field:$param_0", 1)),
    TEXT_NEGATING_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.SIMPLE_PROPERTY, "-@$field:$param_0", 1)),
    TEXT_STARTING_WITH(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.STARTING_WITH, "@$field:$param_0*", 1)),
    TEXT_ENDING_WITH(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.ENDING_WITH, "@$field:*$param_0", 1)),
    TEXT_LIKE(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.LIKE, "@$field:%%%$param_0%%%", 1)),
    TEXT_NOT_LIKE(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.NOT_LIKE, "-@$field:%%%$param_0%%%", 1)),
    TEXT_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.CONTAINING, "@$field:%%%$param_0%%%", 1)),
    TEXT_NOT_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.NOT_CONTAINING, "-@$field:%%%$param_0%%%", 1)),
    TEXT_NOT_IN(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.NOT_IN, "@$field:$param_0", 1)),
    TEXT_IN(QueryClauseTemplate.of(Schema.FieldType.TEXT, Part.Type.IN, "@$field:$param_0", 1)),
    NUMERIC_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.SIMPLE_PROPERTY, "@$field:[$param_0 $param_0]", 1)),
    NUMERIC_NEGATING_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.SIMPLE_PROPERTY, "@$field:-[$param_0 $param_0]", 1)),
    NUMERIC_BETWEEN(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.BETWEEN, "@$field:[$param_0 $param_1]", 2)),
    NUMERIC_LESS_THAN(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.LESS_THAN, "@$field:[-inf ($param_0]", 1)),
    NUMERIC_LESS_THAN_EQUAL(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.LESS_THAN_EQUAL, "@$field:[-inf $param_0]", 1)),
    NUMERIC_GREATER_THAN(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.GREATER_THAN, "@$field:[($param_0 inf]", 1)),
    NUMERIC_GREATER_THAN_EQUAL(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.GREATER_THAN_EQUAL, "@$field:[$param_0 inf]", 1)),
    NUMERIC_BEFORE(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.BEFORE, "@$field:[-inf ($param_0]", 1)),
    NUMERIC_AFTER(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.AFTER, "@$field:[($param_0 inf]", 1)),
    NUMERIC_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.CONTAINING, "$param_0", 1)),
    NUMERIC_CONTAINING_ALL(QueryClauseTemplate.of(Schema.FieldType.NUMERIC, Part.Type.CONTAINING, "$param_0", 1)),
    GEO_NEAR(QueryClauseTemplate.of(Schema.FieldType.GEO, Part.Type.NEAR, "@$field:[$param_0 $param_1 $param_2]", 2)),
    GEO_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.GEO, Part.Type.CONTAINING, "$param_0", 1)),
    GEO_CONTAINING_ALL(QueryClauseTemplate.of(Schema.FieldType.GEO, Part.Type.CONTAINING, "$param_0", 1)),
    TAG_SIMPLE_PROPERTY(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.SIMPLE_PROPERTY, "@$field:{$param_0}", 1)),
    TAG_NOT_IN(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.NOT_IN, "@$field:{$param_0}", 1)),
    TAG_IN(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.IN, "@$field:{$param_0}", 1)),
    TAG_CONTAINING(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.CONTAINING, "@$field:$param_0", 1)),
    TAG_CONTAINING_ALL(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.CONTAINING, "$param_0", 1)),
    TAG_STARTING_WITH(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.STARTING_WITH, "@$field:{$param_0*}", 1)),
    TAG_ENDING_WITH(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.ENDING_WITH, "@$field:{*$param_0}", 1)),
    IS_NULL(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.IS_NULL, "!exists(@$field)", 0)),
    IS_NOT_NULL(QueryClauseTemplate.of(Schema.FieldType.TAG, Part.Type.IS_NOT_NULL, "exists(@$field)", 0));

    public static final Map<String, String> methodNameMap;
    public static final Pattern CONTAINING_ALL_PATTERN;
    private static final String PARAM_PREFIX = "$param_";
    private static final String FIRST_PARAM = "$param_0";
    private static final String FIELD_EQUAL = "@$field:$param_0";
    private static final String FIELD_NON_EQUAL_PARAM_0 = "-@$field:$param_0";
    private static final String FIELD_TAG_EQUAL = "@$field:{$param_0}";
    private static final String FIELD_LIKE = "@$field:%%%$param_0%%%";
    private static final String FIELD_NOT_LIKE = "-@$field:%%%$param_0%%%";
    private static final String FIELD_NUMERIC_EQUAL_PARAM_0 = "@$field:[$param_0 $param_0]";
    private static final String FIELD_TEXT_STARTING_WITH = "@$field:$param_0*";
    private static final String FIELD_TAG_STARTING_WITH = "@$field:{$param_0*}";
    private static final String FIELD_TEXT_ENDING_WITH = "@$field:*$param_0";
    private static final String FIELD_TAG_ENDING_WITH = "@$field:{*$param_0}";
    private static final String FIELD_NUMERIC_NOT_EQUAL = "@$field:-[$param_0 $param_0]";
    private static final String FIELD_NUMERIC_BETWEEN = "@$field:[$param_0 $param_1]";
    private static final String FIELD_NUMERIC_LESS_THAN = "@$field:[-inf ($param_0]";
    private static final String FIELD_NUMERIC_LESS_THAN_EQUAL = "@$field:[-inf $param_0]";
    private static final String FIELD_NUMERIC_GREATER_THAN = "@$field:[($param_0 inf]";
    private static final String FIELD_NUMERIC_GREATER_THAN_EQUAL = "@$field:[$param_0 inf]";
    private static final String FIELD_NUMERIC_BEFORE = "@$field:[-inf ($param_0]";
    private static final String FIELD_NUMERIC_AFTER = "@$field:[($param_0 inf]";
    private static final String FIELD_GEO_NEAR = "@$field:[$param_0 $param_1 $param_2]";
    private static final String FIELD_IS_NULL = "!exists(@$field)";
    private static final String FIELD_IS_NOT_NULL = "exists(@$field)";
    private final QueryClauseTemplate clauseTemplate;
    private final MappingRedisOMConverter converter = new MappingRedisOMConverter();

    private QueryClause(QueryClauseTemplate value) {
        this.clauseTemplate = value;
    }

    public static QueryClause get(Schema.FieldType fieldType, Part.Type partType) {
        try {
            return QueryClause.valueOf(fieldType.toString() + "_" + partType.name());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return TAG_SIMPLE_PROPERTY;
        }
    }

    public static boolean hasContainingAllClause(String methodName) {
        return CONTAINING_ALL_PATTERN.matcher(methodName).find();
    }

    public static String getPostProcessMethodName(String methodName) {
        if (QueryClause.hasContainingAllClause(methodName)) {
            Optional<String> maybeMatchSubstring = CONTAINING_ALL_PATTERN.matcher(methodName).results().map(mr -> mr.group(1)).findFirst();
            if (maybeMatchSubstring.isPresent()) {
                String matchSubstring = maybeMatchSubstring.get();
                return methodName.replace(matchSubstring, methodNameMap.get(matchSubstring));
            }
            return methodName;
        }
        return methodName;
    }

    public QueryClauseTemplate getClauseTemplate() {
        return this.clauseTemplate;
    }

    public String prepareQuery(String field, Object ... params) {
        String prepared = field.equalsIgnoreCase("__ALL__") ? this.clauseTemplate.getQuerySegmentTemplate() : this.clauseTemplate.getQuerySegmentTemplate().replace("$field", field);
        Iterator<Object> iter = Arrays.asList(params).iterator();
        int i = 0;
        block8: while (iter.hasNext()) {
            String paramClass;
            Object param = iter.next();
            switch (paramClass = param.getClass().getName()) {
                case "org.springframework.data.geo.Point": {
                    Point point = (Point)param;
                    prepared = prepared.replace(PARAM_PREFIX + i++, Double.toString(point.getX()));
                    prepared = prepared.replace(PARAM_PREFIX + i++, Double.toString(point.getY()));
                    continue block8;
                }
                case "org.springframework.data.geo.Distance": {
                    Distance distance = (Distance)param;
                    prepared = prepared.replace(PARAM_PREFIX + i++, ObjectUtils.getDistanceAsRedisString(distance));
                    continue block8;
                }
            }
            if (param instanceof Collection) {
                Collection c = (Collection)param;
                String value = this == TAG_CONTAINING_ALL ? c.stream().map(n -> "@" + field + ":{" + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + "}").collect(Collectors.joining(" ")) : (this == NUMERIC_CONTAINING ? c.stream().map(n -> "@" + field + ":[" + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + " " + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + "]").collect(Collectors.joining("|")) : (this == NUMERIC_CONTAINING_ALL ? c.stream().map(n -> "@" + field + ":[" + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + " " + QueryUtils.escape(ObjectUtils.asString(n, this.converter)) + "]").collect(Collectors.joining(" ")) : (this == GEO_CONTAINING ? c.stream().map(n -> {
                    Point p = (Point)n;
                    return "@" + field + ":[" + p.getX() + " " + p.getY() + " .000001 ft]";
                }).collect(Collectors.joining("|")) : (this == GEO_CONTAINING_ALL ? c.stream().map(n -> {
                    Point p = (Point)n;
                    return "@" + field + ":[" + p.getX() + " " + p.getY() + " .000001 ft]";
                }).collect(Collectors.joining(" ")) : c.stream().map(n -> QueryUtils.escape(ObjectUtils.asString(n, this.converter), false)).collect(Collectors.joining("|"))))));
                prepared = prepared.replace(PARAM_PREFIX + i++, value);
                continue;
            }
            if (this.clauseTemplate.getIndexType() == Schema.FieldType.TEXT) {
                prepared = prepared.replace(PARAM_PREFIX + i++, param.toString());
                continue;
            }
            if (this.clauseTemplate.getIndexType() == Schema.FieldType.NUMERIC && !paramClass.equalsIgnoreCase("java.time.LocalDateTime") && !paramClass.equalsIgnoreCase("java.time.LocalDate")) {
                prepared = prepared.replace(PARAM_PREFIX + i++, param.toString());
                continue;
            }
            prepared = prepared.replace(PARAM_PREFIX + i++, QueryUtils.escape(ObjectUtils.asString(param, this.converter)));
        }
        return prepared;
    }

    static {
        methodNameMap = Map.of("IsContainingAll", "IsContaining", "ContainingAll", "Containing", "ContainsAll", "Contains");
        CONTAINING_ALL_PATTERN = Pattern.compile("(IsContainingAll|ContainingAll|ContainsAll)");
    }
}

