/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.redis.om.spring.RedisOMProperties;
import com.redis.om.spring.indexing.RediSearchIndexer;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.repository.query.RedisEnhancedQuery;
import com.redis.om.spring.repository.support.RedisEnhancedRepositoryFactory;
import com.redis.om.spring.vectorize.Embedder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisEnhancedRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    @Autowired
    @Nullable
    private RedisModulesOperations<String> rmo;
    @Autowired
    @Nullable
    private RedisOperations<?, ?> redisOperations;
    @Autowired
    @Nullable
    private RediSearchIndexer indexer;
    @Autowired
    @Nullable
    private Embedder embedder;
    @Autowired
    private RedisOMProperties properties;
    @Nullable
    private KeyValueOperations operations;
    @Nullable
    private Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    @Nullable
    private Class<? extends RepositoryQuery> repositoryQueryType;

    public RedisEnhancedRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    private void setFeatureExtractor(Embedder embedder) {
        Assert.notNull(this.rmo, (String)"FeatureExtractor must not be null!");
        this.embedder = embedder;
    }

    public void setKeyValueOperations(KeyValueOperations operations) {
        Assert.notNull((Object)operations, (String)"KeyValueOperations must not be null!");
        this.operations = operations;
    }

    public void setRedisModulesOperations(RedisModulesOperations<?> rmo) {
        Assert.notNull(rmo, (String)"RedisModulesOperations must not be null!");
        this.rmo = rmo;
    }

    public void setRedisOperations(RedisOperations<?, ?> redisOperations) {
        Assert.notNull(redisOperations, (String)"RedisOperations must not be null!");
        this.redisOperations = redisOperations;
    }

    public void setRedisOMSpringProperties(RedisOMProperties properties) {
        Assert.notNull(this.redisOperations, (String)"RedisOMSpringProperties must not be null!");
        this.properties = properties;
    }

    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
    }

    public void setKeyspaceToIndexMap(RediSearchIndexer keyspaceToIndexMap) {
        this.indexer = keyspaceToIndexMap;
    }

    public void setQueryCreator(Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
        this.queryCreator = queryCreator;
    }

    public void setQueryType(Class<? extends RepositoryQuery> repositoryQueryType) {
        Assert.notNull(this.queryCreator, (String)"Query creator type must not be null!");
        this.repositoryQueryType = repositoryQueryType;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        return this.createRepositoryFactory(this.operations, this.queryCreator, this.repositoryQueryType);
    }

    protected RedisEnhancedRepositoryFactory createRepositoryFactory(KeyValueOperations operations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType) {
        return new RedisEnhancedRepositoryFactory(operations, this.redisOperations, this.rmo, this.indexer, this.embedder, queryCreator, RedisEnhancedQuery.class, this.properties);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.operations, (String)"KeyValueOperations must not be null!");
        Assert.notNull(this.redisOperations, (String)"RedisOperations must not be null!");
        Assert.notNull(this.rmo, (String)"RedisModulesOperations must not be null!");
        Assert.notNull(this.queryCreator, (String)"Query creator must not be null!");
        Assert.notNull(this.repositoryQueryType, (String)"RepositoryQueryType must not be null!");
        Assert.notNull((Object)this.indexer, (String)"RediSearchIndexer type must not be null");
        Assert.notNull((Object)this.embedder, (String)"FeatureExtractor type must not be null!");
        super.afterPropertiesSet();
    }
}

