/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.serialization.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;

public class OffsetDateTimeTypeAdapter
implements JsonSerializer<OffsetDateTime>,
JsonDeserializer<OffsetDateTime> {
    public static OffsetDateTimeTypeAdapter getInstance() {
        return new OffsetDateTimeTypeAdapter();
    }

    public JsonElement serialize(OffsetDateTime offsetDateTime, Type typeOfSrc, JsonSerializationContext context) {
        long timeInMillis = offsetDateTime.toInstant().toEpochMilli();
        return new JsonPrimitive((Number)timeInMillis);
    }

    public OffsetDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(json.getAsLong()), ZoneId.systemDefault());
    }
}

