/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.util;

import com.redis.om.spring.annotations.EnableRedisDocumentRepositories;
import com.redis.om.spring.annotations.EnableRedisEnhancedRepositories;
import com.redis.om.spring.convert.MappingRedisOMConverter;
import com.redis.om.spring.tuple.Pair;
import com.redis.om.spring.tuple.Tuples;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.geo.Distance;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.convert.Bucket;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.search.Document;
import redis.clients.jedis.search.Schema;

public class ObjectUtils {
    public static final Character REPLACEMENT_CHARACTER = Character.valueOf('_');
    static final Set<String> JAVA_LITERAL_WORDS = Set.of("true", "false", "null");
    static final Set<String> JAVA_RESERVED_WORDS = Collections.unmodifiableSet(Stream.of("const", "goto", "abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while").collect(Collectors.toSet()));
    static final Set<Class<?>> JAVA_BUILT_IN_CLASSES = Set.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Object.class, Short.class, String.class, BigDecimal.class, BigInteger.class, Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE);
    private static final ExpressionParser SPEL_EXPRESSION_PARSER = new SpelExpressionParser();
    private static final Set<String> JAVA_BUILT_IN_CLASS_WORDS = Collections.unmodifiableSet(JAVA_BUILT_IN_CLASSES.stream().map(Class::getSimpleName).collect(Collectors.toSet()));
    private static final Set<String> JAVA_USED_WORDS = Collections.unmodifiableSet(Stream.of(JAVA_LITERAL_WORDS, JAVA_RESERVED_WORDS, JAVA_BUILT_IN_CLASS_WORDS).flatMap(Collection::stream).collect(Collectors.toSet()));
    private static final Set<String> JAVA_USED_WORDS_LOWER_CASE = Collections.unmodifiableSet(JAVA_USED_WORDS.stream().map(String::toLowerCase).collect(Collectors.toSet()));

    private ObjectUtils() {
    }

    public static String getDistanceAsRedisString(Distance distance) {
        return String.format("%s %s", distance.getValue(), distance.getUnit());
    }

    public static List<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return ObjectUtils.getDeclaredFieldsTransitively(clazz).stream().filter(f -> f.isAnnotationPresent(annotationClass)).toList();
    }

    public static GeoUnit getDistanceUnit(Distance distance) {
        if (distance.getUnit().equals(RedisGeoCommands.DistanceUnit.MILES.getAbbreviation())) {
            return GeoUnit.MI;
        }
        if (distance.getUnit().equals(RedisGeoCommands.DistanceUnit.FEET.getAbbreviation())) {
            return GeoUnit.FT;
        }
        if (distance.getUnit().equals(RedisGeoCommands.DistanceUnit.KILOMETERS.getAbbreviation())) {
            return GeoUnit.KM;
        }
        return GeoUnit.M;
    }

    public static String getTargetClassName(String fullTypeClassName) {
        String[] splitted = fullTypeClassName.split(" ");
        String cls = splitted[splitted.length - 1];
        if (cls.contains("<")) {
            cls = cls.substring(0, cls.indexOf("<"));
        }
        return cls;
    }

    public static String getCollectionTargetClassName(String fullTypeClassName) {
        String[] splitted = fullTypeClassName.split(" ");
        String cls = splitted[splitted.length - 1];
        if (cls.contains("<")) {
            cls = cls.substring(cls.indexOf("<") + 1, cls.indexOf(">"));
        }
        return cls;
    }

    public static String firstToLowercase(String string) {
        char[] c = string.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    public static Optional<Class<?>> getCollectionElementClass(Field field) {
        if (ObjectUtils.isCollection(field)) {
            ResolvableType collectionType = ResolvableType.forField((Field)field);
            Class elementType = collectionType.getGeneric(new int[]{0}).getRawClass();
            return elementType != null ? Optional.of(elementType) : Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<Type> getCollectionElementType(Field field) {
        if (ObjectUtils.isCollection(field)) {
            ResolvableType collectionType = ResolvableType.forField((Field)field);
            Type elementType = collectionType.getGeneric(new int[]{0}).getType();
            return Optional.of(elementType);
        }
        return Optional.empty();
    }

    public static boolean isCollection(Field field) {
        return Collection.class.isAssignableFrom(field.getType()) || Iterable.class.isAssignableFrom(field.getType());
    }

    public static boolean isCollection(Class<?> cls) {
        return Collection.class.isAssignableFrom(cls) || Iterable.class.isAssignableFrom(cls);
    }

    public static Optional<Field> getIdFieldForEntityClass(Class<?> cl) {
        return ObjectUtils.getDeclaredFieldsTransitively(cl).stream().filter(f -> f.isAnnotationPresent(Id.class)).findFirst();
    }

    public static Object getIdFieldForEntity(Object entity) {
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(entity.getClass());
        if (maybeIdField.isEmpty()) {
            return null;
        }
        Field idField = maybeIdField.get();
        String getterName = "get" + ObjectUtils.ucfirst(idField.getName());
        Method getter = ReflectionUtils.findMethod(entity.getClass(), (String)getterName);
        return getter != null ? ReflectionUtils.invokeMethod((Method)getter, (Object)entity) : null;
    }

    public static Object getIdFieldForEntity(Field idField, Object entity) {
        String getterName = "get" + ObjectUtils.ucfirst(idField.getName());
        Method getter = ReflectionUtils.findMethod(entity.getClass(), (String)getterName);
        return ReflectionUtils.invokeMethod((Method)Objects.requireNonNull(getter), (Object)entity);
    }

    public static Method getGetterForField(Class<?> cls, Field field) {
        String getterName = "get" + ObjectUtils.ucfirst(field.getName());
        return ReflectionUtils.findMethod(cls, (String)getterName);
    }

    public static Method getSetterForField(Class<?> cls, Field field) {
        String setterName = "set" + ObjectUtils.ucfirst(field.getName());
        return ReflectionUtils.findMethod(cls, (String)setterName, (Class[])new Class[]{field.getType()});
    }

    public static Object getValueForField(Field field, Object entity) {
        String getterName = "get" + ObjectUtils.ucfirst(field.getName());
        Method getter = ReflectionUtils.findMethod(entity.getClass(), (String)getterName);
        return getter != null ? ReflectionUtils.invokeMethod((Method)getter, (Object)entity) : null;
    }

    public static String ucfirst(String input) {
        return ObjectUtils.withFirst(input, first -> String.valueOf(Character.toUpperCase(first.charValue())));
    }

    public static String withFirst(String input, Function<Character, String> callback) {
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"", callback.apply(Character.valueOf(input.charAt(0))), input.subSequence(1, input.length()));
    }

    public static boolean isFirstLowerCase(String string) {
        String first = string.substring(0, 1);
        return Character.isLetter(first.charAt(0)) && first.toLowerCase().equals(first);
    }

    public static String toLowercaseFirstCharacter(String input) {
        return ObjectUtils.withFirst(input, first -> String.valueOf(Character.toLowerCase(first.charValue())));
    }

    public static String unQuote(String s) {
        Objects.requireNonNull(s);
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String toUnderscoreSeparated(String javaName) {
        Objects.requireNonNull(javaName);
        StringBuilder result = new StringBuilder();
        String input = ObjectUtils.unQuote(javaName.trim());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (result.isEmpty()) {
                result.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                result.append("_").append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String shortName(String longName) {
        String temp = longName.replace('$', '.');
        int openBrPos = temp.indexOf(60);
        String parameters = "";
        if (openBrPos > 0) {
            parameters = temp.substring(openBrPos);
            temp = temp.substring(0, openBrPos);
        }
        if (temp.contains(".")) {
            temp = temp.substring(temp.lastIndexOf(46) + 1);
        }
        return temp + parameters;
    }

    public static boolean isPropertyAnnotatedWith(Class<?> cls, String property, Class<? extends Annotation> annotationClass) {
        try {
            Field field = ReflectionUtils.findField(cls, (String)property);
            if (field == null) {
                return false;
            }
            return field.isAnnotationPresent(annotationClass);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static Object documentToObject(Document document, Class<?> returnedObjectType, MappingRedisOMConverter mappingConverter) {
        Bucket b = new Bucket();
        document.getProperties().forEach(p -> b.put((String)p.getKey(), (byte[])p.getValue()));
        return mappingConverter.read(returnedObjectType, new RedisData(b));
    }

    public static Object mapToObject(Map<String, Object> properties, Class<?> returnedObjectType, MappingRedisOMConverter mappingConverter) {
        Bucket b = new Bucket();
        properties.forEach((k, v) -> b.put(k, v.toString().getBytes()));
        return mappingConverter.read(returnedObjectType, new RedisData(b));
    }

    public static <T> T documentToEntity(Document document, Class<T> classOfT, MappingRedisOMConverter mappingConverter) {
        Bucket b = new Bucket();
        document.getProperties().forEach(p -> b.put((String)p.getKey(), (byte[])p.getValue()));
        return mappingConverter.read(classOfT, new RedisData(b));
    }

    public static String asString(Object value, MappingRedisOMConverter mappingConverter) {
        if (value instanceof String) {
            String valueAsString = (String)value;
            return valueAsString;
        }
        return (String)mappingConverter.getConversionService().convert(value, String.class);
    }

    public static Set<BeanDefinition> getBeanDefinitionsFor(ApplicationContext ac, Class ... classes) {
        HashSet<BeanDefinition> beanDefs = new HashSet<BeanDefinition>();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        for (Class cls : classes) {
            provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(cls));
        }
        List<org.springframework.data.util.Pair<EnableRedisDocumentRepositories, String>> erdrs = ObjectUtils.getEnableRedisDocumentRepositories(ac);
        for (org.springframework.data.util.Pair<EnableRedisDocumentRepositories, String> pair : erdrs) {
            EnableRedisDocumentRepositories edr = (EnableRedisDocumentRepositories)pair.getFirst();
            if (edr.basePackages().length > 0) {
                for (String string : edr.basePackages()) {
                    beanDefs.addAll(provider.findCandidateComponents(string));
                }
                continue;
            }
            if (edr.basePackageClasses().length > 0) {
                for (Class<?> clazz : edr.basePackageClasses()) {
                    beanDefs.addAll(provider.findCandidateComponents(clazz.getPackageName()));
                }
                continue;
            }
            beanDefs.addAll(provider.findCandidateComponents((String)pair.getSecond()));
        }
        List<org.springframework.data.util.Pair<EnableRedisEnhancedRepositories, String>> erers = ObjectUtils.getEnableRedisEnhancedRepositories(ac);
        for (org.springframework.data.util.Pair<EnableRedisEnhancedRepositories, String> pair : erers) {
            EnableRedisEnhancedRepositories er = (EnableRedisEnhancedRepositories)pair.getFirst();
            if (er.basePackages().length > 0) {
                for (String string : er.basePackages()) {
                    beanDefs.addAll(provider.findCandidateComponents(string));
                }
                continue;
            }
            if (er.basePackageClasses().length > 0) {
                for (Class<?> clazz : er.basePackageClasses()) {
                    beanDefs.addAll(provider.findCandidateComponents(clazz.getPackageName()));
                }
                continue;
            }
            beanDefs.addAll(provider.findCandidateComponents((String)pair.getSecond()));
        }
        return beanDefs;
    }

    public static List<org.springframework.data.util.Pair<EnableRedisDocumentRepositories, String>> getEnableRedisDocumentRepositories(ApplicationContext ac) {
        Map annotatedBeans = ac.getBeansWithAnnotation(SpringBootApplication.class);
        annotatedBeans.putAll(ac.getBeansWithAnnotation(Configuration.class));
        ArrayList<org.springframework.data.util.Pair<EnableRedisDocumentRepositories, String>> erdrs = new ArrayList<org.springframework.data.util.Pair<EnableRedisDocumentRepositories, String>>();
        for (Object ab : annotatedBeans.values()) {
            Class<?> cls = ab.getClass();
            if (!cls.isAnnotationPresent(EnableRedisDocumentRepositories.class)) continue;
            EnableRedisDocumentRepositories edr = cls.getAnnotation(EnableRedisDocumentRepositories.class);
            erdrs.add((org.springframework.data.util.Pair<EnableRedisDocumentRepositories, String>)org.springframework.data.util.Pair.of((Object)edr, (Object)cls.getPackageName()));
        }
        return erdrs;
    }

    public static List<org.springframework.data.util.Pair<EnableRedisEnhancedRepositories, String>> getEnableRedisEnhancedRepositories(ApplicationContext ac) {
        Map annotatedBeans = ac.getBeansWithAnnotation(SpringBootApplication.class);
        annotatedBeans.putAll(ac.getBeansWithAnnotation(Configuration.class));
        ArrayList<org.springframework.data.util.Pair<EnableRedisEnhancedRepositories, String>> erers = new ArrayList<org.springframework.data.util.Pair<EnableRedisEnhancedRepositories, String>>();
        for (Object ab : annotatedBeans.values()) {
            Class<?> cls = ab.getClass();
            if (!cls.isAnnotationPresent(EnableRedisEnhancedRepositories.class)) continue;
            EnableRedisEnhancedRepositories edr = cls.getAnnotation(EnableRedisEnhancedRepositories.class);
            erers.add((org.springframework.data.util.Pair<EnableRedisEnhancedRepositories, String>)org.springframework.data.util.Pair.of((Object)edr, (Object)cls.getPackageName()));
        }
        return erers;
    }

    public static List<Field> getDeclaredFieldsTransitively(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.stream(clazz.getDeclaredFields()).toList());
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static Field getDeclaredFieldTransitively(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field field = ReflectionUtils.findField(clazz, (String)fieldName);
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        return field;
    }

    public static byte[] floatArrayToByteArray(float[] input) {
        byte[] bytes = new byte[4 * input.length];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().put(input);
        return bytes;
    }

    public static byte[] longArrayToByteArray(long[] input) {
        return ObjectUtils.floatArrayToByteArray(ObjectUtils.longArrayToFloatArray(input));
    }

    public static float[] longArrayToFloatArray(long[] input) {
        float[] floats = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            floats[i] = input[i];
        }
        return floats;
    }

    public static float[] byteArrayToFloatArray(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        float[] floatArray = new float[floatBuffer.capacity()];
        floatBuffer.get(floatArray);
        return floatArray;
    }

    public static boolean isPrimitiveOfType(Class<?> clazz, Class<?> wrapper) {
        return clazz.isPrimitive() && ClassUtils.resolvePrimitiveIfNecessary(clazz) == wrapper;
    }

    public static String getKey(String keyspace, Object id) {
        String format = keyspace.endsWith(":") ? "%s%s" : "%s:%s";
        return String.format(format, keyspace, id);
    }

    public static Object getValueByPath(Object target, String path) {
        String safeSpelPath = path.replace("$.", "");
        boolean hasNestedObject = path.contains("[0:]");
        Collection<Object> value = null;
        if (!hasNestedObject) {
            safeSpelPath = safeSpelPath.replace("[*]", "").replace(".", "?.");
            value = SPEL_EXPRESSION_PARSER.parseExpression(safeSpelPath).getValue(target);
        } else {
            String[] tempParts = safeSpelPath.split("\\[0:\\]", 2);
            String[] parts = tempParts[1].split("\\.", 2);
            String leftPath = tempParts[0].replace(".", "?.");
            String rightPath = parts[1].replace(".", "?.").replace("[*]", "");
            Expression leftExp = SPEL_EXPRESSION_PARSER.parseExpression(leftPath);
            Expression rightExp = SPEL_EXPRESSION_PARSER.parseExpression(rightPath);
            Collection left = (Collection)leftExp.getValue(target);
            if (left != null && !left.isEmpty()) {
                value = ObjectUtils.flattenCollection(left.stream().map(arg_0 -> ((Expression)rightExp).getValue(arg_0)).toList());
            }
        }
        return value;
    }

    public static Collection<Object> flattenCollection(Collection<Object> inputCollection) {
        ArrayList<Object> flatList = new ArrayList<Object>();
        for (Object element : inputCollection) {
            if (element instanceof Collection) {
                flatList.addAll(ObjectUtils.flattenCollection((Collection)element));
                continue;
            }
            flatList.add(element);
        }
        return flatList;
    }

    public static String replaceIfIllegalJavaIdentifierCharacter(String word) {
        Objects.requireNonNull(word);
        if (word.isEmpty()) {
            return REPLACEMENT_CHARACTER.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c)) {
                    sb.append(c);
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) {
                    sb.append(REPLACEMENT_CHARACTER).append(c);
                    continue;
                }
                sb.append(REPLACEMENT_CHARACTER);
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append(REPLACEMENT_CHARACTER);
        }
        return sb.toString();
    }

    public static String staticField(String externalName) {
        Objects.requireNonNull(externalName);
        return ObjectUtils.toUnderscoreSeparated(ObjectUtils.javaNameFromExternal(externalName)).toUpperCase();
    }

    public static String javaNameFromExternal(String externalName) {
        Objects.requireNonNull(externalName);
        return ObjectUtils.replaceIfIllegalJavaIdentifierCharacter(ObjectUtils.replaceIfJavaUsedWord(ObjectUtils.nameFromExternal(externalName)));
    }

    public static String nameFromExternal(String externalName) {
        Objects.requireNonNull(externalName);
        String result = ObjectUtils.unQuote(externalName.trim());
        result = Stream.of(result.replaceAll("(\\p{Lu}+)", "_$1").split("[^\\pL\\d]")).map(String::toLowerCase).map(ObjectUtils::ucfirst).collect(Collectors.joining());
        return result;
    }

    public static String replaceIfJavaUsedWord(String word) {
        Objects.requireNonNull(word);
        if (JAVA_USED_WORDS_LOWER_CASE.contains(word.toLowerCase())) {
            return word + "_";
        }
        return word;
    }

    public static String getSchemaFieldName(Schema.Field field) {
        String toStringOutput = field.toString();
        String[] parts = toStringOutput.split("'");
        if (parts.length > 1) {
            String[] nameParts = parts[1].split(" AS ");
            return nameParts[0];
        }
        return "";
    }

    public static String getSchemaFieldType(Schema.Field field) {
        String[] parts;
        String toStringOutput = field.toString();
        for (String part : parts = toStringOutput.split(", ")) {
            if (!part.startsWith("type=")) continue;
            return part.substring(5);
        }
        return "";
    }

    public static byte[] doubleListToByteArray(List<Double> doubleList) {
        byte[] bytes = new byte[4 * doubleList.size()];
        float[] input = ObjectUtils.doubleListToFloatArray(doubleList);
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().put(input);
        return bytes;
    }

    public static float[] doubleListToFloatArray(List<Double> doubleList) {
        float[] floatArray = new float[doubleList.size()];
        for (int i = 0; i < doubleList.size(); ++i) {
            floatArray[i] = doubleList.get(i).floatValue();
        }
        return floatArray;
    }

    public static Pair<Boolean, String> isInnerClassWithEnclosing(Element element) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement.getKind() == ElementKind.CLASS) {
            return Tuples.of(true, enclosingElement.getSimpleName().toString());
        }
        return Tuples.of(false, null);
    }

    public static List<String> getAllProperties(Class<?> entityType) {
        ArrayList<String> properties = new ArrayList<String>();
        for (Field field : entityType.getDeclaredFields()) {
            properties.add(field.getName());
        }
        return properties;
    }

    public static boolean shouldIncludeProperty(ExampleMatcher matcher, String propertyName) {
        ExampleMatcher.PropertySpecifier specifier = matcher.getPropertySpecifiers().getForPath(propertyName);
        if (specifier != null) {
            return true;
        }
        return !matcher.isIgnoredPath(propertyName);
    }

    public static Object getPropertyValue(Object object, String propertyName) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propertyName, object.getClass());
            Method getter = propertyDescriptor.getReadMethod();
            return getter.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting property value", e);
        }
    }
}

