/*
 * Decompiled with CFR 0.152.
 */
package com.scalepoint.oauth_token_client;

import com.scalepoint.oauth_token_client.CertificateUtil;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class CertificateWithPrivateKey {
    private X509Certificate certificate;
    private PrivateKey privateKey;

    public CertificateWithPrivateKey(PrivateKey privateKey, X509Certificate certificate) {
        if (!CertificateUtil.checkIfMatch(privateKey, certificate).booleanValue()) {
            throw new IllegalArgumentException("Certificate does not match private key");
        }
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

