/*
 * Decompiled with CFR 0.152.
 */
package com.scalepoint.oauth_token_client;

import com.scalepoint.oauth_token_client.CertificateUtil;
import com.scalepoint.oauth_token_client.CertificateWithPrivateKey;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.UUID;

class ClientAssertionJwtFactory {
    private final String tokenEndpointUri;
    private final String clientId;
    private final Key key;
    private final String thumbprint;

    public ClientAssertionJwtFactory(String tokenEndpointUri, String clientId, CertificateWithPrivateKey keyPair) {
        this.tokenEndpointUri = tokenEndpointUri;
        this.clientId = clientId;
        this.thumbprint = CertificateUtil.getThumbprint(keyPair.getCertificate());
        this.key = keyPair.getPrivateKey();
    }

    public String CreateAssertionToken() {
        Date now = new Date();
        Date expires = new Date(now.getTime() + 10000L);
        return Jwts.builder().setHeaderParam("typ", (Object)"JWT").setHeaderParam("x5t", (Object)this.thumbprint).setHeaderParam("kid", (Object)this.thumbprint).setIssuer(this.clientId).setSubject(this.clientId).setAudience(this.tokenEndpointUri).setId(UUID.randomUUID().toString()).setIssuedAt(now).setNotBefore(now).setExpiration(expires).signWith(SignatureAlgorithm.RS256, this.key).compact();
    }
}

