/*
 * Decompiled with CFR 0.152.
 */
package com.scalepoint.oauth_token_client;

import com.scalepoint.oauth_token_client.ClientCredentials;
import com.scalepoint.oauth_token_client.DigestUtil;
import com.scalepoint.oauth_token_client.NameValuePair;
import java.util.ArrayList;
import java.util.List;

public class ClientSecretCredentials
implements ClientCredentials {
    private final String clientId;
    private final String clientSecret;
    private final String credentialThumbprint;

    public ClientSecretCredentials(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.credentialThumbprint = DigestUtil.sha1Hex(clientId + clientSecret);
    }

    @Override
    public List<NameValuePair> getPostParams() {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("client_id", this.clientId));
        params.add(new NameValuePair("client_secret", this.clientSecret));
        return params;
    }

    @Override
    public String getCredentialThumbprint() {
        return this.credentialThumbprint;
    }
}

