/*
 * Decompiled with CFR 0.152.
 */
package com.scalepoint.oauth_token_client;

import com.scalepoint.oauth_token_client.ExpiringToken;
import com.scalepoint.oauth_token_client.TokenCache;
import com.scalepoint.oauth_token_client.TokenSource;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;

public class InMemoryTokenCache
implements TokenCache {
    private final ExpiringMap<String, String> cacheMap;
    private final ReentrantLock lock = new ReentrantLock();

    public InMemoryTokenCache() {
        this.cacheMap = ExpiringMap.builder().variableExpiration().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String cacheKey, TokenSource underlyingSource) throws IOException {
        String value;
        block5: {
            value = (String)this.cacheMap.get((Object)cacheKey);
            if (value == null) {
                this.lock.lock();
                try {
                    value = (String)this.cacheMap.get((Object)cacheKey);
                    if (value != null) break block5;
                    ExpiringToken token = underlyingSource.get();
                    value = token.getToken();
                    if (token.getExpiresInSeconds() > 0) {
                        this.cacheMap.put((Object)cacheKey, (Object)value, ExpirationPolicy.CREATED, (long)token.getExpiresInSeconds(), TimeUnit.SECONDS);
                        break block5;
                    }
                    throw new IOException("Authorization server does not provide token expiration information. Consider using NoCache or custom cache implementation to avoid performance penalty caused by locking.");
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return value;
    }
}

