/*
 * Decompiled with CFR 0.152.
 */
package com.scalepoint.oauth_token_client;

import com.scalepoint.oauth_token_client.ClientCredentials;
import com.scalepoint.oauth_token_client.CustomGrantTokenClient;
import com.scalepoint.oauth_token_client.NameValuePair;
import com.scalepoint.oauth_token_client.NoCache;
import com.scalepoint.oauth_token_client.ResourceScopedAccessGrantParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ResourceScopedAccessGrantTokenClient
extends CustomGrantTokenClient {
    public ResourceScopedAccessGrantTokenClient(String tokenEndpointUri, ClientCredentials clientCredentials) {
        super(tokenEndpointUri, clientCredentials, new NoCache());
    }

    public String getToken(ResourceScopedAccessGrantParameters parameters) throws IOException {
        return this.getTokenInternal(this.getPostParams(parameters), parameters.getScope());
    }

    private List<NameValuePair> getPostParams(ResourceScopedAccessGrantParameters parameters) {
        String amr;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("resource", parameters.getResource()));
        String tenantId = parameters.getTenantId();
        if (tenantId != null) {
            params.add(new NameValuePair("tenantId", tenantId));
        }
        if ((amr = parameters.getAmrString()) != null) {
            params.add(new NameValuePair("amr", amr));
        }
        return params;
    }

    @Override
    protected String getGrantType() {
        return "urn:scalepoint:params:oauth:grant-type:resource-scoped-access";
    }
}

