/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics;

import android.annotation.SuppressLint;
import android.content.Context;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.WearableListenerService;
import com.segment.analytics.Analytics;
import com.segment.analytics.JsonUtils;
import com.segment.analytics.WearPayload;
import com.segment.analytics.WearScreenPayload;
import com.segment.analytics.WearTrackPayload;
import java.io.IOException;

@SuppressLint(value={"Registered"})
public class PhoneAnalyticsListenerService
extends WearableListenerService {
    public void onMessageReceived(MessageEvent messageEvent) {
        super.onMessageReceived(messageEvent);
        if ("/analytics".equals(messageEvent.getPath())) {
            WearPayload wearPayload;
            try {
                wearPayload = new WearPayload(JsonUtils.jsonToMap((String)new String(messageEvent.getData())));
            }
            catch (IOException e) {
                this.getAnalytics().logger.print((Throwable)e, "Error deserializing payload. Skipping.", new Object[0]);
                return;
            }
            switch (wearPayload.type()) {
                case track: {
                    WearTrackPayload wearTrackPayload = wearPayload.payload(WearTrackPayload.class);
                    this.getAnalytics().track(wearTrackPayload.getEvent(), wearTrackPayload.getProperties(), null);
                    break;
                }
                case screen: {
                    WearScreenPayload wearScreenPayload = wearPayload.payload(WearScreenPayload.class);
                    this.getAnalytics().screen(wearScreenPayload.getName(), wearScreenPayload.getCategory(), wearScreenPayload.getProperties());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Only track/screen calls may be sent from Wear.");
                }
            }
        }
    }

    public Analytics getAnalytics() {
        return Analytics.with((Context)this);
    }
}

