/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics;

import android.content.Context;
import com.segment.analytics.BasePayload;
import com.segment.analytics.Properties;
import com.segment.analytics.Utils;
import com.segment.analytics.WearDispatcher;
import com.segment.analytics.WearPayload;
import com.segment.analytics.WearScreenPayload;
import com.segment.analytics.WearTrackPayload;

public class WearAnalytics {
    static final String ANALYTICS_PATH = "/analytics";
    static WearAnalytics singleton;
    final WearDispatcher dispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WearAnalytics with(Context context) {
        if (singleton != null) return singleton;
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        Class<WearAnalytics> clazz = WearAnalytics.class;
        synchronized (WearAnalytics.class) {
            if (singleton != null) return singleton;
            singleton = new WearAnalytics(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    WearAnalytics(Context context) {
        this.dispatcher = new WearDispatcher(context);
    }

    public void track(String event, Properties properties) {
        if (Utils.isNullOrEmpty((String)event)) {
            throw new IllegalArgumentException("event must not be null or empty.");
        }
        if (properties == null) {
            properties = new Properties();
        }
        this.dispatcher.dispatchPayload(new WearPayload(BasePayload.Type.track, new WearTrackPayload(event, properties)));
    }

    public void screen(String category, String name, Properties properties) {
        if (Utils.isNullOrEmpty((String)category) && Utils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("either category or name must be provided.");
        }
        if (properties == null) {
            properties = new Properties();
        }
        this.dispatcher.dispatchPayload(new WearPayload(BasePayload.Type.screen, new WearScreenPayload(category, name, properties)));
    }
}

