/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.Wearable;
import com.segment.analytics.Analytics;
import com.segment.analytics.JsonUtils;
import com.segment.analytics.WearPayload;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

class WearDispatcher {
    private static final String DISPATCHER_THREAD_NAME = "SegmentAnalytics-Wear-Dispatcher";
    final Handler handler;
    final HandlerThread dispatcherThread;
    final GoogleApiClient googleApiClient;

    WearDispatcher(Context context) {
        this.googleApiClient = new GoogleApiClient.Builder(context).addApi(Wearable.API).build();
        this.dispatcherThread = new HandlerThread(DISPATCHER_THREAD_NAME, 10);
        this.dispatcherThread.start();
        this.handler = new DispatcherHandler(this.dispatcherThread.getLooper(), this);
    }

    void dispatchPayload(WearPayload payload) {
        this.handler.sendMessage(this.handler.obtainMessage(0, (Object)payload));
    }

    void performDispatch(WearPayload payload) {
        this.googleApiClient.blockingConnect();
        for (String node : this.getNodes(this.googleApiClient)) {
            try {
                MessageApi.SendMessageResult result = (MessageApi.SendMessageResult)Wearable.MessageApi.sendMessage(this.googleApiClient, node, "/analytics", JsonUtils.mapToJson((Map)((Object)payload)).getBytes()).await();
                if (result.getStatus().isSuccess()) continue;
            }
            catch (IOException e) {}
        }
    }

    private Collection<String> getNodes(GoogleApiClient googleApiClient) {
        HashSet<String> results = new HashSet<String>();
        NodeApi.GetConnectedNodesResult nodes = (NodeApi.GetConnectedNodesResult)Wearable.NodeApi.getConnectedNodes(googleApiClient).await();
        for (Node node : nodes.getNodes()) {
            results.add(node.getId());
        }
        return results;
    }

    private static class DispatcherHandler
    extends Handler {
        static final int REQUEST_DISPATCH = 0;
        private final WearDispatcher wearDispatcher;

        public DispatcherHandler(Looper looper, WearDispatcher wearDispatcher) {
            super(looper);
            this.wearDispatcher = wearDispatcher;
        }

        public void handleMessage(final Message msg) {
            switch (msg.what) {
                case 0: {
                    WearPayload payload = (WearPayload)((Object)msg.obj);
                    this.wearDispatcher.performDispatch(payload);
                    break;
                }
                default: {
                    Analytics.HANDLER.post(new Runnable(){

                        @Override
                        public void run() {
                            throw new AssertionError((Object)("Unhandled dispatcher message." + msg.what));
                        }
                    });
                }
            }
        }
    }
}

