/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.federecio.dropwizard.swagger.SwaggerOAuth2Configuration;
import io.federecio.dropwizard.swagger.SwaggerViewConfiguration;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Contact;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.hibernate.validator.constraints.NotEmpty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SwaggerBundleConfiguration {
    @NotEmpty
    private String resourcePackage = "";
    @Nullable
    private String title;
    @Nullable
    private String version;
    @Nullable
    private String description;
    @Nullable
    private String termsOfServiceUrl;
    @Nullable
    private String contact;
    @Nullable
    private String contactEmail;
    @Nullable
    private String contactUrl;
    @Nullable
    private String license;
    @Nullable
    private String licenseUrl;
    private SwaggerViewConfiguration swaggerViewConfiguration = new SwaggerViewConfiguration();
    private SwaggerOAuth2Configuration swaggerOAuth2Configuration = new SwaggerOAuth2Configuration();
    private boolean prettyPrint = true;
    @Nullable
    private String host;
    private String contextRoot = "/";
    private String[] schemes = new String[]{"http"};
    private boolean enabled = true;
    private boolean includeSwaggerResource = true;
    @Nullable
    private String uriPrefix;

    @JsonProperty
    public String getResourcePackage() {
        return this.resourcePackage;
    }

    @JsonProperty
    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    @Nullable
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @JsonProperty
    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nullable
    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    @Nullable
    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nullable
    @JsonProperty
    public String getTermsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    @JsonProperty
    public void setTermsOfServiceUrl(@Nullable String termsOfServiceUrl) {
        this.termsOfServiceUrl = termsOfServiceUrl;
    }

    @Nullable
    @JsonProperty
    public String getContact() {
        return this.contact;
    }

    @JsonProperty
    public void setContact(@Nullable String contact) {
        this.contact = contact;
    }

    @Nullable
    @JsonProperty
    public String getContactEmail() {
        return this.contactEmail;
    }

    @JsonProperty
    public void setContactEmail(@Nullable String contactEmail) {
        this.contactEmail = contactEmail;
    }

    @Nullable
    @JsonProperty
    public String getContactUrl() {
        return this.contactUrl;
    }

    @JsonProperty
    public void setContactUrl(@Nullable String contactUrl) {
        this.contactUrl = contactUrl;
    }

    @Nullable
    @JsonProperty
    public String getLicense() {
        return this.license;
    }

    @JsonProperty
    public void setLicense(@Nullable String license) {
        this.license = license;
    }

    @Nullable
    @JsonProperty
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @JsonProperty
    public void setLicenseUrl(@Nullable String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    @Nullable
    @JsonProperty
    public String getUriPrefix() {
        return this.uriPrefix;
    }

    @JsonProperty
    public void setUriPrefix(@Nullable String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    @JsonProperty
    public SwaggerViewConfiguration getSwaggerViewConfiguration() {
        return this.swaggerViewConfiguration;
    }

    @JsonProperty
    public void setSwaggerViewConfiguration(SwaggerViewConfiguration swaggerViewConfiguration) {
        this.swaggerViewConfiguration = swaggerViewConfiguration;
    }

    @JsonProperty
    public SwaggerOAuth2Configuration getSwaggerOAuth2Configuration() {
        return this.swaggerOAuth2Configuration;
    }

    @JsonProperty(value="oauth2")
    public void setSwaggerOAuth2Configuration(SwaggerOAuth2Configuration swaggerOAuth2Configuration) {
        this.swaggerOAuth2Configuration = swaggerOAuth2Configuration;
    }

    @JsonProperty
    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @JsonProperty
    public void setIsPrettyPrint(boolean isPrettyPrint) {
        this.prettyPrint = isPrettyPrint;
    }

    @Nullable
    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(@Nullable String host) {
        this.host = host;
    }

    @JsonProperty
    public String getContextRoot() {
        return this.contextRoot;
    }

    @JsonProperty
    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    @JsonProperty
    public String[] getSchemes() {
        return Arrays.copyOf(this.schemes, this.schemes.length);
    }

    @JsonProperty
    public void setSchemes(String[] schemes) {
        this.schemes = Arrays.copyOf(schemes, schemes.length);
    }

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public void setIsEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    @JsonProperty
    public boolean isIncludeSwaggerResource() {
        return this.includeSwaggerResource;
    }

    @JsonProperty
    public void setIncludeSwaggerResource(boolean include) {
        this.includeSwaggerResource = include;
    }

    @JsonIgnore
    public BeanConfig build(String urlPattern) {
        if (Strings.isNullOrEmpty((String)this.resourcePackage)) {
            throw new IllegalStateException("Resource package needs to be specified for Swagger to correctly detect annotated resources");
        }
        BeanConfig config = new BeanConfig();
        config.setTitle(this.title);
        config.setVersion(this.version);
        config.setDescription(this.description);
        config.setContact(this.contact);
        config.setLicense(this.license);
        config.setLicenseUrl(this.licenseUrl);
        config.setTermsOfServiceUrl(this.termsOfServiceUrl);
        config.setPrettyPrint(this.prettyPrint);
        config.setBasePath(("/".equals(this.contextRoot) ? "" : this.contextRoot) + urlPattern);
        config.setResourcePackage(this.resourcePackage);
        config.setSchemes(this.schemes);
        config.setHost(this.host);
        config.setScan(true);
        if (this.contactEmail != null || this.contactUrl != null) {
            if (config.getInfo().getContact() == null) {
                config.getInfo().setContact(new Contact());
            }
            if (this.contactEmail != null) {
                config.getInfo().getContact().setEmail(this.contactEmail);
            }
            if (this.contactUrl != null) {
                config.getInfo().getContact().setUrl(this.contactUrl);
            }
        }
        return config;
    }
}

