/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import io.dropwizard.views.View;
import io.federecio.dropwizard.swagger.SwaggerOAuth2Configuration;
import io.federecio.dropwizard.swagger.SwaggerViewConfiguration;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class SwaggerView
extends View {
    private static final String SWAGGER_URI_PATH = "/swagger-static";
    private final String swaggerAssetsPath;
    private final String contextPath;
    private final SwaggerViewConfiguration viewConfiguration;
    private final SwaggerOAuth2Configuration oauth2Configuration;

    public SwaggerView(String contextRoot, String urlPattern, SwaggerViewConfiguration viewConfiguration, SwaggerOAuth2Configuration oauth2Configuration) {
        super(viewConfiguration.getTemplateUrl(), StandardCharsets.UTF_8);
        String contextRootPrefix;
        String string = contextRootPrefix = "/".equals(contextRoot) ? "" : contextRoot;
        this.swaggerAssetsPath = !contextRootPrefix.isEmpty() ? contextRootPrefix + SWAGGER_URI_PATH : (urlPattern.equals("/") ? SWAGGER_URI_PATH : urlPattern + SWAGGER_URI_PATH);
        this.contextPath = urlPattern.equals("/") ? contextRootPrefix : contextRootPrefix + urlPattern;
        this.viewConfiguration = viewConfiguration;
        this.oauth2Configuration = oauth2Configuration;
    }

    @Nullable
    public String getTitle() {
        return this.viewConfiguration.getPageTitle();
    }

    public String getSwaggerAssetsPath() {
        return this.swaggerAssetsPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @Nullable
    public String getValidatorUrl() {
        return this.viewConfiguration.getValidatorUrl();
    }

    public boolean getShowAuth() {
        return this.viewConfiguration.isShowAuth();
    }

    public boolean getShowApiSelector() {
        return this.viewConfiguration.isShowApiSelector();
    }

    public SwaggerOAuth2Configuration getOauth2Configuration() {
        return this.oauth2Configuration;
    }
}

